---
generated_at: 2026-01-27 13:05:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-testError.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/testing/common/testServiceImpl.ts` 行281-285
- E-02: `src/vs/workbench/contrib/testing/common/testServiceImpl.ts` 行238-241
- E-03: `src/vs/workbench/contrib/testing/common/testServiceImpl.ts` 行154-211 (runTests)
- E-04: `src/vs/workbench/contrib/testing/common/testServiceImpl.ts` 行214-246 (startContinuousRun)
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 行26

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | runTestsメソッドでエラー通知が発火する | E-01 | ○ |
| C-02 | startContinuousRunメソッドでエラー通知が発火する | E-02 | ○ |
| C-03 | notificationService.errorを使用する | E-01 (行284), E-02 (行240) | ○ |
| C-04 | メッセージは「An error occurred attempting to run tests: {0}」 | E-01 (localize呼び出し) | ○ |
| C-05 | エラーはfilter(isDefined)で抽出される | E-01 (行282-283) | ○ |
| C-06 | 複数エラーはjoin(' ')で連結される | E-01 (行284) | ○ |
| C-07 | TestServiceクラス内で処理される | E-03, E-04 | ○ |
| C-08 | テストコントローラーからの結果にerrorが含まれる場合に発火 | E-01 (行282-284の条件) | ○ |
| C-09 | エラーがない場合は通知しない | E-01 (if (errs.length)の条件) | ○ |
| C-10 | 通知一覧の説明と一致する | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 複数エラーがある場合の表示形式（スペース連結）が適切か確認
- [ ] テストコントローラーからのエラーメッセージに機密情報が含まれないか確認
- [ ] runTestsとstartContinuousRunの両方で同じ通知処理が行われることを確認
