---
generated_at: 2026-01-27 13:10:00
metrics:
  claims_total: 9
  claims_with_evidence: 8
  claims_without_evidence: 1
confidence_derived: 0.89
---

# 根拠レポート：26-testing.markdownPeekError.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：8 / 9、根拠なし：1
- 優先レビュー（高）
  1. **具体的なプレビューコマンド名**：testingOutputPeek.ts内で正確なコマンド名を要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/testing/browser/testingOutputPeek.ts` (Markdownプレビュー処理)
- E-02: `src/vs/platform/notification/common/notification.ts`
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 行27

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | testingOutputPeek.ts内で通知が発火する | E-01 | ○ |
| C-02 | notificationService.warnを使用する | E-01, E-02 | ○ |
| C-03 | メッセージは「Could not open markdown preview for message.」 | E-01 (localize呼び出し) | ○ |
| C-04 | 例外発生時にcatchブロックで処理される | E-01 | ○ |
| C-05 | 通知タイプは警告（warn）である | E-01 (notificationService.warn使用) | ○ |
| C-06 | Markdownプレビューコマンドは'markdown.showPreview' | **要確認** | △ |
| C-07 | テスト結果のMarkdownプレビュー開く操作で発火 | E-01 | ○ |
| C-08 | 通知にテスト内容やMarkdown内容は含まれない | E-01 (メッセージテンプレート確認) | ○ |
| C-09 | 通知一覧の説明と一致する | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- Markdownプレビューコマンドの正確な名前：testingOutputPeek.ts内でのコマンド呼び出しを詳細確認が必要
  - 候補：'markdown.showPreview' / 'markdown-preview-enhanced.openPreview' / その他

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - プレビューコマンド名の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] testingOutputPeek.ts内のMarkdownプレビューコマンド呼び出し箇所を確認
- [ ] 警告レベル（warn）の使用が適切か確認（errorではなくwarnである理由）
- [ ] Markdownプレビュー拡張機能がない場合の代替手段が提供されているか確認
