---
generated_at: 2026-01-27 13:25:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-failedToOpenUri.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/api/browser/mainThreadAuthentication.ts` 行568-592
- E-02: `src/vs/workbench/api/browser/mainThreadAuthentication.ts` 行586-589
- E-03: `src/vs/workbench/api/browser/mainThreadAuthentication.ts` 行584-585
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行30

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | $showDeviceCodeModalメソッドで通知が発火する | E-01 | ○ |
| C-02 | notificationService.errorを使用する | E-02 (行588) | ○ |
| C-03 | メッセージは「Failed to open {0}」 | E-02 (行588のlocalize呼び出し) | ○ |
| C-04 | verificationUriがパラメータとして使用される | E-02 (行588) | ○ |
| C-05 | openerService.openが失敗時にcatchブロックで処理される | E-02 | ○ |
| C-06 | clipboardService.writeTextでコードをコピーする | E-03 (行585) | ○ |
| C-07 | Copy & Continue選択後に処理が実行される | E-01 (行576-577のrun関数) | ○ |
| C-08 | dialogService.promptでモーダルを表示する | E-01 (行569-581) | ○ |
| C-09 | MainThreadAuthenticationクラス内で実装されている | E-01 | ○ |
| C-10 | 行587-589行目に実装されている | E-02 | ○ |
| C-11 | 通知一覧の説明と一致する | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] verificationUriをエラーメッセージに表示することがセキュリティ上問題ないか確認
- [ ] URI開放失敗時のフォールバック（手動コピー）がユーザーに分かりやすいか確認
- [ ] 様々な環境（Windows/Mac/Linux）でのブラウザ起動失敗ケースを確認
