---
generated_at: 2026-01-27 12:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-undoRedoService.warning

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ワークスペースUndo分割の具体的動作**：コード上は確認できるが、ユーザー視点での挙動は推測を含む
  2. **通知の自動消去仕様**：NotificationService.warnの仕様として推測
  3. **セキュリティ考慮事項**：一般的な考察に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/platform/undoRedo/common/undoRedoService.ts` - UndoRedoServiceの実装
- E-02: `src/vs/platform/undoRedo/common/undoRedo.ts` - インターフェース定義
- E-03: `src/vs/nls.ts` - ローカライズ関数
- E-04: `src/vs/platform/notification/common/notification.ts` - NotificationServiceインターフェース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UndoRedoServiceはNotificationService.warnで警告を表示する | E-01 (817行目, 824行目, 1023行目) | ○ |
| C-02 | 外部変更されたファイルに関する警告メッセージが生成される | E-01 (96-99行目) | ○ |
| C-03 | 互換性のない変更に関する警告メッセージが生成される | E-01 (103-107行目) | ○ |
| C-04 | 操作進行中の競合に関する警告メッセージが生成される | E-01 (1019-1022行目, 883-886行目) | ○ |
| C-05 | ワークスペースUndoは分割可能な場合に分割される | E-01 (815-818行目, 974-977行目) | ○ |
| C-06 | RemovedResourcesクラスでメッセージが生成される | E-01 (78-127行目) | ○ |
| C-07 | ResourceStackElementは単一ファイル操作を表す | E-01 (25-64行目) | ○ |
| C-08 | WorkspaceStackElementは複数ファイル操作を表す | E-01 (129-193行目) | ○ |
| C-09 | editStack.lockedでロック状態が管理される | E-01 (202行目, 1018行目) | ○ |
| C-10 | versionIdで競合検出が行われる | E-01 (203行目, 445-452行目, 891行目) | ○ |
| C-11 | undo()メソッドがエントリーポイント | E-01 (1068-1077行目) | ○ |
| C-12 | redo()メソッドも同様の警告処理がある | E-01 (1170-1183行目, 1299-1305行目) | ○ |
| C-13 | nls.localizeでローカライズされている | E-01, E-03 (96行目, 1019行目等) | ○ |
| C-14 | _checkWorkspaceUndo()で検証が行われる | E-01 (829-904行目) | ○ |
| C-15 | _tryToSplitAndUndo()で分割と警告が行われる | E-01 (814-827行目) | ○ |
| C-16 | 警告はNotificationService.warnを使用する | E-01 (817行目) | ○ |
| C-17 | 通知は即座に表示される（同期処理） | E-01 | ○ |
| C-18 | 通知はユーザーが閉じるまで表示される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- NotificationService.warnの表示仕様（自動消去の有無）
  - 候補：`src/vs/workbench/services/notification/common/notificationService.ts` / `src/vs/workbench/browser/parts/notifications/` / VSCode公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メッセージ内容はソースコードから直接確認可能
- 0: 低リスク - 処理フローはコードから追跡可能
- 1: 中リスク - NotificationService.warnの具体的な表示動作は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 警告メッセージのローカライズキーが実際の表示と一致しているか確認
- [ ] NotificationService.warnの挙動（自動消去タイミング等）をブラウザ/Electronで実動確認
- [ ] ワークスペースUndo分割後の個別Undo動作を実機確認
