---
generated_at: 2026-01-27 12:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-alreadyDebugging

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/services/textMate/browser/textMateTokenizationFeatureImpl.ts` - TextMateTokenizationFeatureの実装
- E-02: `src/vs/nls.ts` - ローカライズ関数
- E-03: `src/vs/platform/notification/common/notification.ts` - NotificationServiceインターフェース
- E-04: `src/vs/platform/progress/common/progress.ts` - ProgressServiceインターフェース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | startDebugModeメソッドがデバッグモード開始のエントリーポイント | E-01 (213行目) | ○ |
| C-02 | _debugModeフラグで状態管理される | E-01 (51行目, 214行目) | ○ |
| C-03 | 既にデバッグ中の場合NotificationService.errorが呼ばれる | E-01 (215行目) | ○ |
| C-04 | メッセージは"Already Logging."である | E-01 (215行目) | ○ |
| C-05 | nls.localizeでローカライズされている | E-01, E-02 (215行目) | ○ |
| C-06 | エラー後にreturnで早期終了する | E-01 (216行目) | ○ |
| C-07 | _debugModePrintFuncがログ出力関数として使用される | E-01 (52行目, 219行目) | ○ |
| C-08 | ProgressService.withProgressで進捗表示される | E-01, E-04 (223-250行目) | ○ |
| C-09 | Stopボタンでデバッグモードを終了できる | E-01 (226行目, 241-248行目) | ○ |
| C-10 | _debugModeはfalseに戻される | E-01 (244行目) | ○ |
| C-11 | vscodeOniguruma.setDefaultDebugCallでOnigurumaのデバッグが制御される | E-01 (234行目, 245行目) | ○ |
| C-12 | onStopコールバックが呼ばれる | E-01 (246行目) | ○ |
| C-13 | ProgressLocationはNotificationが使用される | E-01, E-04 (225行目) | ○ |
| C-14 | 2段階の進捗メッセージが表示される | E-01 (229-237行目) | ○ |
| C-15 | コンストラクタで_debugModeはfalseに初期化される | E-01 (77行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 本通知に関する情報は全てソースコードから取得可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな条件分岐による通知
- 0: 低リスク - コードが明確で追跡が容易

## 6) レビュアーチェックリスト（最小）
- [ ] startDebugModeを呼び出すコマンドの存在を確認
- [ ] 実際にデバッグモードを起動して重複起動時のエラーを確認
- [ ] ローカライズキー'alreadyDebugging'が翻訳ファイルに存在するか確認
