---
generated_at: 2026-01-27 13:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-integrityService.prompt

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/services/integrity/electron-browser/integrityService.ts` - IntegrityServiceの実装
- E-02: `src/vs/workbench/services/integrity/common/integrity.ts` - インターフェース定義
- E-03: `src/vs/nls.ts` - ローカライズ関数
- E-04: `src/vs/platform/notification/common/notification.ts` - NotificationServiceインターフェース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタで_compute()が呼び出される | E-01 (79行目) | ○ |
| C-02 | _compute()でisPure()の結果を待機する | E-01 (83行目) | ○ |
| C-03 | isPureがtrueの場合は早期終了 | E-01 (84-86行目) | ○ |
| C-04 | isPureがfalseの場合にログ警告が出力される | E-01 (88-94行目) | ○ |
| C-05 | StorageDataでdontShowPromptをチェックする | E-01 (96-99行目) | ○ |
| C-06 | _showNotification()で通知が表示される | E-01 (101行目) | ○ |
| C-07 | _isPure()でLifecyclePhase.Eventuallyを待機する | E-01 (107行目) | ○ |
| C-08 | productService.checksumsから期待値を取得する | E-01 (105行目) | ○ |
| C-09 | checksumServiceでチェックサムを計算する | E-01 (129行目) | ○ |
| C-10 | checksumFailMoreInfoUrlが存在する場合はpromptを使用 | E-01 (149-168行目) | ○ |
| C-11 | checksumFailMoreInfoUrlが存在しない場合はnotifyを使用 | E-01 (170-176行目) | ○ |
| C-12 | 通知はSeverity.Warningで表示される | E-01 (151行目, 171行目) | ○ |
| C-13 | 通知はsticky: trueで表示される | E-01 (165行目, 173行目) | ○ |
| C-14 | 通知はNotificationPriority.URGENTで表示される | E-01 (166行目, 174行目) | ○ |
| C-15 | "More Information"ボタンでURLが開かれる | E-01 (154-157行目) | ○ |
| C-16 | "Don't Show Again"ボタンでStorageに保存される | E-01 (158-162行目) | ○ |
| C-17 | IntegrityStorageでデータが永続化される | E-01 (25-56行目) | ○ |
| C-18 | nls.localizeでメッセージがローカライズされる | E-01, E-03 (148行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 本通知に関する情報は全てソースコードから取得可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 実装が明確でロジックが追跡しやすい
- 0: 低リスク - セキュリティに関する通知だが実装は標準的

## 6) レビュアーチェックリスト（最小）
- [ ] チェックサム検証が正しく動作するか確認（ファイルを意図的に変更してテスト）
- [ ] "Don't Show Again"選択後の挙動を確認
- [ ] 異なるcommitバージョンで再度警告が表示されるか確認
- [ ] checksumFailMoreInfoUrlが設定されていない場合の表示を確認
