---
generated_at: 2026-01-27 13:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-localization.prompt

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/localization/electron-browser/localization.contribution.ts` - NativeLocalizationWorkbenchContributionの実装
- E-02: `src/vs/nls.ts` - ローカライズ関数
- E-03: `src/vs/platform/notification/common/notification.ts` - NotificationServiceインターフェース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでcheckAndInstall()が呼び出される | E-01 (38行目) | ○ |
| C-02 | onDidInstallExtensionsイベントが登録される | E-01 (39行目) | ○ |
| C-03 | 言語パック拡張機能の判定が行われる | E-01 (53-54行目) | ○ |
| C-04 | 現在の言語と同じ場合は早期終了 | E-01 (54行目) | ○ |
| C-05 | Severity.Infoで通知が表示される | E-01 (59行目) | ○ |
| C-06 | productService.nameLongが使用される | E-01 (61行目) | ○ |
| C-07 | localeService.setLocale()で言語が設定される | E-01 (65-71行目) | ○ |
| C-08 | NotificationPriority.URGENTが使用される | E-01 (76行目) | ○ |
| C-09 | checkAndInstallでギャラリー検索が行われる | E-01 (118行目) | ○ |
| C-10 | 言語パック無視リストがStorageServiceで管理される | E-01 (94-100行目) | ○ |
| C-11 | galleryService.getCoreTranslation()で翻訳が取得される | E-01 (137行目) | ○ |
| C-12 | telemetryServiceでユーザーの反応が記録される | E-01 (155-164行目) | ○ |
| C-13 | Don't Show Againでストレージに保存される | E-01 (196-206行目) | ○ |
| C-14 | LANGUAGEPACK_SUGGESTION_IGNORE_STORAGE_KEYが定義されている | E-01 (24行目) | ○ |
| C-15 | extensionToInstallがnullの場合はsearchActionが使用される | E-01 (166-172行目, 193行目) | ○ |
| C-16 | NeverShowAgainScopeが設定される | E-01 (77行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 本通知に関する情報は全てソースコードから取得可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 言語パック機能は標準的な実装
- 0: 低リスク - テレメトリの使用は明示的に記載されている

## 6) レビュアーチェックリスト（最小）
- [ ] 言語パックインストール後の通知が正しく表示されるか確認
- [ ] システムロケールと異なる言語での起動時に通知が表示されるか確認
- [ ] "Don't Show Again"選択後の挙動を確認
- [ ] 設定同期による言語パックインストール時の挙動を確認
