---
generated_at: 2026-01-27 10:36:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：4-too.large.for.replaceall

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **ファイルサイズ閾値**：`isTooLargeForHeapOperation()`の具体的な閾値が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/contrib/find/browser/findController.ts` 401-411行目（replaceAll()メソッドの実装）
- E-02: `src/vs/editor/contrib/find/browser/findController.ts` 403行目（isTooLargeForHeapOperation()呼び出し）
- E-03: `src/vs/editor/contrib/find/browser/findController.ts` 404行目（警告通知の表示）
- E-04: `src/vs/editor/contrib/find/browser/findController.ts` 29行目（INotificationServiceのインポート）
- E-05: `src/vs/editor/contrib/find/browser/findController.ts` 104行目（_notificationServiceの定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | replaceAll()メソッドで全置換を実行 | E-01 | ○ |
| C-02 | isTooLargeForHeapOperation()でサイズ判定 | E-02 | ○ |
| C-03 | ファイルが大きすぎる場合に警告通知を表示 | E-03 | ○ |
| C-04 | 警告レベル（warn）で通知 | E-03 | ○ |
| C-05 | nls.localizeでローカライゼーション | E-03 | ○ |
| C-06 | NotificationServiceを使用 | E-04, E-05 | ○ |
| C-07 | 大きすぎる場合はfalseを返す | E-01 | ○ |
| C-08 | 適正サイズの場合はreplaceAll()を実行 | E-01 | ○ |
| C-09 | モデルが存在しない場合はfalseを返す | E-01 | ○ |
| C-10 | メッセージキーは'too.large.for.replaceall' | E-03 | ○ |
| C-11 | 固定メッセージで変数なし | E-03 | ○ |
| C-12 | データベースアクセスなし | E-01 | ○ |
| C-13 | リトライ機能なし | E-01 | ○ |
| C-14 | 同期処理で実行 | E-01 | ○ |
| C-15 | isTooLargeForHeapOperation()の具体的な閾値 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- `isTooLargeForHeapOperation()`メソッドの具体的な閾値（ファイルサイズの上限）
  - 候補：textModel.ts / editorOptions.ts / 関連設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 実装は単純な条件分岐と通知表示であり、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] `isTooLargeForHeapOperation()`の閾値を確認
- [ ] 多言語対応のローカライゼーションキーが正しいか確認
- [ ] 個別置換（Replace）操作との整合性を確認
