---
generated_at: 2026-01-27 13:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-mcpMigration.prompt

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/mcp/browser/mcpMigration.ts` - McpConfigMigrationContributionの実装
- E-02: `src/vs/nls.ts` - ローカライズ関数
- E-03: `src/vs/platform/notification/common/notification.ts` - NotificationServiceインターフェース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでmigrateMcpConfigが呼ばれる | E-01 (46行目) | ○ |
| C-02 | parseMcpConfigでsettings.jsonを解析 | E-01 (51行目, 125-147行目) | ○ |
| C-03 | サーバーが存在する場合にmcpManagementService.installを呼ぶ | E-01 (53行目) | ○ |
| C-04 | removeMcpConfigで旧設定を削除 | E-01 (54行目, 149-160行目) | ○ |
| C-05 | watchForMcpConfigurationでファイル監視を開始 | E-01 (59行目, 77-84行目) | ○ |
| C-06 | fileService.watchでファイルを監視 | E-01 (78行目) | ○ |
| C-07 | onDidFilesChangeで変更を検出 | E-01 (79行目) | ○ |
| C-08 | checkForMcpConfigInFileで設定の存在確認 | E-01 (81行目, 86-95行目) | ○ |
| C-09 | showMcpConfigErrorNotificationで通知を表示 | E-01 (90行目, 97-123行目) | ○ |
| C-10 | ローカル設定とリモート設定で異なるメッセージ | E-01 (98-100行目) | ○ |
| C-11 | Severity.Errorで通知される | E-01 (109行目) | ○ |
| C-12 | "Update Now"アクションが存在する | E-01 (112行目) | ○ |
| C-13 | "Open User/Remote MCP Configuration"アクションが存在する | E-01 (118行目) | ○ |
| C-14 | IMcpConfigurationインターフェースが定義されている | E-01 (26-29行目) | ○ |
| C-15 | リモート環境の設定も監視される | E-01 (61-73行目) | ○ |
| C-16 | nls.localizeでローカライズされる | E-01, E-02 (99-100行目) | ○ |
| C-17 | commandService.executeCommandでMCP設定を開く | E-01 (115-116行目, 120行目) | ○ |
| C-18 | McpCommandIds.OpenUserMcpとOpenRemoteUserMcpが使用される | E-01 (106行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 本通知に関する情報は全てソースコードから取得可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - MCP移行の実装が明確
- 0: 低リスク - ローカル/リモートの区別が適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 旧形式のMCP設定を含むsettings.jsonで通知が表示されるか確認
- [ ] "Update Now"ボタンで自動移行が正常に動作するか確認
- [ ] リモート環境での通知とアクションが正しく動作するか確認
- [ ] 移行後にsettings.jsonからMCP設定が削除されるか確認
