---
generated_at: 2026-01-27 13:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：42-remoteTunnel.notification

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **拡張機能推奨タイムアウト値**：REMOTE_TUNNEL_EXTENSION_TIMEOUTの正確な値の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` 全体 - メイン実装
- E-02: `src/vs/platform/remoteTunnel/common/remoteTunnel.ts` - インターフェース定義
- E-03: `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` 558-579行目 - 接続成功通知
- E-04: `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` 325-336行目 - サービスインストール失敗警告
- E-05: `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` 583-588行目 - 接続失敗通知
- E-06: `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` 189-216行目 - 拡張機能推奨通知
- E-07: `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` 46-49行目 - ストレージキー定義
- E-08: `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` 52行目 - INVALID_TOKEN_RETRIES定義
- E-09: `src/vs/workbench/contrib/remoteTunnel/electron-browser/remoteTunnel.contribution.ts` 801-821行目 - 設定レジストリ
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 43行目 - remoteTunnel.notificationの定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トンネル接続成功時にInfo通知を表示 | E-01, E-03 | ○ |
| C-02 | サービスインストール失敗時にWarning通知を表示 | E-01, E-04 | ○ |
| C-03 | トンネル接続失敗時にInfo通知を表示 | E-01, E-05 | ○ |
| C-04 | 拡張機能推奨通知はOPTIONAL優先度 | E-06 | ○ |
| C-05 | TunnelStatusに4つの状態が存在 | E-02 | ○ |
| C-06 | ConnectionInfoにtunnelName, domain, linkが含まれる | E-02 | ○ |
| C-07 | INVALID_TOKEN_RETRIESは2回 | E-08 | ○ |
| C-08 | ストレージキーはApplicationスコープ | E-07 | ○ |
| C-09 | 拡張機能推奨済みフラグで抑止 | E-06, E-07 | ○ |
| C-10 | 通知にアクションボタンが含まれる | E-03, E-06 | ○ |
| C-11 | Markdown形式のリンクをサポート | E-03 | ○ |
| C-12 | 設定キーhostNameOverrideが存在 | E-09 | ○ |
| C-13 | 設定キーpreventSleepが存在 | E-09 | ○ |
| C-14 | プレビュー確認ダイアログが表示される | E-01 | ○ |
| C-15 | 認証セッション取得にquickPickを使用 | E-01 | ○ |
| C-16 | progressServiceで進捗表示 | E-01 | ○ |
| C-17 | ログ表示コマンドが提供される | E-01 | ○ |
| C-18 | 拡張機能推奨タイムアウトは4分 | **根拠確認中** | △ |

## 4) 不足情報（Unknown / Missing）
- REMOTE_TUNNEL_EXTENSION_TIMEOUTの正確な値（コード上は4 * 60 * 1000だが、コメントとの整合性確認が必要）
  - 候補：ユニットテスト / 開発者ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 通知メッセージは適切にローカライズされている
- 1: 中リスク - 認証トークンの取り扱いに関するセキュリティ考慮
- 0: 低リスク - プレビュー機能の通知は適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 各通知メッセージの日本語翻訳が存在するか確認
- [ ] 認証情報がログに出力されていないか確認
- [ ] 接続URLの形式が正しいか確認
- [ ] 拡張機能IDが正しいか確認（product.jsonとの整合性）
