---
generated_at: 2026-01-27 13:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：46-editorResolver.warning

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **doHandleConflictingDefaultsの実装詳細**：プロンプトメッセージの正確な内容確認
  2. **「今後尋ねない」機能**：ストレージへの記録ロジックの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/services/editor/browser/editorResolverService.ts` 全体 - メイン実装
- E-02: `src/vs/workbench/services/editor/browser/editorResolverService.ts` 97-202行目 - resolveEditorメソッド
- E-03: `src/vs/workbench/services/editor/browser/editorResolverService.ts` 150行目 - getEditor呼び出し
- E-04: `src/vs/workbench/services/editor/browser/editorResolverService.ts` 190-193行目 - conflictingDefault処理
- E-05: `src/vs/workbench/services/editor/common/editorResolverService.ts` - インターフェース定義
- E-06: `src/vs/workbench/services/editor/browser/editorResolverService.ts` 48-50行目 - ストレージキー定義
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 47行目 - editorResolver.warningの定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | resolveEditorでエディタ解決を行う | E-02 | ○ |
| C-02 | getEditorでconflictingDefaultフラグを取得 | E-03 | ○ |
| C-03 | conflictingDefaultがtrueでdoHandleConflictingDefaults呼び出し | E-04 | ○ |
| C-04 | notificationService.promptを使用 | E-01 | ○ |
| C-05 | RegisteredEditorPriorityで優先度を定義 | E-05 | ○ |
| C-06 | editorOverrideService.conflictingDefaultsをストレージキーとして使用 | E-06 | ○ |
| C-07 | workbench.editorAssociationsで設定を保存 | E-01 | ○ |
| C-08 | findMatchingEditorで競合検出 | E-01 | ○ |
| C-09 | Warningレベルで通知 | **根拠確認中** | △ |
| C-10 | 「Don't Ask Again」オプションが存在 | **根拠確認中** | △ |
| C-11 | ProfileスコープのStorageを使用 | E-06 | ○ |
| C-12 | 設定ダイアログを開くアクションが存在 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- doHandleConflictingDefaultsメソッドの詳細実装（ファイル後半部分）
  - 候補：editorResolverService.tsの400行目以降
- プロンプトの正確なメッセージテキスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的な設定保存フロー
- 0: 低リスク - ユーザーへの影響は設定変更のみ

## 6) レビュアーチェックリスト（最小）
- [ ] doHandleConflictingDefaultsの実装を確認
- [ ] プロンプトメッセージの日本語翻訳を確認
- [ ] 「今後尋ねない」機能のストレージ記録を確認
- [ ] workbench.editorAssociationsの設定形式を確認
