---
generated_at: 2026-01-27 10:38:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：5-rename.failedApply

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **エラー発生パターン**：BulkEditService.apply()が失敗する具体的な条件の詳細が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/editor/contrib/rename/browser/rename.ts` 178-340行目（RenameController.run()メソッド）
- E-02: `src/vs/editor/contrib/rename/browser/rename.ts` 306-323行目（bulkEditService.apply()とcatch処理）
- E-03: `src/vs/editor/contrib/rename/browser/rename.ts` 321行目（エラー通知の表示）
- E-04: `src/vs/editor/contrib/rename/browser/rename.ts` 322行目（ログ出力）
- E-05: `src/vs/editor/contrib/rename/browser/rename.ts` 163行目（_notificationServiceの定義）
- E-06: `src/vs/editor/contrib/rename/browser/rename.ts` 22行目（INotificationServiceのインポート）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RenameController.run()でリネーム処理を実行 | E-01 | ○ |
| C-02 | bulkEditService.apply()で編集を適用 | E-02 | ○ |
| C-03 | 適用失敗時に.catch()でエラーハンドリング | E-02 | ○ |
| C-04 | エラーレベル（error）で通知 | E-03 | ○ |
| C-05 | nls.localizeでローカライゼーション | E-03 | ○ |
| C-06 | メッセージキーは'rename.failedApply' | E-03 | ○ |
| C-07 | NotificationServiceを使用 | E-05, E-06 | ○ |
| C-08 | LogServiceでエラー詳細をログ出力 | E-04 | ○ |
| C-09 | 固定メッセージで変数なし | E-03 | ○ |
| C-10 | 非同期処理（Promise）で実行 | E-02 | ○ |
| C-11 | リネームキャンセル時は通知せず | E-01 | ○ |
| C-12 | rejectReasonがある場合はinfo通知 | E-01 | ○ |
| C-13 | データベースアクセスなし | E-01 | ○ |
| C-14 | リトライ機能なし | E-01 | ○ |
| C-15 | F2キーでリネーム開始 | E-01 | ○ |
| C-16 | bulkEditService.apply()失敗の具体的条件 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- BulkEditService.apply()が失敗する具体的な条件
  - 候補：ファイル書き込み権限エラー / ファイルロック / ディスク容量不足

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - エラー発生時のユーザー体験に影響する可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] BulkEditService.apply()の失敗条件を確認
- [ ] 多言語対応のローカライゼーションキーが正しいか確認
- [ ] rename.failedとの違いを確認
- [ ] エラーログの出力形式を確認
