---
generated_at: 2026-01-27 13:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：50-neverShowAgain

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **ストレージキーの正確な形式**：notification.neverShowAgain.{id}の形式確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/platform/notification/common/notification.ts` 64-82行目 - NeverShowAgainScope定義
- E-02: `src/vs/platform/notification/common/notification.ts` 84-103行目 - INeverShowAgainOptions定義
- E-03: `src/vs/platform/notification/common/notification.ts` 41-62行目 - INotificationProperties定義
- E-04: `src/vs/workbench/browser/parts/notifications/notificationsToasts.ts` - 通知トースト表示
- E-05: `extensions/git/src/main.ts` 176-186行目 - Git拡張機能での使用例
- E-06: `src/vs/platform/storage/common/storage.ts` - StorageScope, StorageTarget定義
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 51行目 - neverShowAgainの定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NeverShowAgainScopeが3つの値を持つ | E-01 | ○ |
| C-02 | WORKSPACEスコープが定義されている | E-01 | ○ |
| C-03 | PROFILEスコープが定義されている | E-01 | ○ |
| C-04 | APPLICATIONスコープが定義されている（デフォルト） | E-01 | ○ |
| C-05 | INeverShowAgainOptionsにidプロパティが存在 | E-02 | ○ |
| C-06 | INeverShowAgainOptionsにisSecondaryプロパティが存在 | E-02 | ○ |
| C-07 | INeverShowAgainOptionsにscopeプロパティが存在 | E-02 | ○ |
| C-08 | INotificationPropertiesにneverShowAgainプロパティが存在 | E-03 | ○ |
| C-09 | Git拡張機能がneverShowAgainパターンを使用 | E-05 | ○ |
| C-10 | StorageScopeとStorageTargetが定義されている | E-06 | ○ |
| C-11 | 「Don't Show Again」テキストが使用される | E-05 | ○ |
| C-12 | localizeでテキストがローカライズされる | E-05 | ○ |
| C-13 | isSecondaryでアクション位置が制御される | E-02 | ○ |
| C-14 | ストレージキーの形式がnotification.neverShowAgain.{id} | **根拠確認中** | △ |

## 4) 不足情報（Unknown / Missing）
- ストレージキーの正確な形式とNotificationServiceでの実装詳細
  - 候補：`src/vs/workbench/services/notification/common/notificationService.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的なストレージ永続化パターン
- 0: 低リスク - ユーザー設定の保存であり、セキュリティリスクは低い
- 1: 中リスク - 拡張機能からのIDサニタイズが必要な可能性

## 6) レビュアーチェックリスト（最小）
- [ ] NotificationServiceでのneverShowAgain処理を確認
- [ ] ストレージキーの正確な形式を確認
- [ ] 「Don't Show Again」の日本語翻訳を確認
- [ ] 各Scopeでの実際のストレージ動作を確認
