---
generated_at: 2026-01-27 13:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 41
  claims_without_evidence: 4
confidence_derived: 0.91
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された運用マニュアルの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：41 / 45、根拠なし：4
- 優先レビュー（高）
  1. **対応ブラウザ・プラットフォーム**：公式ドキュメントからの情報であり、ソースコードからの直接確認は困難
  2. **パフォーマンス要件・制限値**：具体的な数値の根拠が不明確
  3. **エラーメッセージの日本語訳**：ソースコードの英語メッセージを日本語化しており、実際の表示と異なる可能性
  4. **ショートカットキー（macOS）**：一部のショートカットは環境依存の可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv`
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面設計書/1-ワークベンチ.md`
- E-06: `docs/code-to-docs/画面設計書/11-テキストエディタ.md`
- E-07: `docs/code-to-docs/画面設計書/20-エクスプローラービュー.md`
- E-08: `docs/code-to-docs/機能設計書/1-コード編集.md`
- E-09: `src/vs/workbench/browser/workbench.ts`
- E-10: `src/vs/editor/common/editorCommon.ts`
- E-11: `src/vs/workbench/contrib/files/browser/explorerViewlet.ts`
- E-12: `src/vs/workbench/contrib/debug/browser/debugViewlet.ts`
- E-13: `src/vs/workbench/contrib/scm/browser/scmViewPane.ts`
- E-14: `src/vs/workbench/contrib/search/browser/searchView.ts`
- E-15: `src/vs/workbench/contrib/extensions/browser/extensionsViewlet.ts`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VS Codeはソースコードエディタである | E-01, E-04 | ○ |
| C-02 | ワークベンチは複数のパーツで構成される | E-05, E-09 | ○ |
| C-03 | タイトルバー、サイドバー、エディタ、パネルの構成 | E-05 | ○ |
| C-04 | エクスプローラーでファイル操作ができる | E-02, E-07, E-11 | ○ |
| C-05 | テキストエディタでコード編集ができる | E-01, E-06, E-08 | ○ |
| C-06 | IntelliSenseでコード補完ができる | E-01 (BR-004), E-06 | ○ |
| C-07 | シンタックスハイライト機能がある | E-01 (BR-005), E-04 | ○ |
| C-08 | Undo/Redo機能がある | E-01 (BR-002), E-08 | ○ |
| C-09 | 検索・置換機能がある | E-01 (BR-003), E-04 | ○ |
| C-10 | マルチカーソル編集ができる | E-04, E-06 | ○ |
| C-11 | コードフォールディング機能がある | E-04, E-06 | ○ |
| C-12 | 定義へ移動機能がある | E-01 (BR-007), E-06 | ○ |
| C-13 | 参照検索機能がある | E-01 (BR-008), E-06 | ○ |
| C-14 | デバッグ機能がある | E-01 (BR-027-031), E-04, E-12 | ○ |
| C-15 | ブレークポイント設定ができる | E-01 (BR-028), E-02 | ○ |
| C-16 | ステップ実行ができる | E-01 (BR-029) | ○ |
| C-17 | 変数・コールスタック表示ができる | E-01 (BR-030), E-02 | ○ |
| C-18 | Git連携機能がある | E-01 (BR-041-047), E-04, E-13 | ○ |
| C-19 | ステージング・コミットができる | E-01 (BR-042, BR-043) | ○ |
| C-20 | プッシュ・プルができる | E-01 (BR-044) | ○ |
| C-21 | ブランチ管理ができる | E-01 (BR-045) | ○ |
| C-22 | 差分表示機能がある | E-01 (BR-047), E-02 | ○ |
| C-23 | 検索ビューがある | E-02, E-03, E-14 | ○ |
| C-24 | グローバル検索ができる | E-01 (BR-048) | ○ |
| C-25 | 拡張機能をインストールできる | E-01 (BR-022), E-15 | ○ |
| C-26 | 拡張機能を無効化・削除できる | E-01 (BR-023, BR-024) | ○ |
| C-27 | 設定画面で設定変更ができる | E-02, E-04 | ○ |
| C-28 | キーボードショートカットをカスタマイズできる | E-01 (BR-038), E-02 | ○ |
| C-29 | カラーテーマを変更できる | E-01 (BR-039), E-04 | ○ |
| C-30 | 統合ターミナルが使える | E-01 (BR-032), E-02 | ○ |
| C-31 | ターミナルを分割できる | E-01 (BR-034) | ○ |
| C-32 | タスク実行ができる | E-01 (BR-058) | ○ |
| C-33 | 問題パネルでエラー確認ができる | E-01 (BR-059), E-02 | ○ |
| C-34 | コマンドパレットでコマンド実行ができる | E-01 (BR-051), E-02 | ○ |
| C-35 | クイックオープンでファイルを開ける | E-01 (BR-050), E-02 | ○ |
| C-36 | ワークスペース機能がある | E-01 (BR-018, BR-019, BR-020) | ○ |
| C-37 | コードアクション（クイックフィックス）がある | E-01 (BR-009), E-06 | ○ |
| C-38 | ホバー情報表示ができる | E-01 (BR-010), E-06 | ○ |
| C-39 | コードレンズ機能がある | E-04, E-06 | ○ |
| C-40 | ミニマップ機能がある | E-01 (BR-054), E-04, E-06 | ○ |
| C-41 | ステータスバーに情報が表示される | E-01 (BR-055), E-02, E-05 | ○ |
| C-42 | 対応ブラウザはChrome/Edge/Safari/Firefox | **根拠なし** | △ |
| C-43 | パフォーマンス要件（単一文字入力16ms等） | **根拠なし** | △ |
| C-44 | エラーメッセージの日本語表記 | **根拠なし** | △ |
| C-45 | macOSのショートカットキー一覧 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **対応ブラウザ・プラットフォーム情報**
  - ソースコードに直接記載されていない
  - 候補：公式ドキュメント / package.json / README

- **パフォーマンス要件の具体的数値**
  - 機能設計書にはパフォーマンス要件が記載されているが、具体的な数値の出典が不明
  - 候補：ベンチマークテスト / 公式仕様書

- **UI文言の日本語訳**
  - ソースコードは英語ベースであり、日本語訳は推測
  - 候補：ローカライズファイル / 実際のUI確認

- **環境依存のショートカットキー**
  - macOS固有のショートカットは推測に基づく部分あり
  - 候補：keybindings.json / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）

| フラグ | リスクレベル | 内容 |
|--------|------------|------|
| RF-01 | 0: 低リスク | コード編集機能の記載（十分な根拠あり） |
| RF-02 | 0: 低リスク | ファイル管理機能の記載（十分な根拠あり） |
| RF-03 | 0: 低リスク | デバッグ機能の記載（十分な根拠あり） |
| RF-04 | 0: 低リスク | Git連携機能の記載（十分な根拠あり） |
| RF-05 | 1: 中リスク | 対応ブラウザの記載（公式情報の参照推奨） |
| RF-06 | 1: 中リスク | エラーメッセージの日本語訳（実機確認推奨） |
| RF-07 | 1: 中リスク | パフォーマンス数値（公式仕様の確認推奨） |

## 6) レビュアーチェックリスト（最小）

- [ ] 業務フローの流れ（STEP1-5）が実際の開発プロセスと一致するか
- [ ] ショートカットキーが実際のVS Codeと一致するか（特にmacOS）
- [ ] エラーメッセージの日本語訳が実際の表示と一致するか
- [ ] 対応ブラウザ・プラットフォーム情報が最新か
- [ ] 画面構成（ワークベンチ図）が実際のUIと一致するか
- [ ] 設定項目名が実際の設定画面と一致するか
- [ ] 拡張機能のインストール手順が最新のUIと一致するか
- [ ] Git操作の手順が実際のソース管理ビューと一致するか
