# Visual Studio Code 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [アプリケーションの起動・終了](#2-アプリケーションの起動終了)
3. [ワークベンチ（メイン画面）](#3-ワークベンチメイン画面)

**【業務フローに沿った機能】**
4. [【STEP1】プロジェクト準備（ワークスペース・ファイル管理）](#4-step1プロジェクト準備ワークスペースファイル管理)
5. [【STEP2】コード編集（テキストエディタ）](#5-step2コード編集テキストエディタ)
6. [【STEP3】コード検証・デバッグ](#6-step3コード検証デバッグ)
7. [【STEP4-5】バージョン管理・ビルド・テスト](#7-step4-5バージョン管理ビルドテスト)

**【サポート機能】**
8. [検索機能](#8-検索機能)
9. [拡張機能の管理](#9-拡張機能の管理)
10. [設定・カスタマイズ](#10-設定カスタマイズ)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Visual Studio Codeとは

Visual Studio Code（VS Code）は、Microsoftが開発した無料のオープンソースコードエディタです。軽量でありながら強力な機能を持ち、様々なプログラミング言語に対応しています。

**主な特徴：**
- 高速で軽量なコードエディタ
- IntelliSense（インテリセンス）によるコード補完
- 統合デバッガー
- Git統合
- 豊富な拡張機能エコシステム
- クロスプラットフォーム対応（Windows、macOS、Linux）

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **コード編集** | ソースコードの作成・編集、テキストファイルの編集、マルチカーソル編集 |
| **ファイル管理** | プロジェクトファイルの作成・削除・移動・リネーム、ワークスペース管理 |
| **コード支援** | IntelliSense補完、シンタックスハイライト、コードフォーマット、定義へ移動 |
| **デバッグ** | ブレークポイント設定、ステップ実行、変数監視、コールスタック確認 |
| **バージョン管理** | Git操作（コミット、プッシュ、プル、ブランチ管理、差分表示） |
| **ビルド・テスト** | タスク実行、テスト実行、問題パネルでのエラー確認 |

### 1.3 業務フロー概要

本システムにおける開発業務は、以下の流れで進行します：

```
+---------------------------------------------------------------------------+
|                           開発業務フロー                                    |
+---------------------------------------------------------------------------+
|                                                                           |
|  【STEP 1】プロジェクト準備                                                |
|      ワークスペースを開き、ファイル・フォルダを管理                          |
|      ↓                                                                    |
|  【STEP 2】コード編集                                                      |
|      テキストエディタでソースコードを作成・編集                              |
|      ↓                                                                    |
|  【STEP 3】コード検証・デバッグ                                            |
|      シンタックスエラーの確認、デバッガーでの実行・検証                       |
|      ↓                                                                    |
|  【STEP 4】バージョン管理                                                  |
|      Gitでの変更管理（ステージング、コミット、プッシュ）                      |
|      ↓                                                                    |
|  【STEP 5】ビルド・テスト実行                                              |
|      タスク実行、テスト実行、成果物の確認                                    |
|                                                                           |
+---------------------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **開発者** | コーディング、デバッグ、テスト作成、Git操作、コードレビュー |
| **チームリーダー** | コードレビュー、ブランチ管理、マージ操作 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| エクスプローラー | ファイル・フォルダのツリー表示と操作 | STEP 1 |
| テキストエディタ | ソースコードの編集（補完、ハイライト対応） | STEP 2 |
| デバッガー | プログラムの実行制御とデバッグ | STEP 3 |
| ソース管理 | Git操作（コミット、プッシュ等） | STEP 4 |
| タスク・テスト | ビルドタスク実行、テスト実行 | STEP 5 |
| 検索 | ワークスペース全体のテキスト検索 | 随時参照 |
| 拡張機能 | 機能拡張のインストール・管理 | 随時利用 |
| 設定 | エディタのカスタマイズ | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 一般ユーザー | ソースコードの編集、デバッグ、Git操作を行う開発者 |
| 管理者 | ワークスペース設定の管理、拡張機能の推奨設定を行う担当者 |

### 1.6 対応ブラウザ・プラットフォーム

**デスクトップアプリケーション：**
- Windows 10/11
- macOS 10.15以降
- Linux（Ubuntu、Fedora、Debian等）

**Web版（vscode.dev）対応ブラウザ：**
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

---

## 2. アプリケーションの起動・終了

### 2.1 起動方法

**方法1：アイコンから起動**

1. デスクトップまたはアプリケーション一覧から「Visual Studio Code」アイコンをダブルクリックします
2. スプラッシュ画面が表示され、ワークベンチが起動します
3. 前回開いていたワークスペースがある場合は自動的に復元されます

**方法2：コマンドラインから起動**

1. ターミナル（コマンドプロンプト）を開きます
2. 以下のコマンドを入力します：
   - フォルダを開く場合：`code /path/to/folder`
   - ファイルを開く場合：`code /path/to/file.txt`
   - 現在のフォルダを開く場合：`code .`

**方法3：ファイルの右クリックメニューから起動**

1. 開きたいフォルダまたはファイルを右クリックします
2. 「Code で開く」を選択します

### 2.2 終了方法

1. メニューバーから「ファイル」→「終了」を選択します
   - ショートカット：Ctrl+Q（Windows/Linux）、Cmd+Q（macOS）
2. 未保存のファイルがある場合は、保存確認ダイアログが表示されます
3. 「保存」「保存しない」「キャンセル」から選択します

### 2.3 ワークスペースの保存と復元

**ワークスペースの保存：**

1. メニューバーから「ファイル」→「名前を付けてワークスペースを保存」を選択します
2. ファイル名を入力し、保存先を選択します（.code-workspace 拡張子）
3. 「保存」ボタンをクリックします

**ワークスペースの復元：**

1. メニューバーから「ファイル」→「最近使用した項目を開く」を選択します
2. 最近使用したワークスペース一覧から選択します
3. または「ファイル」→「ワークスペースを開く」から.code-workspaceファイルを選択します

---

## 3. ワークベンチ（メイン画面）

### 3.1 画面構成

VS Codeのワークベンチは、以下の要素で構成されています：

```
+------------------------------------------------------------------+
|                        タイトルバー                               |
+------------------------------------------------------------------+
|                          バナー                                   |
+--------+------------------------------------------+---------------+
|        |                                          |               |
|アクティ|              エディタグループ             |   補助        |
|ビティ  |                                          |   サイドバー  |
|バー    +------------------------------------------+               |
|        |              パネル                      |               |
|サイド  |                                          |               |
|バー    |                                          |               |
+--------+------------------------------------------+---------------+
|                        ステータスバー                             |
+------------------------------------------------------------------+
```

### 3.2 各部の説明

| 要素名 | 説明 | 操作方法 |
|--------|------|----------|
| タイトルバー | ウィンドウタイトル、メニュー、ウィンドウ制御ボタン | メニューをクリックして操作 |
| アクティビティバー | サイドバーのビュー切り替えアイコン | アイコンをクリックして切り替え |
| サイドバー | エクスプローラー、検索、Git等のビュー表示 | Ctrl+B で表示/非表示 |
| エディタグループ | ファイル編集エリア（タブで管理） | タブをクリックしてファイル切り替え |
| パネル | ターミナル、出力、問題、デバッグコンソール | Ctrl+J で表示/非表示 |
| 補助サイドバー | 追加のビュー表示エリア | Ctrl+Alt+B で表示/非表示 |
| ステータスバー | 言語、エンコード、行列番号等の状態表示 | 項目をクリックして設定変更 |

### 3.3 アクティビティバーのアイコン

| アイコン | 名称 | ショートカット | 説明 |
|---------|------|---------------|------|
| ファイルアイコン | エクスプローラー | Ctrl+Shift+E | ファイルツリーの表示 |
| 虫眼鏡アイコン | 検索 | Ctrl+Shift+F | ワークスペース全体の検索 |
| 分岐アイコン | ソース管理 | Ctrl+Shift+G | Git操作パネル |
| 虫アイコン | 実行とデバッグ | Ctrl+Shift+D | デバッグパネル |
| 四角アイコン | 拡張機能 | Ctrl+Shift+X | 拡張機能の管理 |

---

## 4. 【STEP1】プロジェクト準備（ワークスペース・ファイル管理）

> **業務フローでの位置**: 開発作業の最初のステップとして、プロジェクトフォルダを開き、ファイル構造を確認・準備します。

### 4.1 フォルダを開く

**手順：**

1. メニューバーから「ファイル」→「フォルダーを開く」を選択します
   - ショートカット：Ctrl+K Ctrl+O
2. フォルダ選択ダイアログで対象フォルダを選択します
3. 「フォルダーの選択」ボタンをクリックします
4. エクスプローラーにフォルダ構造が表示されます

**注意点：**
- 初めて開くフォルダの場合、「このフォルダー内のファイルの作成者を信頼しますか？」というダイアログが表示されます
- 信頼できるフォルダの場合は「はい、作成者を信頼します」をクリックします

### 4.2 エクスプローラーでのファイル操作

**ファイルを開く：**

1. エクスプローラー（Ctrl+Shift+E）でファイルツリーを表示します
2. ファイルをシングルクリックすると「プレビューモード」で開きます（タブ名がイタリック体）
3. ファイルをダブルクリックすると「編集モード」で開きます

**新規ファイルの作成：**

1. エクスプローラーのフォルダ上で右クリックします
2. 「新しいファイル」を選択します
3. ファイル名を入力してEnterを押します
4. 新しいファイルがエディタで開きます

**新規フォルダの作成：**

1. エクスプローラーのフォルダ上で右クリックします
2. 「新しいフォルダー」を選択します
3. フォルダ名を入力してEnterを押します

**ファイル・フォルダの削除：**

1. 削除したいファイル・フォルダを選択します
2. Deleteキーを押すか、右クリックメニューから「削除」を選択します
3. 確認ダイアログで「ごみ箱に移動」または「完全に削除」を選択します

**ファイル・フォルダのリネーム：**

1. リネームしたいファイル・フォルダを選択します
2. F2キーを押すか、右クリックメニューから「名前の変更」を選択します
3. 新しい名前を入力してEnterを押します

**ファイル・フォルダの移動（ドラッグ＆ドロップ）：**

1. 移動したいファイル・フォルダをドラッグします
2. 移動先のフォルダにドロップします
3. Ctrlキーを押しながらドロップするとコピーになります

### 4.3 開いているエディターの管理

エクスプローラーの「開いているエディター」セクションでは、現在開いているファイルを一覧で確認できます。

**操作：**
- ファイル名をクリック：該当ファイルに切り替え
- ×ボタンをクリック：ファイルを閉じる
- 「すべて保存」ボタン：全ての変更を保存

---

## 5. 【STEP2】コード編集（テキストエディタ）

> **業務フローでの位置**: プロジェクト準備後、テキストエディタでソースコードを作成・編集します。

### 5.1 基本的な編集操作

**テキストの入力：**

1. エディタ内でカーソル位置にテキストを入力します
2. 入力したテキストは自動的にシンタックスハイライトされます

**基本的なショートカット：**

| 操作 | Windows/Linux | macOS |
|------|---------------|-------|
| 元に戻す（Undo） | Ctrl+Z | Cmd+Z |
| やり直し（Redo） | Ctrl+Y / Ctrl+Shift+Z | Cmd+Shift+Z |
| カット | Ctrl+X | Cmd+X |
| コピー | Ctrl+C | Cmd+C |
| ペースト | Ctrl+V | Cmd+V |
| 保存 | Ctrl+S | Cmd+S |
| すべて選択 | Ctrl+A | Cmd+A |
| 行を削除 | Ctrl+Shift+K | Cmd+Shift+K |
| 行を複製 | Shift+Alt+下 | Shift+Option+下 |
| 行を移動 | Alt+上/下 | Option+上/下 |

### 5.2 IntelliSense（コード補完）

IntelliSenseは、入力中にコード補完候補を表示する機能です。

**使用方法：**

1. コードを入力すると、自動的に補完候補が表示されます
2. 手動で表示する場合は Ctrl+Space を押します
3. 上下キーで候補を選択し、Enterまたは Tab で確定します

**補完候補の種類：**
- 変数・関数名
- クラス・メソッド
- プロパティ
- コードスニペット
- ファイルパス

### 5.3 コードナビゲーション

**定義へ移動：**

1. シンボル（変数、関数、クラス等）にカーソルを置きます
2. F12キーを押すか、Ctrl+クリックします
3. 定義元のファイル・位置に移動します

**参照検索：**

1. シンボルにカーソルを置きます
2. Shift+F12キーを押します
3. 参照箇所の一覧が表示されます
4. 一覧から選択して該当箇所に移動できます

**シンボルへ移動：**

1. Ctrl+Shift+O を押します
2. 現在のファイル内のシンボル一覧が表示されます
3. シンボル名を入力してフィルタリングし、選択します

### 5.4 検索と置換

**ファイル内検索：**

1. Ctrl+F を押して検索ボックスを開きます
2. 検索したいテキストを入力します
3. Enterキーで次の一致箇所に移動します
4. Shift+Enterで前の一致箇所に移動します

**ファイル内置換：**

1. Ctrl+H を押して置換ボックスを開きます
2. 「検索」欄に検索テキストを入力します
3. 「置換」欄に置換後テキストを入力します
4. 「置換」ボタンで1つずつ置換、「すべて置換」で一括置換します

**検索オプション：**
- 大文字と小文字を区別（Alt+C）
- 単語単位で検索（Alt+W）
- 正規表現を使用（Alt+R）

### 5.5 マルチカーソル編集

複数の箇所を同時に編集できる機能です。

**カーソルの追加：**
- Alt+クリック：クリック位置にカーソルを追加
- Ctrl+Alt+上/下：上下の行にカーソルを追加
- Ctrl+D：現在の選択と同じテキストを次に選択

**使用例：**
1. 変数名を選択します
2. Ctrl+D を複数回押して同じ名前をすべて選択します
3. 新しい名前を入力すると、すべての箇所が同時に変更されます

### 5.6 コードフォールディング（折りたたみ）

**折りたたみ操作：**
- 行番号左側の「-」アイコンをクリック：その範囲を折りたたむ
- 行番号左側の「+」アイコンをクリック：折りたたみを展開
- Ctrl+Shift+[：カーソル位置の範囲を折りたたむ
- Ctrl+Shift+]：カーソル位置の範囲を展開

---

## 6. 【STEP3】コード検証・デバッグ

> **業務フローでの位置**: コード編集後、エラーの確認とデバッグを行い、コードの品質を検証します。

### 6.1 問題パネルでのエラー確認

**問題パネルを開く：**

1. Ctrl+Shift+M を押すか、パネルの「問題」タブをクリックします
2. コード内のエラー、警告、情報が一覧表示されます
3. 項目をクリックすると該当箇所に移動します

**問題の種類：**
- エラー（赤）：コンパイルエラーなど、修正が必須の問題
- 警告（黄）：潜在的な問題、修正を推奨
- 情報（青）：参考情報

### 6.2 クイックフィックス

エラーや警告に対して自動修正を提案する機能です。

**使用方法：**

1. エラー・警告がある行にカーソルを置きます
2. 行の左側に電球アイコンが表示されます
3. 電球アイコンをクリックするか、Ctrl+. を押します
4. 修正候補の一覧から適切な修正を選択します

### 6.3 デバッグの開始

**デバッグ構成の作成：**

1. サイドバーの「実行とデバッグ」（Ctrl+Shift+D）を開きます
2. 「launch.jsonファイルを作成します」リンクをクリックします
3. デバッグ環境を選択します（Node.js、Python等）
4. 生成されたlaunch.jsonを必要に応じて編集します

**デバッグの実行：**

1. デバッグしたいファイルを開きます
2. F5キーを押してデバッグを開始します
3. または、「実行とデバッグ」パネルの「再生」ボタンをクリックします

### 6.4 ブレークポイントの設定

**ブレークポイントを設定：**

1. 停止したい行の行番号左側の余白をクリックします
2. 赤い丸印が表示され、ブレークポイントが設定されます
3. 再度クリックするとブレークポイントが削除されます

**条件付きブレークポイント：**

1. 行番号左側の余白を右クリックします
2. 「条件付きブレークポイントの追加」を選択します
3. 条件式を入力します（例：`count > 10`）

### 6.5 ステップ実行

ブレークポイントで停止後、以下の操作でコードを1行ずつ実行できます：

| 操作 | ショートカット | 説明 |
|------|---------------|------|
| 続行 | F5 | 次のブレークポイントまで実行 |
| ステップオーバー | F10 | 現在の行を実行し、次の行へ |
| ステップイン | F11 | 関数の中に入る |
| ステップアウト | Shift+F11 | 現在の関数を抜ける |
| 停止 | Shift+F5 | デバッグを終了 |
| 再起動 | Ctrl+Shift+F5 | デバッグを再開 |

### 6.6 変数の確認

デバッグ中に変数の値を確認できます：

**変数ビュー：**
- 「実行とデバッグ」パネルの「変数」セクションで現在のスコープの変数を確認

**ウォッチ式：**
- 「ウォッチ」セクションで監視したい式を追加
- 式の評価結果がリアルタイムで表示されます

**ホバー表示：**
- エディタ内で変数にカーソルを合わせると、現在の値がツールチップで表示されます

---

## 7. 【STEP4-5】バージョン管理・ビルド・テスト

> **業務フローでの位置**: コード検証後、Gitでの変更管理とビルド・テストを行い、成果物を確定します。

### 7.1 ソース管理ビュー

**ソース管理ビューを開く：**

1. アクティビティバーのソース管理アイコン（Ctrl+Shift+G）をクリックします
2. 変更されたファイルの一覧が表示されます

**ファイルの状態：**
- M（Modified）：変更あり
- U（Untracked）：新規ファイル（Git未追跡）
- D（Deleted）：削除済み
- A（Added）：ステージング済みの新規ファイル

### 7.2 変更のステージングとコミット

**変更をステージング：**

1. ソース管理ビューで変更ファイルを確認します
2. ファイル名の右側の「+」アイコンをクリックしてステージングします
3. または、ファイルを右クリックして「変更をステージ」を選択します
4. すべての変更をステージングする場合は「変更」セクションの「+」アイコンをクリックします

**コミット：**

1. ステージング済みの変更を確認します
2. 上部のメッセージ入力欄にコミットメッセージを入力します
3. Ctrl+Enter を押すか、チェックマークアイコンをクリックしてコミットします

### 7.3 プッシュとプル

**プッシュ（変更をリモートに送信）：**

1. ソース管理ビューの「...」メニューをクリックします
2. 「プッシュ」を選択します
3. または、ステータスバーの同期アイコンをクリックします

**プル（リモートの変更を取得）：**

1. ソース管理ビューの「...」メニューをクリックします
2. 「プル」を選択します

### 7.4 ブランチ管理

**ブランチの切り替え：**

1. ステータスバー左側のブランチ名をクリックします
2. ブランチ一覧から切り替え先を選択します
3. または「+ 新しいブランチを作成」を選択して新規作成します

**ブランチの作成：**

1. ステータスバーのブランチ名をクリックします
2. 「+ 新しいブランチを作成」を選択します
3. 新しいブランチ名を入力してEnterを押します

### 7.5 差分の確認

**変更差分を表示：**

1. ソース管理ビューで変更ファイルをクリックします
2. 差分エディタが開き、変更前後を比較表示します
3. 左側が変更前、右側が変更後です
4. 変更箇所はハイライト表示されます

### 7.6 タスクの実行

**タスクを実行：**

1. Ctrl+Shift+B を押してビルドタスクを実行します
2. または、メニューから「ターミナル」→「タスクの実行」を選択します
3. 実行するタスクを選択します

**タスクの設定（tasks.json）：**

1. Ctrl+Shift+P でコマンドパレットを開きます
2. 「タスク: タスクの構成」を選択します
3. tasks.jsonファイルでタスクを定義します

### 7.7 統合ターミナル

**ターミナルを開く：**

1. Ctrl+` を押してターミナルパネルを開きます
2. または、メニューから「ターミナル」→「新しいターミナル」を選択します

**複数ターミナルの管理：**
- 「+」ボタンで新しいターミナルを追加
- ドロップダウンでターミナルを切り替え
- ゴミ箱アイコンでターミナルを閉じる

---

## 8. 検索機能

### 8.1 ワークスペース全体の検索

**検索ビューを開く：**

1. アクティビティバーの検索アイコン（Ctrl+Shift+F）をクリックします
2. 検索ボックスにテキストを入力します
3. Enterを押して検索を実行します

**検索オプション：**
- 大文字と小文字を区別（Alt+C）
- 単語単位で検索（Alt+W）
- 正規表現を使用（Alt+R）

**ファイルのフィルタリング：**
- 「含めるファイル」欄でファイルパターンを指定（例：`*.ts`）
- 「除外するファイル」欄で除外パターンを指定（例：`node_modules`）

### 8.2 検索結果からの置換

1. 検索ビューで検索を実行します
2. 「置換」欄に置換後のテキストを入力します
3. 各結果の右側のアイコンで個別置換、または「すべて置換」ボタンで一括置換します

### 8.3 クイックオープン

**ファイルを素早く開く：**

1. Ctrl+P を押します
2. ファイル名の一部を入力します
3. 候補一覧から選択してEnterを押します

**クイックオープンのコマンド：**
- `>` ：コマンドパレット（コマンドを実行）
- `@` ：シンボルへ移動
- `#` ：ワークスペースのシンボルを検索
- `:` ：行番号へ移動

---

## 9. 拡張機能の管理

### 9.1 拡張機能のインストール

**拡張機能ビューを開く：**

1. アクティビティバーの拡張機能アイコン（Ctrl+Shift+X）をクリックします
2. 検索ボックスに拡張機能名を入力します
3. インストールしたい拡張機能を選択します
4. 「インストール」ボタンをクリックします

**おすすめの拡張機能：**
- 言語サポート（Python、Java、Go等）
- コードフォーマッタ（Prettier、ESLint等）
- テーマ（アイコンテーマ、カラーテーマ）
- Git関連（GitLens、Git History等）

### 9.2 拡張機能の管理

**拡張機能の無効化：**

1. 拡張機能ビューの「インストール済み」タブを開きます
2. 無効化したい拡張機能を選択します
3. 「無効にする」ボタンをクリックします

**拡張機能のアンインストール：**

1. 拡張機能を選択します
2. 「アンインストール」ボタンをクリックします
3. VS Codeを再起動すると完全に削除されます

### 9.3 拡張機能の更新

1. 拡張機能ビューで更新可能な拡張機能を確認します
2. 個別に「更新」ボタンをクリック、または「すべて更新」をクリックします

---

## 10. 設定・カスタマイズ

### 10.1 設定画面を開く

**方法1：メニューから**
- メニューバーから「ファイル」→「ユーザー設定」→「設定」を選択

**方法2：ショートカット**
- Ctrl+, を押します

### 10.2 よく使う設定項目

**エディタの外観：**
- `editor.fontSize`：フォントサイズ（デフォルト：14）
- `editor.fontFamily`：フォントファミリー
- `editor.tabSize`：タブのサイズ（デフォルト：4）
- `editor.wordWrap`：行の折り返し（off/on/wordWrapColumn/bounded）

**自動保存：**
- `files.autoSave`：自動保存の設定（off/afterDelay/onFocusChange/onWindowChange）
- `files.autoSaveDelay`：自動保存の遅延時間（ミリ秒）

**その他：**
- `editor.minimap.enabled`：ミニマップの表示（true/false）
- `editor.formatOnSave`：保存時の自動フォーマット（true/false）
- `editor.renderWhitespace`：空白文字の表示

### 10.3 キーボードショートカットのカスタマイズ

**キーボードショートカット設定を開く：**

1. Ctrl+K Ctrl+S を押します
2. 変更したいコマンドを検索します
3. コマンドを選択し、新しいキーバインドを入力します

### 10.4 カラーテーマの変更

**テーマを変更：**

1. Ctrl+K Ctrl+T を押します
2. テーマ一覧から選択します
3. 上下キーでプレビューしながら選択できます

**おすすめのテーマ：**
- Dark+（デフォルトダーク）
- Light+（デフォルトライト）
- Monokai
- Solarized Dark/Light

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
--------------------------------------------------------------
【STEP 1】プロジェクト準備 → 4章参照
    ↓
【STEP 2】コード編集 → 5章参照
    ↓
【STEP 3】コード検証・デバッグ → 6章参照
    ↓
【STEP 4】バージョン管理（Git） → 7章参照
    ↓
【STEP 5】ビルド・テスト実行 → 7章参照
--------------------------------------------------------------
```

### 11.1 【開発者】STEP1: プロジェクト準備

業務開始時に、プロジェクトフォルダを開いて作業環境を準備します。

**朝の作業開始手順：**

1. VS Codeを起動します
2. 「ファイル」→「最近使用した項目を開く」から昨日のプロジェクトを選択します
3. ターミナル（Ctrl+`）を開きます
4. `git pull` コマンドでリモートの最新変更を取得します
5. 問題パネル（Ctrl+Shift+M）でエラーがないことを確認します

### 11.2 【開発者】STEP2: コード編集

課題や機能に対応するコードを作成・編集します。

**コーディング作業の流れ：**

1. エクスプローラーで対象ファイルを開きます
2. IntelliSenseを活用しながらコードを入力します
3. 定期的にCtrl+S で保存します
4. 必要に応じてCtrl+Z でUndo、Ctrl+Y でRedoします
5. コードフォーマット（Shift+Alt+F）で整形します

### 11.3 【開発者】STEP3: コード検証・デバッグ

作成したコードのエラーを確認し、必要に応じてデバッグします。

**検証作業の流れ：**

1. 問題パネルでエラー・警告を確認します
2. エラーがある場合はクイックフィックス（Ctrl+.）を試します
3. ブレークポイントを設定してF5でデバッグを開始します
4. ステップ実行（F10/F11）で動作を確認します
5. 変数ビューで値を確認しながら問題を特定します

### 11.4 【開発者】STEP4-5: バージョン管理・ビルド・テスト

コードの変更をGitにコミットし、ビルド・テストを実行します。

**変更管理の流れ：**

1. ソース管理ビュー（Ctrl+Shift+G）を開きます
2. 変更ファイルの差分を確認します
3. 変更をステージングします
4. コミットメッセージを入力してコミットします
5. プッシュしてリモートに反映します

**ビルド・テストの流れ：**

1. Ctrl+Shift+B でビルドタスクを実行します
2. 出力パネルでビルド結果を確認します
3. テストを実行して結果を確認します
4. エラーがあれば修正してSTEP2に戻ります

---

## 12. よくある質問と対処法

### 12.1 起動・操作に関するQ&A

**Q: VS Codeの起動が遅い**

A: 以下を確認してください：
- 不要な拡張機能を無効化またはアンインストールする
- 「ファイル」→「最近使用した項目をクリア」で履歴をクリアする
- 設定で `files.watcherExclude` に大きなフォルダ（node_modules等）を追加する

**Q: エディタのフォントが見づらい**

A: 設定を変更してください：
1. Ctrl+, で設定を開きます
2. 「editor.fontSize」でフォントサイズを変更します（推奨：14-16）
3. 「editor.fontFamily」でフォントを変更します

**Q: 日本語入力がうまくいかない**

A: IME関連の設定を確認してください：
- 設定で `editor.suggest.snippetsPreventQuickSuggestions` を `false` にする
- 使用しているIMEの最新版に更新する

### 12.2 コード編集に関するQ&A

**Q: インデントがタブになってしまう**

A: 設定を変更してください：
1. ステータスバーの「タブサイズ」をクリックします
2. 「スペースによるインデント」を選択します
3. インデントサイズを選択します

**Q: コード補完が表示されない**

A: 以下を確認してください：
- 対応する言語の拡張機能がインストールされているか
- 設定で `editor.quickSuggestions` が有効になっているか
- Ctrl+Space で手動で補完を呼び出せるか

**Q: フォーマットが効かない**

A: 以下を確認してください：
- フォーマッタ拡張機能（Prettier等）がインストールされているか
- 設定で `editor.defaultFormatter` が設定されているか
- 右クリックメニューの「ドキュメントのフォーマット」を試す

### 12.3 Git・バージョン管理に関するQ&A

**Q: Gitの認証エラーが出る**

A: 以下を確認してください：
- 認証情報が正しく設定されているか
- SSHキーまたはアクセストークンが有効か
- `git config --global credential.helper` で認証ヘルパーを設定する

**Q: コンフリクトが発生した**

A: VS Codeのマージエディタを使用してください：
1. コンフリクトファイルを開きます
2. 「マージエディターで解決」をクリックします
3. 各変更を選択して適用します
4. 解決後にファイルを保存してステージングします

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| 「このフォルダー内のファイルの作成者を信頼しますか？」 | 初めて開くフォルダ | 信頼できる場合は「はい」をクリック |
| 「拡張機能ホストが予期せず終了しました」 | 拡張機能のクラッシュ | VS Codeを再起動、問題の拡張機能を無効化 |
| 「Git リポジトリではありません」 | Git初期化されていない | ターミナルで `git init` を実行 |
| 「ファイルが大きすぎるため、VS Code で開くことはできません」 | ファイルサイズ超過 | 設定で `files.maxFileSize` を増やす |
| 「読み取り専用エディター」 | ファイルに書き込み権限がない | ファイルの権限を確認、管理者権限で実行 |

### 13.2 よくあるトラブルと解決方法

**トラブル：拡張機能が動作しない**

1. 拡張機能が有効になっているか確認します
2. VS Codeを再起動します
3. 拡張機能を再インストールします
4. 拡張機能の設定を確認します
5. 他の拡張機能との競合がないか確認します

**トラブル：ターミナルが開かない**

1. 設定で `terminal.integrated.shell.*` を確認します
2. シェルパスが正しいか確認します
3. 「ターミナル」→「新しいターミナル」から開き直します
4. 別のシェルプロファイルを試します

**トラブル：エディタが重い/フリーズする**

1. 開いているファイル数を減らします
2. 不要な拡張機能を無効化します
3. 大きなファイルを開いている場合は分割します
4. 設定で `editor.minimap.enabled` を `false` にします
5. VS Codeを再起動します

**トラブル：設定が反映されない**

1. 設定ファイル（settings.json）の構文エラーを確認します
2. ユーザー設定とワークスペース設定の優先順位を確認します
3. VS Codeを再起動します
4. 設定をリセットして再設定します

### 13.3 サポートへの連絡方法

**公式サポート：**
- VS Code公式ドキュメント：https://code.visualstudio.com/docs
- GitHub Issues：https://github.com/microsoft/vscode/issues
- Stack Overflow：`visual-studio-code` タグで検索

**ログの確認方法：**
1. メニューから「ヘルプ」→「開発者ツールの切り替え」を選択します
2. 「Console」タブでエラーログを確認します
3. 必要に応じてログをコピーして報告します

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-27 | 初版作成 |

---

*本マニュアルは、Visual Studio Codeのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
