---
generated_at: 2026-01-27 13:58:00
metrics:
  claims_total: 50
  claims_with_evidence: 45
  claims_without_evidence: 5
confidence_derived: 0.90
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：45 / 50、根拠なし：5
- 優先レビュー（高）
  1. **NFT-003（ファイル読み込み時間テスト）**：具体的な合格基準「3秒以内」の根拠不足
  2. **NFT-004（拡張機能同時実行テスト）**：リソース上限値の根拠不足
  3. **NFT-041（リモート接続負荷テスト）**：接続数制限の具体的根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/base/common/performance.ts` - パフォーマンスマーク実装
- E-02: `src/vs/base/browser/performance.ts` - inputLatency測定実装
- E-03: `src/vs/base/common/errors.ts` - エラーハンドリング実装
- E-04: `src/vs/platform/encryption/common/encryptionService.ts` - 暗号化サービス定義
- E-05: `src/vs/platform/secrets/common/secrets.ts` - シークレットストレージ実装
- E-06: `src/vs/platform/telemetry/common/telemetry.ts` - テレメトリサービス定義
- E-07: `src/vs/platform/log/common/log.ts` - ロギングサービス実装
- E-08: `src/vs/base/browser/ui/aria/aria.ts` - ARIA対応実装
- E-09: `src/vs/base/common/platform.ts` - プラットフォーム検出実装
- E-10: `src/vs/base/browser/dompurify/dompurify.js` - XSS対策ライブラリ
- E-11: `src/vs/base/browser/trustedTypes.ts` - Trusted Types実装
- E-12: `package.json` - 依存関係定義
- E-13: `test/smoke/README.md` - スモークテスト仕様
- E-14: `src/vs/platform/update/electron-main/` - 自動更新実装
- E-15: `src/vs/platform/workspace/common/workspace.ts` - ワークスペース管理
- E-16: `src/vs/base/browser/indexedDB.ts` - IndexedDB操作実装
- E-17: `src/vs/platform/keybinding/common/keybindingsRegistry.ts` - キーバインド管理
- E-18: `eslint.config.js` - ESLint設定
- E-19: `src/tsconfig.json` - TypeScript設定

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エディタ起動時間テスト：5秒以内 | E-01 | ○ |
| C-02 | 入力レイテンシテスト：100ms以内 | E-02 | ○ |
| C-03 | ファイル読み込み時間テスト：3秒以内 | **根拠なし** | △ |
| C-04 | 拡張機能同時実行テスト：CPU 80%以下/メモリ2GB以下 | **根拠なし** | △ |
| C-05 | メモリ使用量監視テスト：起動時の150%以内 | E-03 (Disposable) | ○ |
| C-06 | V8ヒーププロファイリングテスト：512MB以内 | E-12 | ○ |
| C-07 | 認証トークン暗号化テスト | E-04 | ○ |
| C-08 | シークレットストレージテスト | E-05 | ○ |
| C-09 | OAuth認証フローテスト | E-05 | ○ |
| C-10 | DOMPurify XSS対策テスト | E-10 | ○ |
| C-11 | 信頼されたTypeサニタイズテスト | E-11 | ○ |
| C-12 | プラットフォーム別暗号化バックエンドテスト | E-04 | ○ |
| C-13 | 拡張機能権限制御テスト | E-12 (extensions) | ○ |
| C-14 | クラッシュレポート収集テスト | E-06 | ○ |
| C-15 | 自動更新機能テスト | E-14 | ○ |
| C-16 | ワークスペース状態復元テスト | E-15 | ○ |
| C-17 | 拡張機能ホストクラッシュ復旧テスト：5秒以内 | **根拠なし** | △ |
| C-18 | グローバルエラーハンドラテスト | E-03 | ○ |
| C-19 | キャンセレーションエラー処理テスト | E-03 | ○ |
| C-20 | BugIndicatingErrorテスト | E-03 | ○ |
| C-21 | IndexedDBトランザクションテスト | E-16 | ○ |
| C-22 | SQLiteデータベース整合性テスト | E-12 | ○ |
| C-23 | ログレベル設定テスト | E-07 | ○ |
| C-24 | ファイルログローテーションテスト：10MB超 | E-07 | ○ |
| C-25 | テレメトリ収集テスト | E-06 | ○ |
| C-26 | GDPR準拠テレメトリテスト | E-06 (gdprTypings) | ○ |
| C-27 | テレメトリレベル設定テスト | E-06 | ○ |
| C-28 | パフォーマンスマーク収集テスト | E-01 | ○ |
| C-29 | マルチプラットフォーム動作テスト | E-09 | ○ |
| C-30 | Electron/Web両対応テスト | E-09 | ○ |
| C-31 | Linux Snap環境テスト | E-09 | ○ |
| C-32 | Node.jsバージョン互換性テスト | E-12 (.nvmrc) | ○ |
| C-33 | Electronバージョン互換性テスト：Electron 39.x | E-12 | ○ |
| C-34 | ブラウザ互換性テスト | E-09 | ○ |
| C-35 | スクリーンリーダー対応テスト | E-08 | ○ |
| C-36 | ARIAアラートテスト | E-08 | ○ |
| C-37 | キーボードナビゲーションテスト | E-17 | ○ |
| C-38 | メッセージ長制限テスト：20000文字 | E-08 | ○ |
| C-39 | コンテキストメニュー応答テスト：100ms以内 | **根拠なし** | △ |
| C-40 | 国際化（i18n）テスト | E-09 | ○ |
| C-41 | リモート接続負荷テスト：5接続で安定動作 | **根拠なし** | △ |
| C-42 | 大規模ワークスペーステスト | E-12 (ripgrep) | ○ |
| C-43 | 長時間稼働テスト | E-03 (Disposable) | ○ |
| C-44 | 高頻度入力テスト | E-02 | ○ |
| C-45 | 基本機能スモークテスト | E-13 | ○ |
| C-46 | ブラウザユニットテスト | E-12 | ○ |
| C-47 | Node.jsユニットテスト | E-12 | ○ |
| C-48 | 拡張機能結合テスト | E-12 | ○ |
| C-49 | ESLint静的解析テスト | E-18 | ○ |
| C-50 | TypeScript型チェックテスト | E-19 | ○ |

## 4) 不足情報（Unknown / Missing）

- **NFT-003/C-03（ファイル読み込み時間テスト）**：具体的なパフォーマンス基準値が明示的にコード内に定義されていない
  - 候補：SLA定義書 / パフォーマンス要件定義書 / プロダクト仕様書

- **NFT-004/C-04（拡張機能同時実行テスト）**：リソース使用量の上限値がコード内に明示されていない
  - 候補：非機能要件定義書 / 内部ベンチマーク結果

- **NFT-017/C-17（拡張機能ホストクラッシュ復旧テスト）**：復旧時間の基準値が明示されていない
  - 候補：可用性要件定義書 / SLA定義書

- **NFT-039/C-39（コンテキストメニュー応答テスト）**：応答時間基準が明示されていない
  - 候補：ユーザビリティ要件定義書 / UIガイドライン

- **NFT-041/C-41（リモート接続負荷テスト）**：同時接続数の上限が明示されていない
  - 候補：スケーラビリティ要件定義書 / Remote Extension仕様書

## 5) リスクフラグ（レビュー観点）

- **リスク 2（高）**：NFT-003/004/041の合格基準が明確な根拠なく設定されている。実際の運用と乖離がある可能性
- **リスク 1（中）**：セキュリティテスト（NFT-007〜013）は実装の存在は確認できるが、暗号化強度等の具体的検証基準は要確認
- **リスク 0（低）**：アクセシビリティテスト（NFT-035〜038）はコード内に明確な実装があり、WCAG準拠の確認が容易

## 6) レビュアーチェックリスト（最小）

- [ ] NFT-003/004/041の合格基準値について、プロダクトオーナーまたはアーキテクトと確認
- [ ] セキュリティテスト（NFT-007〜013）の暗号化アルゴリズムと鍵管理方法の妥当性確認
- [ ] パフォーマンステスト（NFT-001〜006）の測定環境（ハードウェア仕様）の定義確認
- [ ] アクセシビリティテスト（NFT-035〜038）のWCAG 2.1準拠レベル（A/AA/AAA）の確認
- [ ] 負荷テスト（NFT-041〜044）の実行環境とシナリオの詳細定義確認
