---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **計画停止時間の定義**：コード内に明示的な定義なし
  2. **デフォルト再接続グレースタイム値**：ProtocolConstantsの具体値未確認
  3. **対応ブラウザの完全なリスト**：明示的なドキュメント参照なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/platform/remote/common/remoteAgentConnection.ts`
- E-02: `src/vs/platform/userDataSync/common/userDataSyncStoreService.ts`
- E-03: `src/vs/platform/files/node/diskFileSystemProvider.ts`
- E-04: `package.json`
- E-05: `src/vs/platform/backup/electron-main/backupMainService.ts`
- E-06: `src/vs/platform/encryption/electron-main/encryptionMainService.ts`
- E-07: `src/vs/platform/browserView/electron-main/browserViewMainService.ts`
- E-08: `src/vs/platform/log/common/log.ts`
- E-09: `src/vs/platform/telemetry/common/telemetry.ts`
- E-10: `src/vs/platform/telemetry/node/1dsAppender.ts`
- E-11: `src/vs/code/electron-browser/workbench/workbench.ts`
- E-12: `src/vs/platform/environment/common/argv.ts`
- E-13: `src/vs/workbench/services/extensions/common/extensions.ts`
- E-14: `src/vs/base/common/async.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソケット接続タイムアウトは10秒 | E-01 (L266: combineTimeoutCancellation with 10000ms) | ○ |
| C-02 | 再接続タイムアウトは30秒 | E-01 (L24: RECONNECT_TIMEOUT = 30 * 1000) | ○ |
| C-03 | 同期リクエストセッション間隔は5分 | E-02 (L49: REQUEST_SESSION_INTERVAL = 1000 * 60 * 5) | ○ |
| C-04 | 単体テストタイムアウトは5秒 | E-04 (L16: --timeout=5000) | ○ |
| C-05 | ウィンドウ設定解決は10秒で警告 | E-11 (L320: setTimeout 10000ms) | ○ |
| C-06 | 同期リクエスト制限は100リクエスト | E-02 (L48: REQUEST_SESSION_LIMIT = 100) | ○ |
| C-07 | 初期接続は最大5回試行 | E-01 (L438: MAX_ATTEMPTS = 5) | ○ |
| C-08 | ファイル書き込みは3回リトライ | E-03 (L596: retry 3 retries) | ○ |
| C-09 | Gulpビルドのメモリ制限は8192MB | E-04 (L37: --max-old-space-size=8192) | ○ |
| C-10 | 再接続待機は段階的に増加 | E-01 (L649: TIMES = [0, 5, 5, 10, 10, 10, 10, 10, 30]) | ○ |
| C-11 | HotExit機能でバックアップ | E-05 (L89-100: HotExitConfiguration) | ○ |
| C-12 | safeStorage APIで暗号化 | E-06 (L6, L37: safeStorage.encryptString) | ○ |
| C-13 | Windows: DPAPIを使用 | E-06 (L74: KnownStorageProvider.dplib) | ○ |
| C-14 | macOS: Keychain Accessを使用 | E-06 (L77: KnownStorageProvider.keychainAccess) | ○ |
| C-15 | BrowserViewはsandbox: true | E-07 (L83: sandbox: true in browserView.ts) | ○ |
| C-16 | 許可権限は4種類のみ | E-07 (L23-28: allowedPermissions set) | ○ |
| C-17 | ISignServiceで署名検証 | E-01 (L22, L283: signService.sign) | ○ |
| C-18 | 429エラー時にRetry-Afterを尊重 | E-02 (L561, L671-674: TooManyRequestsAndRetryAfter) | ○ |
| C-19 | Extension Host Processで分離実行 | E-13 (extensionHostKind参照) | ○ |
| C-20 | 4層アーキテクチャ | E-04 (プロジェクト構造から) | ○ |
| C-21 | createDecoratorパターンでDI | E-08 (L21: createDecorator<ILogService>) | ○ |
| C-22 | ログレベルは6段階 | E-08 (L32-39: enum LogLevel) | ○ |
| C-23 | デフォルトログレベルはInfo | E-08 (L41: DEFAULT_LOG_LEVEL = LogLevel.Info) | ○ |
| C-24 | spdlogによるログ書き込み | E-04 (@vscode/spdlog依存) | ○ |
| C-25 | IDisposableでリソース管理 | E-14 (L9: IDisposable import) | ○ |
| C-26 | Microsoft 1DSテレメトリ | E-10, E-04 (@microsoft/1ds-post-js依存) | ○ |
| C-27 | テレメトリレベルは4段階 | E-09 (L89-94: enum TelemetryLevel) | ○ |
| C-28 | クラッシュレポーターID設定 | E-12 (L118: 'crash-reporter-id') | ○ |
| C-29 | クラッシュディレクトリ設定 | E-12 (L117: 'crash-reporter-directory') | ○ |
| C-30 | クラッシュレポーター無効化オプション | E-12 (L116: 'disable-crash-reporter') | ○ |
| C-31 | native-watchdog依存 | E-04 (@vscode/native-watchdog) | ○ |
| C-32 | Electron 39.2.7使用 | E-04 (L165: electron: 39.2.7) | ○ |
| C-33 | バージョン1.109.0 | E-04 (L3: version: 1.109.0) | ○ |
| C-34 | MITライセンス | E-04 (L8: license: MIT) | ○ |
| C-35 | TypeScript使用 | E-04 (devDependencies: typescript) | ○ |
| C-36 | Gulp, Webpack使用 | E-04 (devDependencies: gulp, webpack) | ○ |
| C-37 | Mocha, Playwright使用 | E-04 (devDependencies: mocha, @playwright/test) | ○ |
| C-38 | ESLint + カスタムプラグイン | E-04 (eslint依存), プロジェクト構造 | ○ |
| C-39 | tsecによるセキュリティチェック | E-04 (L216: tsec依存) | ○ |
| C-40 | GDPRアノテーション | E-09 (L7: ClassifiedEvent, IGDPRProperty import) | ○ |
| C-41 | publicLog2への移行推奨 | E-09 (L37: @deprecated publicLog) | ○ |
| C-42 | 認証トークンデフォルト値 | E-01 (L260: '00000000000000000000') | ○ |
| C-43 | 計画停止時間の定義 | **根拠なし** | △ |
| C-44 | デフォルト再接続グレースタイム具体値 | **ProtocolConstants参照が必要** | △ |
| C-45 | 対応ブラウザ完全リスト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **計画停止時間**: コード内に明示的なダウンタイム定義がないため、運用ドキュメントまたは製品仕様書の参照が必要
  - 候補：製品ドキュメント / リリースノート / 運用マニュアル
- **再接続グレースタイムのデフォルト値**: `ProtocolConstants.ReconnectionGraceTime`の実際の値を確認する必要あり
  - 候補：`src/vs/base/parts/ipc/common/ipc.net.ts`
- **対応ブラウザの完全リスト**: 明示的なブラウザサポートマトリックスがコード内に見当たらない
  - 候補：公式ドキュメント / README.md / 製品ページ

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 性能要件（タイムアウト値、リトライ回数）- コードに明示的な定数として定義されている
- **0 (低リスク)**: セキュリティ要件（暗号化、サンドボックス）- 実装が確認できる
- **1 (中リスク)**: 可用性要件（計画停止時間、RTO/RPO）- 一部が推測に基づく
- **0 (低リスク)**: 保守性要件（ログ、テスト）- ツールとパターンが確認できる
- **0 (低リスク)**: 運用要件（テレメトリ、クラッシュレポート）- 設定とAPIが確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 性能要件のタイムアウト値がビジネス要件と整合しているか確認
- [ ] セキュリティ要件（暗号化方式、権限制御）が組織のポリシーと整合しているか確認
- [ ] 可用性要件（計画停止時間、RTO/RPO）を運用チームと確認
- [ ] テレメトリ収集がプライバシーポリシーと整合しているか確認
- [ ] クラッシュレポーター設定が本番環境に適切か確認
- [ ] ProtocolConstants.ReconnectionGraceTimeの実際の値を確認
- [ ] 対応ブラウザリストを公式ドキュメントと照合
