# 非機能要件定義書

## 概要

本ドキュメントは、Visual Studio Code (VSCode) プロジェクトのソースコードから抽出した非機能要件を定義するものである。VSCodeはMicrosoft社が開発するオープンソースのコードエディタであり、デスクトップアプリケーション（Electron）およびWebブラウザ環境で動作する。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| ソケット接続タイムアウト | 10秒以内 | `remoteAgentConnection.ts`でハンドシェイクメッセージ読み取りに10秒のタイムアウトを設定 |
| 再接続タイムアウト | 30秒以内 | `RECONNECT_TIMEOUT = 30 * 1000`として定義 |
| 同期リクエストタイムアウト | 5分以内 | `REQUEST_SESSION_INTERVAL = 1000 * 60 * 5`として定義 |
| 単体テストタイムアウト | 5秒以内 | `--timeout=5000`でMochaテスト実行 |
| ウィンドウ設定解決 | 10秒以内 | workbench.tsで10秒後に警告を出力 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同期リクエストセッション制限 | 100リクエスト/5分 | `REQUEST_SESSION_LIMIT = 100`として定義 |
| 再接続試行回数 | 最大5回 | `MAX_ATTEMPTS = 5`として初期接続時に定義 |
| ファイル書き込みリトライ | 最大3回 | `diskFileSystemProvider.ts`で100ms間隔で3回リトライ |
| メモリ制限 | 8192MB | Gulpビルド時に`--max-old-space-size=8192`を設定 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 再接続グレースタイム | 設定可能（デフォルト:ProtocolConstants.ReconnectionGraceTime） | 接続断後の再接続猶予期間を動的に設定可能 |
| 計画停止時間 | 明示的な定義なし | アップデート時の再起動が必要 |
| 障害復旧時間（RTO） | 再接続待機時間に依存 | 0, 5, 5, 10, 10, 10, 10, 10, 30秒の段階的待機 |
| 目標復旧時点（RPO） | ホットエグジット機能による自動保存 | HotExitConfiguration.ON_EXIT / ON_EXIT_AND_WINDOW_CLOSE |

### 自動復旧機能

- **再接続ループ**: 接続断検出時に自動的に再接続を試行
- **段階的待機時間**: 再接続試行間隔を0秒から30秒まで段階的に増加
- **恒久的障害検出**: `VSCODE_CONNECTION_ERROR`コードで恒久的障害を識別し、無限ループを防止
- **バックアップサービス**: `BackupMainService`によるワークスペースバックアップ管理

## セキュリティ要件

### 暗号化

| 項目 | 内容 |
| --- | --- |
| 認証情報暗号化 | Electronの`safeStorage` APIを使用 |
| プラットフォーム別ストレージ | Windows: DPAPI、macOS: Keychain Access、Linux: libsecret/gnome-keyring |
| プレーンテキストフォールバック | `--password-store=basic`オプションでプレーンテキスト暗号化を有効化可能 |

### サンドボックス

| 項目 | 内容 |
| --- | --- |
| BrowserViewサンドボックス | `sandbox: true`で全てのブラウザビューをサンドボックス化 |
| 許可される権限 | pointerLock, notifications, clipboard-read, clipboard-sanitized-write のみ |
| 権限リクエストハンドラー | 明示的に許可された権限のみコールバックで許可 |

### 認証

| 項目 | 内容 |
| --- | --- |
| 署名検証 | `ISignService`による接続認証と署名検証 |
| 接続トークン | 接続時に認証トークンを使用（デフォルト: '00000000000000000000'） |
| ハンドシェイクプロトコル | AuthRequest -> SignRequest -> ConnectionTypeRequestの3段階認証 |

### レート制限

| 項目 | 内容 |
| --- | --- |
| 同期サービス | 429 Too Many Requestsエラー時に`Retry-After`ヘッダーを尊重 |
| リクエスト抑制 | `donotMakeRequestsUntil`フラグで一時的にリクエストを停止 |

## 拡張性要件

### 拡張機能アーキテクチャ

| 項目 | 内容 |
| --- | --- |
| 拡張機能ホスト | Extension Host Processで拡張機能を分離実行 |
| WebWorker対応 | Webブラウザ環境でWebWorkerベースの拡張機能ホストをサポート |
| 複数ホストマネージャー | `ExtensionHostManagers`で複数の拡張機能ホストを管理 |
| 提案API | `extensionsProposedApi.ts`で実験的APIを管理 |

### モジュール構成

| 項目 | 内容 |
| --- | --- |
| レイヤー分離 | base, platform, workbench, editorの4層アーキテクチャ |
| 依存性注入 | `createDecorator`パターンによるサービス登録とDI |
| プラットフォーム抽象化 | browser, node, electron-main, electron-browser別の実装 |

## 保守性要件

### コード品質

| 項目 | 内容 |
| --- | --- |
| 静的解析 | ESLint + カスタムプラグイン（`.eslint-plugin-local`） |
| 型安全性 | TypeScript strictモード、tsecによるセキュリティチェック |
| テスト | Mocha + Playwright（ブラウザテスト）+ スモークテスト |

### ログ管理

| 項目 | 内容 |
| --- | --- |
| ログレベル | Off, Trace, Debug, Info, Warning, Error の6段階 |
| デフォルトログレベル | Info |
| ログサービス | `ILogService`インターフェースによる統一的なログ出力 |
| ログローテーション | spdlogによる効率的なログ書き込み |

### Disposableパターン

| 項目 | 内容 |
| --- | --- |
| リソース管理 | `IDisposable`インターフェースによる統一的なリソース解放 |
| リーク検出 | `code-ensure-no-disposables-leak-in-test`ルールでテスト時にリークを検出 |
| DisposableStore | 複数のDisposableを一括管理 |

## 運用・監視要件

### テレメトリ

| 項目 | 内容 |
| --- | --- |
| テレメトリサービス | Microsoft 1DS (One Data Strategy) を使用 |
| テレメトリレベル | NONE, CRASH, ERROR, USAGE の4段階 |
| 設定キー | `telemetry.telemetryLevel` |
| クラッシュレポーター | `telemetry.enableCrashReporter`で有効化可能 |

### GDPR対応

| 項目 | 内容 |
| --- | --- |
| GDPRアノテーション | `ClassifiedEvent`型によるテレメトリイベントの分類 |
| データ分類 | `IGDPRProperty`による個人情報の明示的な分類 |
| 廃止API | `publicLog`から`publicLog2`への移行を推奨 |

### クラッシュ管理

| 項目 | 内容 |
| --- | --- |
| クラッシュレポーターID | `--crash-reporter-id`オプションで識別子を設定 |
| クラッシュディレクトリ | `--crash-reporter-directory`でクラッシュダンプの保存先を指定 |
| 無効化オプション | `--disable-crash-reporter`でクラッシュレポートを無効化 |

### ネイティブウォッチドッグ

| 項目 | 内容 |
| --- | --- |
| 依存パッケージ | `@vscode/native-watchdog` |
| 機能 | プロセスのハングアップ検出と強制終了 |

## 備考

### 対応プラットフォーム

- Windows (x64, arm64)
- macOS (x64, arm64)
- Linux (x64, arm64)
- Webブラウザ (Chrome, Firefox, Safari, Edge)

### 技術スタック

- **ランタイム**: Electron 39.2.7 (Node.js)
- **言語**: TypeScript
- **パッケージマネージャー**: npm
- **ビルドツール**: Gulp, Webpack
- **テストフレームワーク**: Mocha, Playwright

### バージョン情報

- **プロジェクト名**: code-oss-dev
- **バージョン**: 1.109.0
- **ライセンス**: MIT
