# API設計書

## 概要

本ドキュメントは、Zigプログラミング言語コンパイラ（zig）のコマンドライン・インターフェース（CLI API）を定義する設計書です。Zigコンパイラはスタンドアロンの実行ファイルとして動作し、コマンドライン引数を通じて様々なコンパイル、ビルド、およびツールチェーン機能を提供します。

本プロジェクトはHTTPベースのWeb APIを提供していないため、本書ではCLI APIとしてのコマンドおよびオプションを文書化しています。

## 共通仕様

### ベースコマンド

```
zig [command] [options] [files]
```

### バージョン情報

- 現在のバージョン: 0.16.0

### 共通オプション

| オプション | 説明 |
| --- | --- |
| -h, --help | コマンド固有のヘルプを表示 |
| --color [auto/off/on] | カラー出力の有効/無効 |
| -j\<N\> | 並行ジョブ数の制限（デフォルトは全CPUコアを使用） |

### 終了コード

| コード | 説明 |
| --- | --- |
| 0 | 成功 |
| 1以上 | エラー（コンパイルエラー、パラメータエラーなど） |

## コマンド一覧

| カテゴリ | コマンド | 説明 |
| --- | --- | --- |
| ビルド | build | build.zigからプロジェクトをビルド |
| ビルド | fetch | パッケージをグローバルキャッシュにコピーしハッシュを出力 |
| ビルド | init | 現在のディレクトリにZigパッケージを初期化 |
| コンパイル | build-exe | ソースまたはオブジェクトファイルから実行ファイルを生成 |
| コンパイル | build-lib | ソースまたはオブジェクトファイルからライブラリを生成 |
| コンパイル | build-obj | ソースまたはオブジェクトファイルからオブジェクトを生成 |
| コンパイル | test | ユニットテストを実行 |
| コンパイル | test-obj | ユニットテスト用オブジェクトを生成 |
| コンパイル | run | 実行ファイルを生成して即座に実行 |
| ツール | ast-check | 任意のファイルセットで単純なコンパイルエラーをチェック |
| ツール | fmt | Zigソースを標準的なフォーマットに整形 |
| ツール | reduce | バグレポートを最小化 |
| ツール | translate-c | CコードをZigコードに変換 |
| 互換ツール | ar | Zigをドロップインアーカイバとして使用 |
| 互換ツール | cc | ZigをドロップインCコンパイラとして使用 |
| 互換ツール | c++ | ZigをドロップインC++コンパイラとして使用 |
| 互換ツール | dlltool | Zigをドロップインdlltool.exeとして使用 |
| 互換ツール | lib | Zigをドロップインlib.exeとして使用 |
| 互換ツール | ranlib | Zigをドロップインranlibとして使用 |
| 互換ツール | objcopy | Zigをドロップインobjcopyとして使用 |
| 互換ツール | rc | Zigをドロップインrc.exeとして使用 |
| 情報 | env | libパス、stdパス、キャッシュディレクトリ、バージョンを表示 |
| 情報 | help | ヘルプを表示して終了 |
| 情報 | std | 標準ライブラリドキュメントをブラウザで表示 |
| 情報 | libc | ネイティブlibcパスファイルを表示または検証 |
| 情報 | targets | 利用可能なコンパイルターゲットを一覧表示 |
| 情報 | version | バージョン番号を表示して終了 |
| 情報 | zen | Zigの禅を表示して終了 |

## 各コマンド定義

### ビルドコマンド

#### 1. build

build.zigからプロジェクトをビルドします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig build [options]` |
| 必須ファイル | build.zig |

**主要オプション**

| オプション | 説明 |
| --- | --- |
| -p \<path\> | インストールプレフィックスを指定 |
| --search-prefix \<path\> | 検索プレフィックスを追加 |
| --zig-lib-dir \<path\> | Zigインストールのlibディレクトリを上書き |
| -Drelease | リリースビルドを有効化 |
| -Doptimize=\<mode\> | 最適化モードを選択（Debug/ReleaseFast/ReleaseSafe/ReleaseSmall） |

---

#### 2. fetch

パッケージをグローバルキャッシュにコピーしハッシュを出力します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig fetch [options] <url/path>` |

---

#### 3. init

現在のディレクトリにZigパッケージを初期化します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig init` |
| 生成ファイル | build.zig, build.zig.zon, src/main.zig |

---

### コンパイルコマンド

#### 4. build-exe

ソースまたはオブジェクトファイルから実行ファイルを生成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig build-exe [options] [files]` |

**サポートファイルタイプ**

| 拡張子 | 説明 |
| --- | --- |
| .zig | Zigソースコード |
| .o | ELF/Mach-O/WebAssemblyオブジェクトファイル |
| .obj | COFF（Windows）オブジェクトファイル |
| .lib | COFF（Windows）スタティックライブラリ |
| .a | ELF/Mach-O/WebAssemblyスタティックライブラリ |
| .so | ELF共有オブジェクト |
| .dll | Windows DLL |
| .dylib | Mach-O（macOS）ダイナミックライブラリ |
| .tbd | （macOS）テキストベースdylib定義 |
| .s | ターゲット固有アセンブリソースコード |
| .S | Cプリプロセッサ付きアセンブリ（LLVM拡張必須） |
| .c | Cソースコード（LLVM拡張必須） |
| .cxx/.cc/.C/.cpp/.c++ | C++ソースコード（LLVM拡張必須） |
| .m | Objective-Cソースコード（LLVM拡張必須） |
| .mm | Objective-C++ソースコード（LLVM拡張必須） |
| .bc | LLVM IRモジュール（LLVM拡張必須） |

**一般オプション**

| オプション | デフォルト | 説明 |
| --- | --- | --- |
| -femit-bin[=path] | 有効 | マシンコードを出力 |
| -fno-emit-bin | - | マシンコードを出力しない |
| -femit-asm[=path] | 無効 | .s（アセンブリコード）を出力 |
| -femit-llvm-ir[=path] | 無効 | 最適化されたLLVM IRを.llファイルとして生成（LLVM拡張必須） |
| -femit-llvm-bc[=path] | 無効 | 最適化されたLLVMモジュールを.bcファイルとして生成（LLVM拡張必須） |
| -femit-h[=path] | 無効 | Cヘッダファイル（.h）を生成 |
| -femit-docs[=path] | 無効 | HTMLドキュメントを含むdocs/ディレクトリを生成 |
| -femit-implib[=path] | 有効 | Windows DLLビルド時にインポート.libを生成 |
| -fincremental | - | インクリメンタルコンパイルを有効化 |
| -fno-incremental | - | インクリメンタルコンパイルを無効化 |
| --show-builtin | - | @import("builtin")のソースを出力して終了 |
| --cache-dir [path] | - | ローカルキャッシュディレクトリを上書き |
| --global-cache-dir [path] | - | グローバルキャッシュディレクトリを上書き |
| --zig-lib-dir [path] | - | Zigインストールlibディレクトリへのパスを上書き |

**グローバルコンパイルオプション**

| オプション | 説明 |
| --- | --- |
| --name [name] | コンパイルユニット名（ファイルパスではない） |
| --libc [file] | libcパスを指定するファイルを提供 |
| -x language | 後続の入力ファイルを指定言語として扱う |
| --dep [[import=]name] | 次のモジュールのインポートテーブルにエントリを追加 |
| -M[name][=src] | 現在のモジュール設定に基づいてモジュールを作成 |
| --error-limit [num] | 異なるエラー値の最大数を設定 |
| -fllvm | LLVMをコード生成バックエンドとして強制使用 |
| -fno-llvm | LLVMをコード生成バックエンドとして使用しない |
| -flibllvm | コード生成バックエンドでLLVM APIを強制使用 |
| -fno-libllvm | コード生成バックエンドでLLVM APIを使用しない |
| -fclang | C/C++コンパイルバックエンドとしてClangを強制使用 |
| -fno-clang | C/C++コンパイルバックエンドとしてClangを使用しない |
| -fPIE | 位置独立実行ファイルを強制有効化 |
| -fno-PIE | 位置独立実行ファイルを強制無効化 |
| -flto | リンク時最適化を強制有効化（LLVM拡張必須） |
| -fno-lto | リンク時最適化を強制無効化 |
| -fdll-export-fns | エクスポート関数をDLLエクスポートとしてマーク（Windows） |
| -fno-dll-export-fns | エクスポート関数をDLLエクスポートとしてマークしない |
| -freference-trace[=num] | コンパイルエラーごとにnum行の参照トレースを表示 |
| -fno-reference-trace | 参照トレースを無効化 |
| -ffunction-sections | 各関数を別セクションに配置 |
| -fno-function-sections | 全関数を同一セクションに配置 |
| -fdata-sections | 各データを別セクションに配置 |
| -fno-data-sections | 全データを同一セクションに配置 |
| -fformatted-panics | フォーマット済み安全パニックを有効化 |
| -fno-formatted-panics | フォーマット済み安全パニックを無効化 |
| -fstructured-cfg | （SPIR-V）構造化制御フローを強制使用 |
| -fno-structured-cfg | （SPIR-V）構造化制御フローを使用しない |
| -mexec-model=[value] | （WASI）実行モデル |
| -municode | （Windows）wmain/wWinMainをエントリポイントとして使用 |
| --time-report | タイミング診断を'--listen'クライアントに送信 |

**モジュール別コンパイルオプション**

| オプション | 説明 |
| --- | --- |
| -target [name] | \<arch\>\<sub\>-\<os\>-\<abi\>（targetsコマンドを参照） |
| -O [mode] | 最適化対象を選択 |
| -ofmt=[fmt] | ターゲットオブジェクトフォーマットを上書き |
| -mcpu [cpu] | ターゲットCPUと機能セットを指定 |
| -mcmodel=[model] | コードとデータの仮想アドレス範囲を制限 |
| -mred-zone | "レッドゾーン"を強制有効化 |
| -mno-red-zone | "レッドゾーン"を強制無効化 |
| -fomit-frame-pointer | スタックフレームポインタを省略 |
| -fno-omit-frame-pointer | スタックフレームポインタを保存 |
| -fPIC | 位置独立コードを強制有効化 |
| -fno-PIC | 位置独立コードを強制無効化 |
| -fstack-check | アンセーフビルドでスタックプロービングを有効化 |
| -fno-stack-check | セーフビルドでスタックプロービングを無効化 |
| -fstack-protector | アンセーフビルドでスタック保護を有効化 |
| -fno-stack-protector | セーフビルドでスタック保護を無効化 |
| -fvalgrind | リリースビルドにvalgrindクライアントリクエストを含める |
| -fno-valgrind | デバッグビルドでvalgrindクライアントリクエストを省略 |
| -fsanitize-c[=mode] | アンセーフビルドでC未定義動作検出を有効化 |
| -fno-sanitize-c | セーフビルドでC未定義動作検出を無効化 |
| -fsanitize-thread | スレッドサニタイザを有効化 |
| -fno-sanitize-thread | スレッドサニタイザを無効化 |
| -ffuzz | ファズテスト計装を有効化 |
| -fno-fuzz | ファズテスト計装を無効化 |
| -fbuiltin | 関数の暗黙的なビルトイン知識を有効化 |
| -fno-builtin | 関数の暗黙的なビルトイン知識を無効化 |
| -funwind-tables | 全関数にアンワインドテーブルエントリを常に生成 |
| -fasync-unwind-tables | 全関数に非同期アンワインドテーブルエントリを常に生成 |
| -fno-unwind-tables | アンワインドテーブルエントリを生成しない |
| -ferror-tracing | リリースビルドでエラートレースを有効化 |
| -fno-error-tracing | デバッグビルドでエラートレースを無効化 |
| -fsingle-threaded | コードは1スレッドのみ存在すると仮定 |
| -fno-single-threaded | コードは1スレッドのみとは限らないと仮定 |
| -fstrip | デバッグシンボルを省略 |
| -fno-strip | デバッグシンボルを保持 |
| -idirafter [dir] | AFTER includeサーチパスにディレクトリを追加 |
| -isystem [dir] | SYSTEM includeサーチパスにディレクトリを追加 |
| -I[dir] | includeサーチパスにディレクトリを追加 |
| --embed-dir=[dir] | embedサーチパスにディレクトリを追加 |
| -D[macro]=[value] | C [macro]を[value]に定義（[value]省略時は1） |
| -cflags [flags] -- | 次のCソースファイル用の追加フラグを設定 |
| -rcflags [flags] -- | 次の.rcソースファイル用の追加フラグを設定 |
| -rcincludes=[type] | .rcソースファイルコンパイル時のインクルードタイプを設定 |

**最適化モード**

| モード | 説明 |
| --- | --- |
| Debug | （デフォルト）最適化オフ、安全性オン |
| ReleaseFast | パフォーマンス最適化、安全性オフ |
| ReleaseSafe | パフォーマンス最適化、安全性オン |
| ReleaseSmall | 小バイナリ最適化、安全性オフ |

**オブジェクトフォーマット**

| フォーマット | 説明 |
| --- | --- |
| elf | Executable and Linking Format |
| c | Cソースコード |
| wasm | WebAssembly |
| coff | Common Object File Format（Windows） |
| macho | macOSリロケータブル |
| spirv | Standard, Portable Intermediate Representation V（SPIR-V） |
| plan9 | Plan 9 from Bell Labsオブジェクトフォーマット |
| hex | （計画機能）Intel IHEX |
| raw | （計画機能）マシンコードを直接ダンプ |

---

#### 5. build-lib

ソースまたはオブジェクトファイルからライブラリを生成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig build-lib [options] [files]` |

オプションはbuild-exeと同様です。

---

#### 6. build-obj

ソースまたはオブジェクトファイルからオブジェクトを生成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig build-obj [options] [files]` |

オプションはbuild-exeと同様です。

---

#### 7. test

ユニットテストを実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig test [options] [files]` |

**テストオプション**

| オプション | 説明 |
| --- | --- |
| --test-filter [text] | フィルタにマッチしないテストをスキップ |
| --test-cmd [arg] | テスト実行コマンドを1引数ずつ指定 |
| --test-cmd-bin | テストコマンド引数にテストバイナリパスを追加 |
| --test-no-exec | テストバイナリをコンパイルするが実行しない |
| --test-runner [path] | カスタムテストランナーを指定 |
| --test-execve | 可能であれば子プロセスではなくexecveでテストバイナリを実行 |

---

#### 8. test-obj

ユニットテスト用オブジェクトを生成します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig test-obj [options] [files]` |

---

#### 9. run

実行ファイルを生成して即座に実行します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig run [options] [files] [-- [args]]` |

`--` 以降の引数は実行時に生成されたプログラムに渡されます。

---

### ツールコマンド

#### 10. ast-check

任意のファイルセットで単純なコンパイルエラーをチェックします。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig ast-check [files]` |

---

#### 11. fmt

Zigソースを標準的なフォーマットに整形します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig fmt [options] [files/directories]` |

---

#### 12. reduce

バグレポートを最小化します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig reduce [options]` |

---

#### 13. translate-c

CコードをZigコードに変換します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig translate-c [options] [file]` |

オプションはbuild-exeと同様です。

---

### 互換ツールコマンド

#### 14. ar

Zigをドロップインアーカイバとして使用します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig ar [ar-options]` |

GNU arと互換性のあるオプションを受け付けます。

---

#### 15. cc

ZigをドロップインCコンパイラとして使用します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig cc [gcc-compatible-options]` |

GCC/Clang互換のオプションを受け付けます。

---

#### 16. c++

ZigをドロップインC++コンパイラとして使用します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig c++ [g++-compatible-options]` |

G++/Clang++互換のオプションを受け付けます。

---

#### 17. dlltool

Zigをドロップインdlltool.exeとして使用します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig dlltool [dlltool-options]` |

---

#### 18. lib

Zigをドロップインlib.exeとして使用します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig lib [lib-options]` |

Microsoft lib.exe互換のオプションを受け付けます。

---

#### 19. ranlib

Zigをドロップインranlibとして使用します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig ranlib [ranlib-options]` |

---

#### 20. objcopy

Zigをドロップインobjcopyとして使用します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig objcopy [objcopy-options]` |

GNU objcopy互換のオプションを受け付けます。

---

#### 21. rc

Zigをドロップインrc.exeとして使用します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig rc [rc-options]` |

Windowsリソースコンパイラ互換のオプションを受け付けます。

---

### 情報コマンド

#### 22. env

libパス、stdパス、キャッシュディレクトリ、バージョンを表示します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig env` |

**レスポンス例**

```json
{
  "zig_exe": "/path/to/zig",
  "lib_dir": "/path/to/lib/zig",
  "std_dir": "/path/to/lib/std",
  "global_cache_dir": "/path/to/cache",
  "version": "0.16.0"
}
```

---

#### 23. help

ヘルプを表示して終了します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig help` |

---

#### 24. std

標準ライブラリドキュメントをブラウザで表示します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig std` |

---

#### 25. libc

ネイティブlibcパスファイルを表示または検証します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig libc [options]` |

---

#### 26. targets

利用可能なコンパイルターゲットを一覧表示します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig targets` |

JSON形式でサポートされるアーキテクチャ、OS、ABIの一覧を出力します。

---

#### 27. version

バージョン番号を表示して終了します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig version` |

**レスポンス例**

```
0.16.0
```

---

#### 28. zen

Zigの禅（設計哲学）を表示して終了します。

**基本情報**

| 項目 | 内容 |
| --- | --- |
| コマンド | `zig zen` |

---

### リンクオプション

#### グローバルリンクオプション

| オプション | 説明 |
| --- | --- |
| -T[script], --script [script] | カスタムリンカスクリプトを使用 |
| --version-script [path] | バージョン.mapファイルを提供 |
| --undefined-version | バージョンスクリプトが未定義シンボルを参照することを許可 |
| --no-undefined-version | （デフォルト）バージョンスクリプトが未定義シンボルを参照することを禁止 |
| --enable-new-dtags | ダイナミックタグに新しい動作（RUNPATH）を使用 |
| --disable-new-dtags | ダイナミックタグに古い動作（RPATH）を使用 |
| --dynamic-linker [path] | ダイナミックインタプリタパス（通常ld.so）を設定 |
| --no-dynamic-linker | ダイナミックインタプリタパスを設定しない |
| --sysroot [path] | システムルートディレクトリ（通常/）を設定 |
| --version [ver] | ダイナミックライブラリのsemver |
| -fentry | デフォルトシンボル名でエントリポイントを有効化 |
| -fentry=[name] | エントリポイントシンボル名を上書き |
| -fno-entry | エントリポイントを出力しない |
| --force_undefined [name] | リンク成功のために定義必須のシンボルを指定 |
| -fsoname[=name] | デフォルトSONAME値を上書き |
| -fno-soname | SONAMEの出力を無効化 |
| -flld | リンカとしてLLDを強制使用 |
| -fno-lld | リンカとしてLLDを使用しない |
| -fcompiler-rt | 出力にcompiler-rtシンボルを常に含める |
| -fno-compiler-rt | 出力にcompiler-rtシンボルを含めない |
| -fubsan-rt | 出力にubsan-rtシンボルを常に含める |
| -fno-ubsan-rt | 出力にubsan-rtシンボルを含めない |
| -rdynamic | 全シンボルをダイナミックシンボルテーブルに追加 |
| -feach-lib-rpath | 使用する各ダイナミックライブラリにrpathを追加 |
| -fno-each-lib-rpath | 使用する各ダイナミックライブラリにrpathを追加しない |
| -fallow-shlib-undefined | 共有ライブラリで未定義シンボルを許可 |
| -fno-allow-shlib-undefined | 共有ライブラリで未定義シンボルを禁止 |
| -fallow-so-scripts | .soファイルをGNU ldスクリプトとして許可 |
| -fno-allow-so-scripts | （デフォルト）.soファイルはELFファイルでなければならない |
| --build-id[=style] | ビルドIDをバイナリに埋め込む |
| --eh-frame-hdr | リンカに--eh-frame-hdrを渡してC++例外処理を有効化 |
| --no-eh-frame-hdr | リンカに--no-eh-frame-hdrを渡してC++例外処理を無効化 |
| --emit-relocs | ポストビルドツール用にリロケーションセクションの出力を有効化 |
| -z [arg] | リンカ拡張フラグを設定 |
| -dynamic | 出力を動的リンクに強制 |
| -static | 出力を静的リンクに強制 |
| -Bsymbolic | グローバル参照をローカルにバインド |
| --compress-debug-sections=[e] | デバッグセクション圧縮設定 |
| --gc-sections | エントリポイントまたはエクスポートシンボルから到達不能な関数とデータを強制削除 |
| --no-gc-sections | 到達不能な関数とデータの強制削除をしない |
| --sort-section=[value] | ワイルドカードセクションパターンを'name'または'alignment'でソート |
| --subsystem [subsystem] | （Windows）リンカに/SUBSYSTEM:\<subsystem\>を渡す |
| --stack [size] | デフォルトスタックサイズを上書き |
| --image-base [addr] | 実行イメージのベースアドレスを設定 |
| -install_name=[value] | （Darwin）dylibのインストール名を追加 |
| --entitlements [path] | （Darwin）コード署名に埋め込む資格ファイルへのパスを追加 |
| -pagezero_size [value] | （Darwin）16進表記で__PAGEZEROセグメントのサイズ |
| -headerpad [value] | （Darwin）16進表記でロードコマンドの将来拡張用の最小スペースを設定 |
| -headerpad_max_install_names | （Darwin）全パスがMAXPATHLENの場合のスペースを設定 |
| -dead_strip | （Darwin）エントリポイントまたはエクスポートシンボルから到達不能な関数とデータを削除 |
| -dead_strip_dylibs | （Darwin）エントリポイントまたはエクスポートシンボルから到達不能なdylibを削除 |
| -ObjC | （Darwin）Objective-Cクラスまたはカテゴリを実装するスタティックアーカイブの全メンバを強制ロード |
| --import-memory | （WebAssembly）環境からメモリをインポート |
| --export-memory | （WebAssembly）メモリをホストにエクスポート（--import-memory使用時以外はデフォルト） |
| --import-symbols | （WebAssembly）ホスト環境から不足シンボルをインポート |
| --import-table | （WebAssembly）ホスト環境から関数テーブルをインポート |
| --export-table | （WebAssembly）関数テーブルをホスト環境にエクスポート |
| --initial-memory=[bytes] | （WebAssembly）リニアメモリの初期サイズ |
| --max-memory=[bytes] | （WebAssembly）リニアメモリの最大サイズ |
| --shared-memory | （WebAssembly）共有リニアメモリを使用 |
| --global-base=[addr] | （WebAssembly）グローバルデータを配置する開始位置 |

#### モジュール別リンクオプション

| オプション | 説明 |
| --- | --- |
| -l[lib], --library [lib] | システムライブラリに対してリンク（実際に使用される場合のみ） |
| -needed-l[lib], --needed-library [lib] | システムライブラリに対してリンク（未使用でも） |
| -weak-l[lib], -weak_library [lib] | システムライブラリに対してリンクし、それと全ての参照シンボルをweakとしてマーク |
| -L[d], --library-directory [d] | ライブラリ検索パスにディレクトリを追加 |
| -search_paths_first | 各ライブラリ検索パスで、動的ライブラリを先にチェックし、次に静的ライブラリをチェック |
| -search_paths_first_static | 各ライブラリ検索パスで、静的ライブラリを先にチェックし、次に動的ライブラリをチェック |
| -search_dylibs_first | 全ライブラリ検索パスで動的ライブラリを検索し、次に静的ライブラリを検索 |
| -search_static_first | 全ライブラリ検索パスで静的ライブラリを検索し、次に動的ライブラリを検索 |
| -search_dylibs_only | 動的ライブラリのみを検索 |
| -search_static_only | 静的ライブラリのみを検索 |
| -rpath [path] | ランタイムライブラリ検索パスにディレクトリを追加 |
| -framework [name] | （Darwin）フレームワークに対してリンク |
| -needed_framework [name] | （Darwin）フレームワークに対してリンク（未使用でも） |
| -needed_library [lib] | （Darwin）システムライブラリに対してリンク（未使用でも） |
| -weak_framework [name] | （Darwin）フレームワークに対してリンクし、それと全ての参照シンボルをweakとしてマーク |
| -F[dir] | （Darwin）フレームワーク検索パスを追加 |
| --export=[value] | （WebAssembly）シンボルを強制エクスポート |

---

### デバッグオプション（Zigコンパイラ開発）

| オプション | 説明 |
| --- | --- |
| -fopt-bisect-limit=[limit] | 最初の[limit]個のLLVM最適化パスのみを実行 |
| -fstack-report | スタックサイズ診断を出力 |
| --verbose-link | リンカ呼び出しを表示 |
| --verbose-cc | Cコンパイラ呼び出しを表示 |
| --verbose-air | Zig AIRのコンパイラデバッグ出力を有効化 |
| --verbose-intern-pool | InternPoolのコンパイラデバッグ出力を有効化 |
| --verbose-generic-instances | ジェネリックインスタンス生成のコンパイラデバッグ出力を有効化 |
| --verbose-llvm-ir[=path] | 非最適化LLVM IRのコンパイラデバッグ出力を有効化 |
| --verbose-llvm-bc=[path] | 非最適化LLVM BCのコンパイラデバッグ出力を有効化 |
| --verbose-cimport | Cインポートのコンパイラデバッグ出力を有効化 |
| --verbose-llvm-cpu-features | LLVM CPU機能のコンパイラデバッグ出力を有効化 |
| --debug-log [scope] | スコープのdebug/infoログメッセージ出力を有効化 |
| --debug-compile-errors | 最初のコンパイルエラーで有用な診断とともにクラッシュ |
| --debug-link-snapshot | リンカの状態をJSON形式でダンプすることを有効化 |
| --debug-rt | コンパイラランタイムライブラリをデバッグ |
| --debug-incremental | インクリメンタルコンパイルデバッグ機能を有効化 |

---

### デバッグコマンド（デバッグビルド時のみ）

| コマンド | 説明 |
| --- | --- |
| changelist | 古いZIRから新しいZIRへのマッピングを計算 |
| dump-zir | キャッシュされたZIRを含むファイルをダンプ |
| detect-cpu | ZigのCPU機能検出とLLVMを比較 |
| llvm-ints | 全整数のLLVMABIAlignmentOfTypeリストをダンプ |

---

## 備考

- 本プロジェクトはHTTPベースのWeb APIを提供していません
- CLI APIは`src/main.zig`で定義されています
- 標準ライブラリは`lib/std/`に含まれています
- LLVM拡張機能を必要とするオプションは、LLVMを有効にしてビルドされたZigコンパイラでのみ使用可能です
- 本設計書はZig 0.16.0をベースにしています
