---
generated_at: 2026-02-01 18:35:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **コンパイルパイプライン図**：公式ドキュメントによる確認が望ましい
  2. **Stage1/Stage2/Stage3の定義**：Zig公式の用語定義との照合が必要
  3. **パフォーマンス関連の記述**：実測データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.zig:1-14` - インポート文とモジュール構造
- E-02: `src/main.zig:77-119` - CLIコマンド一覧
- E-03: `src/Compilation.zig:1-100` - Compilation構造体定義
- E-04: `src/Sema.zig:1-80` - Sema構造体とドキュメントコメント
- E-05: `src/InternPool.zig:1-80` - InternPool構造体定義
- E-06: `src/Air.zig:1-80` - AIR構造体定義
- E-07: `src/Type.zig:1-80` - Type構造体定義
- E-08: `src/Value.zig` - Value構造体
- E-09: `src/codegen.zig:1-80` - コード生成バックエンド選択
- E-10: `src/link.zig:1-80` - リンカーDiags定義
- E-11: `build.zig:1-200` - ビルドシステム定義
- E-12: `README.md:1-200` - プロジェクト概要とビルド手順
- E-13: `lib/std/std.zig:1-100` - 標準ライブラリエクスポート
- E-14: `test/behavior/enum.zig:1-80` - enumテスト例
- E-15: ディレクトリ構造（`ls`コマンド出力）- プロジェクト構造確認
- E-16: `build.zig.zon` - パッケージ依存定義
- E-17: `src/codegen/llvm.zig` - LLVMバックエンド（参照のみ）
- E-18: `src/codegen/c.zig` - Cバックエンド（参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Zigプログラムはファイル単位でモジュールとして構成される | E-01, E-04 | ○ |
| C-02 | `@import("std")`で標準ライブラリをインポート | E-01, E-13 | ○ |
| C-03 | `@import("builtin")`でコンパイル時情報を取得 | E-01 | ○ |
| C-04 | Compilationがビルド全体を管理 | E-03 | ○ |
| C-05 | Semaが意味解析を担当 | E-04 | ○ |
| C-06 | Semaはコンパイラの心臓部 | E-04 | ○ |
| C-07 | InternPoolが型と値をインターン化 | E-05 | ○ |
| C-08 | AIRはSemaからcodegen間の中間表現 | E-06 | ○ |
| C-09 | Type.zigが型システムを実装 | E-07 | ○ |
| C-10 | codegenがターゲット別バックエンドを選択 | E-09 | ○ |
| C-11 | LLVM, C, WASM等のバックエンドが存在 | E-09 | ○ |
| C-12 | link.zigがリンカー機能を提供 | E-10 | ○ |
| C-13 | main.zigがCLIエントリーポイント | E-02 | ○ |
| C-14 | `zig build-exe`コマンドが存在 | E-02 | ○ |
| C-15 | `zig build`コマンドがbuild.zigを使用 | E-02, E-11 | ○ |
| C-16 | PascalCase.zigは構造体定義ファイル | E-03, E-04, E-05, E-06, E-07 | ○ |
| C-17 | snake_case.zigはユーティリティモジュール | E-09, E-10 | ○ |
| C-18 | `@This()`で現在の型を参照 | E-04 | ○ |
| C-19 | `pt`はPerThreadの略称 | E-04 | ○ |
| C-20 | `gpa`はGeneral Purpose Allocatorの略称 | E-03, E-04 | ○ |
| C-21 | `zcu`はZig Compilation Unitの略称 | E-03 | ○ |
| C-22 | srcディレクトリにコンパイラコアがある | E-15 | ○ |
| C-23 | libディレクトリにランタイムライブラリがある | E-15 | ○ |
| C-24 | testディレクトリにテストスイートがある | E-15 | ○ |
| C-25 | toolsディレクトリに開発ツールがある | E-15 | ○ |
| C-26 | CMakeLists.txtがCMakeビルドを定義 | E-12, E-15 | ○ |
| C-27 | bootstrap.cでLLVMなしビルドが可能 | E-12 | ○ |
| C-28 | stage1/にStage1コンパイラがある | E-15 | ○ |
| C-29 | パイプラインアーキテクチャを採用 | E-04, E-06, E-09 | ○ |
| C-30 | ZIR→AIR→機械語の変換フロー | E-04, E-06 | ○ |
| C-31 | switch文は網羅的である必要がある | E-07 | ○ |
| C-32 | `inline`キーワードでコンパイル時展開 | E-09 | ○ |
| C-33 | `pub`で公開関数を定義 | E-01, E-04, E-07 | ○ |
| C-34 | `?T`はオプショナル型 | E-03 | ○ |
| C-35 | `!T`はエラーユニオン型 | 一般的なZig言語知識 | ○ |
| C-36 | enumテストが test/behavior/enum.zig に存在 | E-14 | ○ |
| C-37 | std.logでスコープ付きログが使える | E-04 | ○ |
| C-38 | Tracy統合がサポートされている | E-09 | ○ |
| C-39 | x86_64バックエンドが存在 | E-09 | ○ |
| C-40 | aarch64バックエンドが存在 | E-09 | ○ |
| C-41 | SPIRV バックエンドが存在 | E-09 | ○ |
| C-42 | Sema.zigが最大ファイル | E-15（ファイルサイズ確認） | ○ |
| C-43 | コンパイルパイプラインの詳細な段階 | **根拠なし** | △ |
| C-44 | Stage1/Stage2/Stage3の正確な定義 | **根拠なし** | △ |
| C-45 | パフォーマンス最適化の具体的効果 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **コンパイルパイプラインの公式定義**
  - 理由：コード内のコメントから推測したが、公式ドキュメントでの確認が必要
  - 候補：Zig公式ドキュメント / コントリビューターガイド / 内部設計書

- **Stage1/Stage2/Stage3の定義**
  - 理由：READMEに一部記載あるが、正式な定義との照合が必要
  - 候補：Zig公式Wiki / ブログ記事 / RFCドキュメント

- **パフォーマンス関連の記述**
  - 理由：実測データに基づく記述ではない
  - 候補：ベンチマーク結果 / CI統計データ

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 言語基礎・命名規則・ディレクトリ構造
  - ソースコードから直接確認可能な事実に基づく

- **1: 中リスク** - アーキテクチャ図・データフロー
  - 複数のソースファイルから推測した構造
  - コードの変更により陳腐化の可能性あり

- **2: 高リスク** - コンパイルパイプライン詳細・Stage定義
  - 公式ドキュメントとの照合が必要
  - 内部実装の変更により不正確になる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] セクション1（言語基礎）のコード例が最新のZig構文と一致しているか
- [ ] セクション2（プロジェクト固有概念）のパイプライン説明が正確か
- [ ] セクション3（命名規則）が現在のコーディング規約と一致しているか
- [ ] セクション4（ディレクトリ構造）が現在のプロジェクト構造と一致しているか
- [ ] セクション5（アーキテクチャ）のMermaid図が正確か
- [ ] セクション8（業務フロー追跡）の手順が実際に追跡可能か
- [ ] 付録Aの用語集が正確か（特にStage1/2/3の定義）
- [ ] 参照先ファイルのパスと行番号が有効か（コード変更により無効化の可能性）
