---
generated_at: 2026-02-01 18:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **Tracy統合の詳細設定**：具体的な設定オプションの詳細が不足
  2. **キャッシュTTLの正確な動作**：永続キャッシュの無効化条件が不明確
  3. **並列処理のスレッド数制限**：デフォルトスレッド数の決定ロジックが未確認
  4. **増分コンパイルの依存関係追跡詳細**：InternPoolの依存関係追跡の完全な仕様が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `build.zig` - バージョン情報、LLVM連携設定、ビルドオプション
- E-02: `build.zig.zon` - パッケージ情報
- E-03: `README.md` - プロジェクト概要、ビルド手順、LLVM要件
- E-04: `src/main.zig` - CLIコマンド定義、サブコマンドディスパッチ
- E-05: `src/Compilation.zig` - コンパイル管理、ジョブキュー、キャッシュ設定
- E-06: `src/Zcu.zig` - Zig Compilation Unit定義、モジュール管理
- E-07: `src/Sema.zig` - セマンティック解析、型検査ロジック
- E-08: `src/Air.zig` - Analyzed IR定義
- E-09: `src/InternPool.zig` - 型・値インターン化、依存関係追跡
- E-10: `src/codegen.zig` - バックエンド選択、コード生成制御
- E-11: `src/link.zig` - リンカーインターフェース、診断情報
- E-12: `src/codegen/` ディレクトリ構成 - バックエンド一覧
- E-13: `src/link/` ディレクトリ構成 - リンカー実装一覧
- E-14: `lib/std/` ディレクトリ構成 - 標準ライブラリ構成
- E-15: `src/Type.zig` - 型システム（ファイル存在確認）
- E-16: `src/Value.zig` - 値表現（ファイル存在確認）
- E-17: `CMakeLists.txt` - CMakeビルド設定

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Zigコンパイラはバージョン0.16.0である | E-01 (zig_version: 0.16.0) | ○ |
| C-02 | LLVMバージョン21.xを使用 | E-03 (LLVM 21.x要件記載) | ○ |
| C-03 | main.zigがエントリポイントである | E-04 (pub fn main定義) | ○ |
| C-04 | Compilation.zigがコンパイル全体を管理 | E-05 (Compilation構造体定義) | ○ |
| C-05 | Zcu.zigがZig Compilation Unitを表す | E-06 (Zcu構造体定義、コメント) | ○ |
| C-06 | Sema.zigがセマンティック解析を行う | E-07 (コメント、Sema構造体) | ○ |
| C-07 | Air.zigが解析済み中間表現を定義 | E-08 (コメント、Air構造体) | ○ |
| C-08 | InternPool.zigが型・値をインターン化 | E-09 (コメント、構造体定義) | ○ |
| C-09 | codegen.zigがコード生成を制御 | E-10 (generateFunction関数) | ○ |
| C-10 | link.zigがリンカー処理を行う | E-11 (link.File定義) | ○ |
| C-11 | x86_64バックエンドが存在する | E-12 (codegen/x86_64/ディレクトリ) | ○ |
| C-12 | aarch64バックエンドが存在する | E-12 (codegen/aarch64/ディレクトリ) | ○ |
| C-13 | riscv64バックエンドが存在する | E-12 (codegen/riscv64/ディレクトリ) | ○ |
| C-14 | WASMバックエンドが存在する | E-12 (codegen/wasm/ディレクトリ) | ○ |
| C-15 | SPIR-Vバックエンドが存在する | E-12 (codegen/spirv/ディレクトリ) | ○ |
| C-16 | LLVMバックエンドが存在する | E-12 (codegen/llvm.zig) | ○ |
| C-17 | Cバックエンドが存在する | E-12 (codegen/c.zig) | ○ |
| C-18 | ELFリンカーが存在する | E-13 (link/Elf.zig) | ○ |
| C-19 | Mach-Oリンカーが存在する | E-13 (link/MachO.zig) | ○ |
| C-20 | COFFリンカーが存在する | E-13 (link/Coff.zig) | ○ |
| C-21 | WASMリンカーが存在する | E-13 (link/Wasm.zig) | ○ |
| C-22 | DWARFデバッグ情報生成が存在する | E-13 (link/Dwarf.zig) | ○ |
| C-23 | 標準ライブラリがlib/std/に存在する | E-14 (ディレクトリ構成) | ○ |
| C-24 | std.zig.Astが構文解析を担当 | E-04 (import使用箇所) | ○ |
| C-25 | std.zig.AstGenがZIR生成を担当 | E-04 (import使用箇所) | ○ |
| C-26 | work_queuesで並列処理を管理 | E-05 (work_queuesフィールド定義) | ○ |
| C-27 | c_object_work_queueでCオブジェクトジョブ管理 | E-05 (c_object_work_queueフィールド) | ○ |
| C-28 | link_queueでリンカータスク管理 | E-05 (link_queueフィールド) | ○ |
| C-29 | std.Build.Cacheでキャッシュ管理 | E-05 (cache_parent: *Cache) | ○ |
| C-30 | global_zir_cacheとlocal_zir_cacheが存在 | E-06 (フィールド定義) | ○ |
| C-31 | Mutexで排他制御を行う | E-05 (mutex: std.Io.Mutex) | ○ |
| C-32 | -fno-llvmでLLVMなしビルド可能 | E-03 (README記載) | ○ |
| C-33 | bootstrap.cでCからブートストラップ可能 | E-03 (README記載) | ○ |
| C-34 | CLIサブコマンドとしてbuild-exe等が存在 | E-04 (コマンド分岐処理) | ○ |
| C-35 | ErrorBundleでエラーを集約 | E-05 (std.zig.ErrorBundle import) | ○ |
| C-36 | crash_report.zigでクラッシュレポート生成 | E-04 (crash_report import) | ○ |
| C-37 | Type.zigで型システムを実装 | E-15 (ファイル存在) | ○ |
| C-38 | Value.zigで値表現を実装 | E-16 (ファイル存在) | ○ |
| C-39 | Tracy統合はオプション | E-01 (tracy build option) | ○ |
| C-40 | キャッシュは永続的に保存される | **根拠なし** | △ |
| C-41 | スレッドプールのデフォルト数 | **根拠なし** | △ |
| C-42 | 増分コンパイルの依存関係追跡の完全性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **キャッシュの有効期限・無効化条件**
  - ソースコードからはキャッシュが「永続」であることは推測できるが、明示的な無効化条件やTTLの記述が見つからない
  - 候補：Compilation.zigの詳細分析 / キャッシュ管理ドキュメント / std.Build.Cacheの実装

- **スレッドプールのデフォルトスレッド数**
  - `-j<N>`オプションで制限可能なことは確認済みだが、デフォルト値の決定ロジックが未確認
  - 候補：Compilation.zigのthread_limit初期化処理 / build.zigの設定

- **InternPoolの依存関係追跡の完全な仕様**
  - 依存関係追跡用のフィールドは確認済みだが、追跡アルゴリズムの完全な理解には至っていない
  - 候補：InternPool.zigの詳細分析 / Zcu.zigの依存関係管理処理

- **Tracy統合の詳細オプション**
  - Tracyが有効化できることは確認済みだが、詳細な設定オプションの説明が不足
  - 候補：build.zigのtracy関連オプション / tracy.zigの実装

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - レイヤー構成、モジュール構成、バックエンド一覧
  - ソースコードのディレクトリ構成から直接確認可能

- **1: 中リスク** - 並列処理モデル、データフロー
  - ソースコードから構造は確認できるが、実行時の動作は推測を含む

- **2: 高リスク** - キャッシュTTL、増分コンパイルの完全性
  - 明示的な根拠が不足しており、実装詳細の確認が必要

## 6) レビュアーチェックリスト（最小）

- [ ] LLVM 21.xの要件がREADME.mdと一致しているか確認
- [ ] 各バックエンド（x86_64, aarch64, etc.）がcodegen/ディレクトリに存在するか確認
- [ ] 各リンカー（ELF, MachO, COFF等）がlink/ディレクトリに存在するか確認
- [ ] Compilation.zigのwork_queuesフィールドの定義を確認
- [ ] InternPool.zigの依存関係追跡フィールド（src_hash_deps等）を確認
- [ ] キャッシュの無効化条件についてstd.Build.Cache実装を確認
- [ ] 並列処理のスレッド数決定ロジックを確認
