# アーキテクチャ構成図

## システム全体構成図

```mermaid
flowchart TB
    subgraph External["外部システム"]
        LLVM["LLVM 21.x"]
        Clang["Clang 21.x"]
        LLD["LLD 21.x"]
        OS["OS / ファイルシステム"]
    end

    subgraph CLI["CLI Layer"]
        Main["main.zig<br/>エントリポイント"]
    end

    subgraph Compilation["Compilation Layer"]
        Comp["Compilation.zig<br/>コンパイル管理"]
        Zcu["Zcu.zig<br/>Zig Compilation Unit"]
        Package["Package.zig<br/>パッケージ管理"]
    end

    subgraph Frontend["Frontend Layer"]
        Ast["std.zig.Ast<br/>抽象構文木"]
        AstGen["std.zig.AstGen<br/>ZIR生成"]
        Zir["std.zig.Zir<br/>Zig IR"]
    end

    subgraph Sema["Semantic Analysis Layer"]
        SemaCore["Sema.zig<br/>セマンティック解析"]
        Type["Type.zig<br/>型システム"]
        Value["Value.zig<br/>値表現"]
        Air["Air.zig<br/>解析済みIR"]
    end

    subgraph Codegen["Codegen Layer"]
        CodegenCore["codegen.zig<br/>コード生成制御"]
        LLVMBackend["codegen/llvm.zig<br/>LLVMバックエンド"]
        CBackend["codegen/c.zig<br/>Cバックエンド"]
        X86Backend["codegen/x86_64/<br/>x86_64バックエンド"]
        AArch64Backend["codegen/aarch64/<br/>AArch64バックエンド"]
        WasmBackend["codegen/wasm/<br/>WASMバックエンド"]
    end

    subgraph Linker["Linker Layer"]
        LinkCore["link.zig<br/>リンカー制御"]
        ELF["link/Elf.zig<br/>ELFリンカー"]
        MachO["link/MachO.zig<br/>Mach-Oリンカー"]
        COFF["link/Coff.zig<br/>COFFリンカー"]
        WasmLink["link/Wasm.zig<br/>WASMリンカー"]
    end

    subgraph Shared["共有データ構造"]
        InternPool["InternPool.zig<br/>型・値インターン化"]
        Cache["std.Build.Cache<br/>キャッシュ管理"]
    end

    Main --> Comp
    Comp --> Zcu
    Comp --> Package
    Zcu --> Ast
    Ast --> AstGen
    AstGen --> Zir
    Zir --> SemaCore
    SemaCore --> Type
    SemaCore --> Value
    SemaCore --> Air
    Air --> CodegenCore
    CodegenCore --> LLVMBackend
    CodegenCore --> CBackend
    CodegenCore --> X86Backend
    CodegenCore --> AArch64Backend
    CodegenCore --> WasmBackend
    LLVMBackend --> LinkCore
    CBackend --> LinkCore
    X86Backend --> LinkCore
    AArch64Backend --> LinkCore
    WasmBackend --> LinkCore
    LinkCore --> ELF
    LinkCore --> MachO
    LinkCore --> COFF
    LinkCore --> WasmLink

    LLVMBackend -.-> LLVM
    Comp -.-> Clang
    LinkCore -.-> LLD
    LinkCore --> OS
    Comp --> Cache
    Zcu --> InternPool
    SemaCore --> InternPool
```

## コンパイルパイプライン

```mermaid
flowchart LR
    subgraph Input["入力"]
        Source["Zigソースコード<br/>.zig"]
        CSource["C/C++ソース<br/>.c/.cpp"]
        Object["オブジェクトファイル<br/>.o/.obj"]
    end

    subgraph Pipeline["コンパイルパイプライン"]
        Parse["構文解析<br/>AST生成"]
        ZirGen["ZIR生成<br/>AstGen"]
        SemaPhase["セマンティック解析<br/>Sema"]
        AirGen["AIR生成"]
        MirGen["MIR生成<br/>Codegen"]
        Emit["コード出力<br/>Emit"]
    end

    subgraph Output["出力"]
        Executable["実行可能ファイル"]
        Library["ライブラリ<br/>.a/.so/.dylib"]
        COutput["Cソースコード<br/>.c"]
    end

    Source --> Parse
    Parse --> ZirGen
    ZirGen --> SemaPhase
    SemaPhase --> AirGen
    AirGen --> MirGen
    MirGen --> Emit
    Emit --> Executable
    Emit --> Library
    Emit --> COutput

    CSource --> Clang2["Clang"]
    Clang2 --> Object2["Object"]
    Object2 --> Link["Link"]
    Object --> Link
    Emit --> Link
    Link --> Executable
    Link --> Library
```

## 中間表現の変換フロー

```mermaid
flowchart TD
    subgraph Source["ソース"]
        ZigSource["Zigソースコード"]
    end

    subgraph AST["AST (Abstract Syntax Tree)"]
        AstNodes["構文木ノード<br/>- 宣言<br/>- 式<br/>- 文"]
    end

    subgraph ZIR["ZIR (Zig Intermediate Representation)"]
        ZirInst["ZIR命令列<br/>- 型注釈付き<br/>- 未解決参照含む"]
    end

    subgraph AIR["AIR (Analyzed IR)"]
        AirInst["AIR命令列<br/>- 型解決済み<br/>- コンパイル時評価済み"]
    end

    subgraph MIR["MIR (Machine IR)"]
        MirInst["ターゲット固有MIR<br/>- レジスタ割当済み<br/>- 命令選択済み"]
    end

    subgraph Machine["マシンコード"]
        Binary["バイナリ命令列"]
    end

    ZigSource -->|"std.zig.Ast"| AstNodes
    AstNodes -->|"std.zig.AstGen"| ZirInst
    ZirInst -->|"Sema.zig"| AirInst
    AirInst -->|"codegen/*.zig"| MirInst
    MirInst -->|"emit"| Binary
```

## モジュール依存関係図

```mermaid
flowchart TD
    subgraph Core["コアモジュール"]
        main["main.zig"]
        Compilation["Compilation.zig"]
        Zcu["Zcu.zig"]
        InternPool["InternPool.zig"]
    end

    subgraph Analysis["解析モジュール"]
        Sema["Sema.zig"]
        Type["Type.zig"]
        Value["Value.zig"]
        Air["Air.zig"]
    end

    subgraph Generation["生成モジュール"]
        codegen["codegen.zig"]
        llvm["codegen/llvm.zig"]
        c["codegen/c.zig"]
        x86_64["codegen/x86_64/"]
    end

    subgraph Linking["リンクモジュール"]
        link["link.zig"]
        Elf["link/Elf.zig"]
        MachO["link/MachO.zig"]
        Coff["link/Coff.zig"]
    end

    subgraph StdLib["標準ライブラリ"]
        std["std"]
        zig["std.zig"]
        Build["std.Build"]
    end

    main --> Compilation
    Compilation --> Zcu
    Compilation --> link
    Zcu --> InternPool
    Zcu --> Sema
    Sema --> Air
    Sema --> Type
    Sema --> Value
    Type --> InternPool
    Value --> InternPool
    Air --> InternPool
    codegen --> Air
    codegen --> link
    llvm --> codegen
    c --> codegen
    x86_64 --> codegen
    link --> Elf
    link --> MachO
    link --> Coff

    main --> std
    Compilation --> std
    Zcu --> zig
    Compilation --> Build
```

## コード生成バックエンド構成

```mermaid
flowchart TD
    subgraph Input["入力"]
        AIR["AIR<br/>Analyzed IR"]
    end

    subgraph Dispatch["バックエンド選択"]
        codegen["codegen.zig<br/>バックエンド制御"]
    end

    subgraph Backends["バックエンド"]
        subgraph Native["ネイティブバックエンド"]
            x86_64["x86_64/<br/>CodeGen.zig"]
            aarch64["aarch64/<br/>CodeGen.zig"]
            riscv64["riscv64/<br/>CodeGen.zig"]
            sparc64["sparc64/<br/>CodeGen.zig"]
        end

        subgraph External["外部バックエンド"]
            llvm["llvm.zig<br/>LLVM IR生成"]
            c["c.zig<br/>Cソース生成"]
        end

        subgraph Special["特殊バックエンド"]
            wasm["wasm/<br/>WebAssembly"]
            spirv["spirv/<br/>SPIR-V"]
        end
    end

    subgraph Output["出力"]
        MachineCode["マシンコード"]
        LLVMIR["LLVM IR"]
        CSource["Cソースコード"]
        WasmBin["WASM"]
        SpirvBin["SPIR-V"]
    end

    AIR --> codegen
    codegen --> x86_64
    codegen --> aarch64
    codegen --> riscv64
    codegen --> sparc64
    codegen --> llvm
    codegen --> c
    codegen --> wasm
    codegen --> spirv

    x86_64 --> MachineCode
    aarch64 --> MachineCode
    riscv64 --> MachineCode
    sparc64 --> MachineCode
    llvm --> LLVMIR
    c --> CSource
    wasm --> WasmBin
    spirv --> SpirvBin
```

## リンカー構成

```mermaid
flowchart TD
    subgraph Input["入力"]
        ZigObj["Zigオブジェクト"]
        CObj["Cオブジェクト"]
        StaticLib["静的ライブラリ"]
        DynamicLib["動的ライブラリ"]
    end

    subgraph LinkCore["link.zig"]
        File["link.File<br/>リンカーインターフェース"]
        Queue["link.Queue<br/>タスクキュー"]
        Diags["link.Diags<br/>診断情報"]
    end

    subgraph Formats["フォーマット別リンカー"]
        Elf["link/Elf.zig<br/>Linux/BSD"]
        MachO["link/MachO.zig<br/>macOS/iOS"]
        Coff["link/Coff.zig<br/>Windows"]
        Wasm["link/Wasm.zig<br/>WebAssembly"]
        SpirV["link/SpirV.zig<br/>SPIR-V"]
    end

    subgraph Debug["デバッグ情報"]
        Dwarf["link/Dwarf.zig<br/>DWARF生成"]
    end

    subgraph External["外部リンカー"]
        LLD["LLD<br/>LLVM Linker"]
        SystemLinker["System Linker"]
    end

    subgraph Output["出力"]
        Executable["実行可能ファイル"]
        SharedLib["共有ライブラリ"]
        Archive["アーカイブ"]
    end

    ZigObj --> File
    CObj --> File
    StaticLib --> File
    DynamicLib --> File

    File --> Elf
    File --> MachO
    File --> Coff
    File --> Wasm
    File --> SpirV

    Elf --> Dwarf
    MachO --> Dwarf
    Coff --> Dwarf

    Elf --> Executable
    Elf --> SharedLib
    MachO --> Executable
    MachO --> SharedLib
    Coff --> Executable
    Coff --> SharedLib
    Wasm --> Executable

    File -.-> LLD
    File -.-> SystemLinker
```

## 並列処理モデル

```mermaid
flowchart TD
    subgraph Main["メインスレッド"]
        Compilation["Compilation<br/>コンパイル管理"]
    end

    subgraph WorkQueues["ワークキュー"]
        AstGenQueue["AstGen Queue<br/>構文解析ジョブ"]
        SemaQueue["Sema Queue<br/>セマンティック解析ジョブ"]
        CodegenQueue["Codegen Queue<br/>コード生成ジョブ"]
        CObjectQueue["C Object Queue<br/>Cコンパイルジョブ"]
        LinkQueue["Link Queue<br/>リンカージョブ"]
    end

    subgraph ThreadPool["スレッドプール"]
        Worker1["Worker 1"]
        Worker2["Worker 2"]
        Worker3["Worker 3"]
        WorkerN["Worker N"]
    end

    subgraph Sync["同期機構"]
        Mutex["std.Io.Mutex<br/>排他制御"]
        Atomic["std.atomic<br/>アトミック操作"]
    end

    Compilation --> AstGenQueue
    Compilation --> SemaQueue
    Compilation --> CodegenQueue
    Compilation --> CObjectQueue
    Compilation --> LinkQueue

    AstGenQueue --> Worker1
    SemaQueue --> Worker2
    CodegenQueue --> Worker3
    CObjectQueue --> WorkerN
    LinkQueue --> Worker1

    Worker1 --> Mutex
    Worker2 --> Mutex
    Worker3 --> Mutex
    WorkerN --> Mutex

    Worker1 --> Atomic
    Worker2 --> Atomic
```
