---
generated_at: 2026-02-01 18:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **セルフホストランナーの台数・スペック**：具体的なハードウェア情報が不明
  2. **バックアップ設計の詳細**：ziglang.orgの運用ポリシーが不明
  3. **監視設計の詳細**：外部監視ツールの使用状況が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.forgejo/workflows/ci.yaml` - CI/CDパイプライン定義
- E-02: `ci/x86_64-linux-debug.sh` - Linux x86_64 Debugビルドスクリプト
- E-03: `ci/x86_64-linux-release.sh` - Linux x86_64 Releaseビルドスクリプト
- E-04: `ci/x86_64-windows-debug.ps1` - Windows Debugビルドスクリプト
- E-05: `CMakeLists.txt` - CMakeビルド構成
- E-06: `build.zig.zon` - Zigビルド構成
- E-07: `README.md` - プロジェクト概要・ビルド手順
- E-08: `bootstrap.c` - LLVMなしビルド用ブートストラップ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Codeberg（Forgejoベース）でソースコードをホスティング | E-01 (codeberg.org/ziglang/checkout) | ○ |
| C-02 | Forgejo ActionsによるCI/CD | E-01 | ○ |
| C-03 | x86_64-linux向けセルフホストランナー | E-01 (runs-on: [self-hosted, x86_64-linux]) | ○ |
| C-04 | aarch64-linux向けセルフホストランナー | E-01 (runs-on: [self-hosted, aarch64-linux]) | ○ |
| C-05 | aarch64-macos向けセルフホストランナー | E-01 (runs-on: [self-hosted, aarch64-macos]) | ○ |
| C-06 | x86_64-windows向けセルフホストランナー | E-01 (runs-on: [self-hosted, x86_64-windows]) | ○ |
| C-07 | CMake >= 3.15が必要 | E-05 (cmake_minimum_required(VERSION 3.15)) | ○ |
| C-08 | LLVM 21.xを使用 | E-07 (LLVM, Clang, LLD...version 21.x) | ○ |
| C-09 | Zig 0.16.0-devを使用 | E-02, E-03 (0.16.0-dev.104+689461e31) | ○ |
| C-10 | QEMU 10.2.0を使用 | E-02 (qemu-linux-x86_64-10.2.0) | ○ |
| C-11 | Wasmtime 38.0.3を使用 | E-02 (wasmtime-v38.0.3) | ○ |
| C-12 | ziglang.orgから依存関係をダウンロード | E-04 (https://ziglang.org/deps/) | ○ |
| C-13 | concurrency設定でPR時に古いジョブをキャンセル | E-01 (cancel-in-progress) | ○ |
| C-14 | ZIG_GLOBAL_CACHE_DIRによるキャッシュ制御 | E-02 (export ZIG_GLOBAL_CACHE_DIR) | ○ |
| C-15 | x86_64-linux-debugのタイムアウトは180分 | E-01 (timeout-minutes: 180) | ○ |
| C-16 | riscv64-linux-debugのタイムアウトは660分 | E-01 (timeout-minutes: 660) | ○ |
| C-17 | RISC-VジョブはPR時にスキップ | E-01 (if: github.event_name != 'pull_request') | ○ |
| C-18 | stage3とstage4のバイト単位比較を実施 | E-03 (diff stage3-release/bin/zig stage4-release/bin/zig) | ○ |
| C-19 | Visual Studio 2022 Build Toolsを使用 | E-04 (Microsoft Visual Studio\2022\BuildTools) | ○ |
| C-20 | x86_64-linux-muslターゲットを使用 | E-02, E-03 (TARGET="x86_64-linux-musl") | ○ |
| C-21 | bootstrap.cによるLLVMなしビルドをサポート | E-03, E-07, E-08 | ○ |
| C-22 | -fqemuオプションでQEMUテストを実行 | E-02 (-fqemu) | ○ |
| C-23 | セルフホストランナーの具体的なハードウェアスペック | **根拠なし** | △ |
| C-24 | ziglang.orgのバックアップポリシー | **根拠なし** | △ |
| C-25 | 外部監視ツールの使用有無 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **セルフホストランナーのハードウェア情報**：CIスクリプトからはランナーのラベルのみ確認可能。具体的なCPU、メモリ、ストレージ仕様は不明
  - 候補：Ziglangインフラ管理ドキュメント / 運用者への確認 / インフラ構成管理ツール
- **ziglang.orgの運用ポリシー**：依存関係パッケージの配布サーバーの可用性・バックアップポリシーは不明
  - 候補：ziglang.org運用ドキュメント / インフラチームへの確認
- **監視・アラート設定**：Forgejo Actionsダッシュボード以外の監視ツール使用状況は不明
  - 候補：運用マニュアル / モニタリング設定ファイル

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: CI/CDパイプライン構成 - ci.yamlとCIスクリプトから明確に確認可能
- **0（低リスク）**: ビルドシステム構成 - CMakeLists.txtとREADMEから明確に確認可能
- **1（中リスク）**: タイムアウト設定 - 実際の実行時間との整合性は要確認
- **2（高リスク）**: ハードウェアスペック - コードからは確認不可、インフラ管理者への確認が必要
- **2（高リスク）**: バックアップ・監視設計 - 実運用情報が不足

## 6) レビュアーチェックリスト（最小）
- [ ] セルフホストランナーのプラットフォーム一覧が実際のCI設定と一致しているか確認
- [ ] タイムアウト設定値がci.yamlの値と一致しているか確認
- [ ] 依存関係のバージョン（LLVM、QEMU、Wasmtime等）が最新のCIスクリプトと一致しているか確認
- [ ] CMakeの最小バージョン要件がCMakeLists.txtと一致しているか確認
- [ ] ハードウェアスペックについてインフラ管理者に確認が必要
- [ ] バックアップ・監視設計について運用チームに確認が必要
