# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "ソースコード管理"
        CODEBERG[Codeberg<br/>Git Repository]
    end

    subgraph "CI/CDトリガー"
        PR[Pull Request]
        PUSH[Master Branch Push]
        MANUAL[Manual Dispatch]
    end

    subgraph "Forgejo Actions"
        WORKFLOW[CI Workflow<br/>ci.yaml]
    end

    subgraph "依存関係配布"
        ZIGLANG[ziglang.org<br/>Pre-built Packages]
    end

    PR --> WORKFLOW
    PUSH --> WORKFLOW
    MANUAL --> WORKFLOW
    CODEBERG --> WORKFLOW
    ZIGLANG --> WORKFLOW

    subgraph "セルフホストランナー群"
        subgraph "Linux"
            X86_LINUX[x86_64-linux]
            AARCH64_LINUX[aarch64-linux]
            LOONG_LINUX[loongarch64-linux]
            PPC_LINUX[powerpc64le-linux]
            RISCV_LINUX[riscv64-linux]
            S390X_LINUX[s390x-linux]
        end

        subgraph "macOS"
            AARCH64_MACOS[aarch64-macos]
        end

        subgraph "Windows"
            X86_WINDOWS[x86_64-windows]
        end

        subgraph "BSD"
            X86_FREEBSD[x86_64-freebsd]
            X86_OPENBSD[x86_64-openbsd]
        end
    end

    WORKFLOW --> X86_LINUX
    WORKFLOW --> AARCH64_LINUX
    WORKFLOW --> LOONG_LINUX
    WORKFLOW --> PPC_LINUX
    WORKFLOW --> RISCV_LINUX
    WORKFLOW --> S390X_LINUX
    WORKFLOW --> AARCH64_MACOS
    WORKFLOW --> X86_WINDOWS
    WORKFLOW --> X86_FREEBSD
    WORKFLOW --> X86_OPENBSD
```

## ビルドパイプライン構成図

```mermaid
flowchart TD
    subgraph "ビルドステージ"
        CHECKOUT[Checkout<br/>ソースコード取得]
        DEPS[依存関係取得<br/>zig+llvm+lld+clang]

        subgraph "Stage 3 ビルド"
            CMAKE[CMake構成]
            NINJA[Ninja ビルド]
            INSTALL[Install]
        end

        subgraph "テスト実行"
            BEHAVIOR[Behavior Tests]
            DOCS[Documentation Build]
            CROSS[Cross-platform Tests<br/>QEMU/Wasmtime]
        end

        subgraph "Stage 4 ビルド"
            STAGE4_BUILD[Self-hosted Build]
            STAGE4_VERIFY[Determinism Check]
        end
    end

    CHECKOUT --> DEPS
    DEPS --> CMAKE
    CMAKE --> NINJA
    NINJA --> INSTALL
    INSTALL --> BEHAVIOR
    INSTALL --> DOCS
    INSTALL --> CROSS
    INSTALL --> STAGE4_BUILD
    STAGE4_BUILD --> STAGE4_VERIFY
```

## Linux ビルド環境構成図

```mermaid
graph LR
    subgraph "ビルド環境"
        ZIG[Zig Compiler<br/>事前ビルド済み]
        LLVM[LLVM 21.x]
        LLD[LLD]
        CLANG[Clang]
    end

    subgraph "ビルドツール"
        CMAKE_TOOL[CMake >= 3.15]
        NINJA_TOOL[Ninja]
        CC[CC/CXX<br/>zig cc/c++]
    end

    subgraph "テストツール"
        QEMU[QEMU 10.2.0]
        WASMTIME[Wasmtime 38.0.3]
        LLDB[LLDB]
    end

    subgraph "ターゲット"
        MUSL[x86_64-linux-musl]
        ARM[arm-linux-musleabihf]
        NATIVE[native-native-musl]
    end

    ZIG --> CC
    LLVM --> CMAKE_TOOL
    LLD --> CMAKE_TOOL
    CLANG --> CMAKE_TOOL
    CMAKE_TOOL --> NINJA_TOOL
    NINJA_TOOL --> MUSL
    NINJA_TOOL --> ARM
    QEMU --> ARM
    WASMTIME --> NATIVE
```

## Windows ビルド環境構成図

```mermaid
graph TD
    subgraph "開発キット"
        ZIG_WIN[Zig Compiler]
        LLVM_WIN[LLVM Libraries]
        ZLIB[zlib]
        ZSTD[zstd]
    end

    subgraph "ビルドツール"
        CMAKE_WIN[CMake]
        NINJA_WIN[Ninja]
        MSVC[Visual Studio 2022<br/>Build Tools]
    end

    subgraph "ビルドターゲット"
        GNU[x86_64-windows-gnu]
        MSVC_TARGET[x86_64-windows-msvc]
    end

    ZIG_WIN --> CMAKE_WIN
    LLVM_WIN --> CMAKE_WIN
    ZLIB --> CMAKE_WIN
    ZSTD --> CMAKE_WIN
    CMAKE_WIN --> NINJA_WIN
    NINJA_WIN --> GNU
    MSVC --> MSVC_TARGET
```

## CI ジョブ並列実行構成図

```mermaid
gantt
    title CI ジョブ実行タイムライン（概念図）
    dateFormat HH:mm
    axisFormat %H:%M

    section Linux x86_64
    debug (180min)     :active, linux_debug, 00:00, 3h
    release (360min)   :active, linux_release, 00:00, 6h
    debug-llvm (360min):active, linux_llvm, 00:00, 6h

    section Linux ARM64
    debug (180min)     :active, arm_debug, 00:00, 3h
    release (120min)   :active, arm_release, 00:00, 2h

    section macOS ARM64
    debug (180min)     :active, mac_debug, 00:00, 3h
    release (120min)   :active, mac_release, 00:00, 2h

    section Windows
    debug (180min)     :active, win_debug, 00:00, 3h
    release (180min)   :active, win_release, 00:00, 3h

    section BSD
    freebsd-debug      :active, bsd_debug, 00:00, 2h
    openbsd-debug      :active, obsd_debug, 00:00, 2h
```

## キャッシュ構成図

```mermaid
graph TB
    subgraph "依存関係キャッシュ"
        HOME_DEPS[~/deps/]
        LLVM_CACHE[zig+llvm+lld+clang-*]
        QEMU_CACHE[qemu-linux-*]
        WASMTIME_CACHE[wasmtime-*]
    end

    subgraph "ビルドキャッシュ"
        GLOBAL[ZIG_GLOBAL_CACHE_DIR<br/>$PWD/zig-global-cache]
        LOCAL[ZIG_LOCAL_CACHE_DIR<br/>$PWD/zig-local-cache]
    end

    subgraph "ビルド出力"
        BUILD_DEBUG[build-debug/]
        BUILD_RELEASE[build-release/]
        STAGE3[stage3/]
        STAGE4[stage4/]
    end

    HOME_DEPS --> LLVM_CACHE
    HOME_DEPS --> QEMU_CACHE
    HOME_DEPS --> WASMTIME_CACHE

    LLVM_CACHE --> BUILD_DEBUG
    LLVM_CACHE --> BUILD_RELEASE
    BUILD_DEBUG --> STAGE3
    BUILD_RELEASE --> STAGE3
    STAGE3 --> STAGE4
```

## 同時実行制御フロー

```mermaid
flowchart TD
    START[CI トリガー]
    CHECK{イベント種別?}

    PR_GROUP[Concurrency Group:<br/>workflow-PR番号]
    PUSH_GROUP[Concurrency Group:<br/>workflow-SHA]

    CANCEL{同一グループの<br/>実行中ジョブ?}
    CANCEL_OLD[古いジョブをキャンセル]
    RUN[ジョブ実行]

    START --> CHECK
    CHECK -->|Pull Request| PR_GROUP
    CHECK -->|Push/Manual| PUSH_GROUP

    PR_GROUP --> CANCEL
    PUSH_GROUP --> RUN

    CANCEL -->|あり| CANCEL_OLD
    CANCEL -->|なし| RUN
    CANCEL_OLD --> RUN
```
