# インフラ設計書

## 概要

本ドキュメントは、Zig言語コンパイラプロジェクトのインフラストラクチャ設計を記載したものである。本プロジェクトはオープンソースのプログラミング言語およびツールチェーンであり、CI/CDパイプラインを中心としたインフラ構成を採用している。

## システム構成

### 全体構成

本プロジェクトは、以下の構成要素から成る：

1. **ソースコードリポジトリ**: Codeberg（Forgejoベース）でホスティング
2. **CI/CDシステム**: Forgejo Actions（GitHub Actions互換）によるセルフホストランナー
3. **依存関係配布**: ziglang.org からの事前ビルド済み依存パッケージ配布
4. **ビルドシステム**: CMake + Ninja / Zig Build System

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| x86_64-linux | Linux x86_64向けビルド・テスト実行 | セルフホストランナー | 1台以上 |
| aarch64-linux | Linux ARM64向けビルド・テスト実行 | セルフホストランナー | 1台以上 |
| aarch64-macos | macOS ARM64向けビルド・テスト実行 | セルフホストランナー | 1台以上 |
| x86_64-windows | Windows x86_64向けビルド・テスト実行 | セルフホストランナー | 1台以上 |
| x86_64-freebsd | FreeBSD向けビルド・テスト実行 | セルフホストランナー | 1台以上 |
| x86_64-openbsd | OpenBSD向けビルド・テスト実行 | セルフホストランナー | 1台以上 |
| loongarch64-linux | LoongArch64向けビルド・テスト実行 | セルフホストランナー | 1台以上 |
| powerpc64le-linux | PowerPC64LE向けビルド・テスト実行 | セルフホストランナー | 1台以上 |
| riscv64-linux | RISC-V 64向けビルド・テスト実行 | セルフホストランナー | 1台以上 |
| s390x-linux | IBM Z (s390x)向けビルド・テスト実行 | セルフホストランナー | 1台以上 |

### ネットワーク構成

- **ソースコードホスティング**: Codeberg（codeberg.org）を使用
- **依存関係配布**: ziglang.org からHTTPS経由でダウンロード
- **CI/CDトリガー**: Pull Request、masterブランチへのpush、手動実行（workflow_dispatch）

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| CMake | >= 3.15 | ビルドシステム構成 |
| Ninja | - | ビルド実行エンジン |
| LLVM/Clang/LLD | 21.x | コンパイラバックエンド・リンカ |
| Zig | 0.16.0-dev | セルフホスティングビルド |
| QEMU | 10.2.0 | クロスプラットフォームテスト実行 |
| Wasmtime | 38.0.3 | WebAssemblyテスト実行 |
| LLDB | - | デバッグ用途 |
| Visual Studio Build Tools | 2022 | Windows向けMSVCビルド |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| Codeberg | ソースコードホスティング・Issue管理 | HTTPS/Git |
| ziglang.org | 依存関係パッケージ配布 | HTTPS |
| Forgejo Actions | CI/CDパイプライン実行 | Webhook/セルフホストランナー |

## スケーリング設計

### CI/CDスケーリング

- **水平スケーリング**: 各アーキテクチャ・OS向けにセルフホストランナーを追加可能
- **並列実行**: CI設定により、異なるプラットフォーム向けのジョブが並列実行される
- **同時実行制御**: Pull Request時は同一PRの古いワークフロー実行をキャンセル（concurrency設定）

```yaml
concurrency:
  group: ${{ github.workflow }}-${{ github.event.pull_request.number || github.sha }}
  cancel-in-progress: ${{ github.event_name == 'pull_request' }}
```

### ビルドキャッシュ

- **ローカルキャッシュ**: `ZIG_LOCAL_CACHE_DIR` による各ビルド固有のキャッシュ
- **グローバルキャッシュ**: `ZIG_GLOBAL_CACHE_DIR` による共有キャッシュ（CIでは無効化）
- **依存関係キャッシュ**: 事前ビルド済みLLVM/Clang/LLDパッケージの利用

## 可用性設計

### CI/CD可用性

- **セルフホストランナー**: 各プラットフォーム向けに独立したランナーを運用
- **タイムアウト設定**: ジョブごとに適切なタイムアウトを設定（60分〜660分）
- **条件付き実行**: RISC-V向けジョブはPull Request時にスキップ（実行時間が長いため）

| ジョブ | タイムアウト |
| --- | --- |
| x86_64-linux-debug | 180分 |
| x86_64-linux-release | 360分 |
| aarch64-linux-debug | 180分 |
| aarch64-linux-release | 120分 |
| riscv64-linux-debug | 660分 |
| riscv64-linux-release | 540分 |

### ビルド再現性

- **決定性ビルド**: stage3とstage4のバイト単位での一致を検証
- **クロスコンパイル**: 各ターゲット向けの`-target`および`-mcpu`オプション指定

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Gitリポジトリ（分散） | リアルタイム | 永続 |
| ビルドアーティファクト | CIジョブ出力 | ビルド時 | 一時的 |
| 依存関係パッケージ | ziglang.org配布サーバー | リリース時 | バージョン別 |

## 監視設計

### CI/CDモニタリング

- **ビルドステータス**: Forgejo Actionsダッシュボードで確認可能
- **テスト結果**: 各ジョブの出力ログで確認
- **リソース使用量**: `--maxrss` オプションによるメモリ使用量制限・監視

### ビルド検証

- **自動テスト**: behavior tests、link tests、standalone testsの自動実行
- **決定性検証**: stage3/stage4のバイト単位比較
- **クロスプラットフォームテスト**: QEMU/Wasmtimeによる異なるアーキテクチャでのテスト

## 備考

### ビルドモード

本プロジェクトでは以下の3つのビルドモードをサポート：

1. **CMake + LLVMビルド**: フル機能のコンパイラビルド
2. **LLVMなしビルド**: `bootstrap.c`を使用した軽量ビルド（機能制限あり）
3. **Zigを使用したビルド**: 既存のZigインストールを使用したセルフホスティングビルド

### サポートプラットフォーム

- **Linux**: x86_64, aarch64, loongarch64, powerpc64le, riscv64, s390x
- **macOS**: aarch64
- **Windows**: x86_64（GNU/MSVC両対応）
- **BSD**: FreeBSD, OpenBSD (x86_64)

### 依存関係パッケージ

事前ビルド済みパッケージは以下の形式で配布：
```
https://ziglang.org/deps/zig+llvm+lld+clang-$TARGET-$VERSION.zip
```

パッケージには以下が含まれる：
- Zigコンパイラ
- LLVM/LLD/Clangライブラリ
- zlib
- zstd
