---
generated_at: 2026-02-01 17:50:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **監査ログの保持期間**：具体的な設定ファイルなし
  2. **PIE/LTOオプション**：build.zigの詳細確認推奨
  3. **スタックカナリ初期化**：TODOコメントあり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/std/crypto.zig`
- E-02: `lib/std/crypto/tls.zig`
- E-03: `lib/std/crypto/Certificate.zig`
- E-04: `lib/std/crypto/timing_safe.zig`
- E-05: `lib/std/Random.zig`
- E-06: `lib/compiler_rt/ssp.zig`
- E-07: `src/Compilation/Config.zig`
- E-08: `build.zig`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | X.509証明書のパース・検証機能を提供 | E-03 | ○ |
| C-02 | RSA、ECDSA、Ed25519署名アルゴリズムをサポート | E-03 | ○ |
| C-03 | ホスト名検証はRFC 6125準拠 | E-03 | ○ |
| C-04 | TLS 1.2/1.3をサポート | E-02 | ○ |
| C-05 | Pre-Shared Keyモードをサポート | E-02 | ○ |
| C-06 | sanitize_c, sanitize_thread オプションを提供 | E-07 | ○ |
| C-07 | AES-GCM, ChaCha20-Poly1305, AEGIS暗号スイートをサポート | E-01, E-02 | ○ |
| C-08 | X25519, secp256r1, secp384r1鍵交換をサポート | E-02 | ○ |
| C-09 | ML-KEM（ポスト量子）鍵交換をサポート | E-02 | ○ |
| C-10 | AES-128/256-GCM対称暗号をサポート | E-01 | ○ |
| C-11 | ChaCha20/XChaCha20ストリーム暗号をサポート | E-01 | ○ |
| C-12 | HKDF, PBKDF2, Argon2, bcrypt, scrypt鍵導出をサポート | E-01 | ○ |
| C-13 | SHA-1, SHA-2, SHA-3, BLAKE2, BLAKE3ハッシュをサポート | E-01 | ○ |
| C-14 | Ed25519, ECDSA, ML-DSA署名をサポート | E-01 | ○ |
| C-15 | secureZero()でメモリの安全なゼロ化を提供 | E-01 | ○ |
| C-16 | timing_safe.eql()で定数時間比較を提供 | E-04 | ○ |
| C-17 | classify()/declassify()でValgrind連携を提供 | E-04 | ○ |
| C-18 | ChaChaベースのCSPRNGを提供 | E-05 | ○ |
| C-19 | スタックプロテクター機能を提供 | E-06 | ○ |
| C-20 | __strcpy_chk等のバッファオーバーフロー検出を提供 | E-06 | ○ |
| C-21 | サイドチャネル対策レベル（none/basic/medium/full）を提供 | E-01 | ○ |
| C-22 | TLSアラートをenumで定義 | E-02 | ○ |
| C-23 | PIE, LTO等のビルドオプションを提供 | E-07, E-08 | ○ |
| C-24 | スタックカナリは乱数で初期化 | E-06 | △ |
| C-25 | 監査ログの保持期間は設定可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24について：`ssp.zig`にTODOコメント「Initialize the canary with random data」があり、現在は固定値で初期化されている
  - 候補：将来のバージョンで乱数初期化が実装される可能性 / OSレベルでの初期化に依存
- C-25について：Zigは監査ログシステムを持たず、ログ保持期間の設定機能は存在しない
  - 候補：アプリケーション側で実装 / サードパーティログライブラリの使用

## 5) リスクフラグ（レビュー観点）
- リスク0（低）：暗号プリミティブ実装 - 標準ライブラリで十分検証済み
- リスク0（低）：TLS実装 - TLS 1.3対応、証明書検証実装済み
- リスク1（中）：スタックカナリ初期化 - 固定値での初期化は攻撃者に予測される可能性
- リスク0（低）：タイミング攻撃対策 - timing_safeモジュールで適切に対応

## 6) レビュアーチェックリスト（最小）
- [ ] TLS暗号スイートの優先順位が適切か確認（`lib/std/crypto/tls.zig`）
- [ ] 証明書検証ロジックがRFCに準拠しているか確認（`lib/std/crypto/Certificate.zig`）
- [ ] スタックカナリの初期化方法が運用環境で適切か確認（`lib/compiler_rt/ssp.zig`）
- [ ] ビルドオプションでセキュリティフラグがデフォルトで有効か確認（`src/Compilation/Config.zig`）
- [ ] 定数時間演算がすべての暗号操作で使用されているか確認（`lib/std/crypto/timing_safe.zig`）
