# テスト方針書

## 概要

本ドキュメントは、Zig言語コンパイラプロジェクトにおけるテスト方針を定義するものである。Zigは汎用プログラミング言語およびツールチェーンであり、堅牢性、最適性、再利用性を維持するソフトウェア開発を目指している。テストはコンパイラの品質保証において重要な役割を果たし、複数のプラットフォーム・アーキテクチャに対応したクロスプラットフォームテストを実施する。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | コンパイラの各モジュール（標準ライブラリ、コンパイラソース）の個別機能検証 | 開発者 |
| 結合テスト | 複数モジュール間の連携動作検証（リンカ、コード生成など） | 開発者 |
| 振る舞いテスト | 言語仕様に基づく動作検証（behavior tests） | 開発者 |
| システムテスト | コンパイラ全体としての動作検証、セルフホスティング検証 | CI/開発者 |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 振る舞いテスト (behavior) | Zig言語の各機能（配列、構造体、列挙型、ポインタ等）の動作検証 | コミット時・PR時 |
| コンパイルエラーテスト | コンパイル時エラーの検出・報告機能の検証 | コミット時・PR時 |
| スタックトレーステスト | エラー発生時のスタックトレース出力の検証 | コミット時・PR時 |
| エラートレーステスト | エラートレース機能の検証 | コミット時・PR時 |
| リンクテスト | 各種リンカ機能（ELF, COFF, Wasm, Mach-O）の検証 | コミット時・PR時 |
| スタンドアロンテスト | 独立したビルド・実行テスト | コミット時・PR時 |
| C ABIテスト | C言語との相互運用性テスト | コミット時・PR時 |
| インクリメンタルテスト | インクリメンタルコンパイル機能の検証 | コミット時・PR時 |
| デバッガテスト | GDB/LLDBとの統合テスト | コミット時・PR時 |
| LLVM IRテスト | LLVM中間表現の生成検証 | コミット時・PR時 |
| フォーマットテスト | ソースコードフォーマットの検証 | コミット時・PR時 |
| CLIテスト | コマンドラインインターフェースの検証 | コミット時・PR時 |
| libcテスト | libc互換性テスト | コミット時・PR時 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| aarch64-linux | ARM64 Linux環境でのテスト | self-hosted runner |
| aarch64-macos | ARM64 macOS環境でのテスト | self-hosted runner |
| x86_64-linux | x86_64 Linux環境でのテスト | self-hosted runner |
| x86_64-freebsd | x86_64 FreeBSD環境でのテスト | self-hosted runner |
| x86_64-openbsd | x86_64 OpenBSD環境でのテスト | self-hosted runner |
| x86_64-windows | x86_64 Windows環境でのテスト | self-hosted runner |
| loongarch64-linux | LoongArch64 Linux環境でのテスト | self-hosted runner |
| powerpc64le-linux | PowerPC64LE Linux環境でのテスト | self-hosted runner |
| riscv64-linux | RISC-V 64bit Linux環境でのテスト | self-hosted runner |
| s390x-linux | IBM System z Linux環境でのテスト | self-hosted runner |

### クロスコンパイルテスト対象

テストスイートは以下のクロスコンパイルターゲットをサポートする：

- Linux: aarch64, aarch64_be, arm, armeb, hexagon, loongarch64, mips, powerpc64, riscv64, s390x, x86_64
- FreeBSD: aarch64, arm, powerpc64, riscv64, x86_64
- Windows: x86_64
- macOS: aarch64, x86_64
- WebAssembly: wasm32
- SPIRV: spirv32, spirv64

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| Zig Build System | ビルド・テスト統合 | 0.16.0 |
| CMake | ビルドシステム生成 | >= 3.15 |
| Ninja | ビルド実行 | 最新安定版 |
| QEMU | クロスプラットフォームエミュレーション | 10.2.0 |
| Wasmtime | WebAssemblyランタイム | 38.0.3 |
| GDB | デバッグテスト | システム提供版 |
| LLDB | デバッグテスト | システム提供版 |
| superhtml | HTML検証（langref） | 最新版 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 振る舞いテスト | 全言語機能を網羅 |
| クロスプラットフォーム | 主要アーキテクチャ10種以上 |
| 最適化モード | Debug, ReleaseFast, ReleaseSafe, ReleaseSmall の4モード |

### 最適化モード別テスト

テストは以下の最適化モードで実行される：
- Debug: デバッグビルド
- ReleaseFast: 最大パフォーマンス最適化
- ReleaseSafe: 安全性チェック付き最適化
- ReleaseSmall: バイナリサイズ最小化最適化

## テストデータ

テストデータは以下のディレクトリに配置される：

- `test/behavior/`: 振る舞いテストファイル
- `test/cases/`: コンパイラテストケース
- `test/standalone/`: スタンドアロンテストプロジェクト
- `test/link/`: リンカテストケース
- `test/c_abi/`: C ABI互換性テスト
- `test/incremental/`: インクリメンタルコンパイルテスト

テストデータは以下の特徴を持つ：
- 各テストは自己完結型で、明示的な入力と期待出力を持つ
- コンパイル時エラーテストは期待されるエラーメッセージを含む
- 振る舞いテストは `std.testing` を使用したアサーション

## 不具合管理

不具合はCodebergのイssue Trackerで管理される：
- URL: https://codeberg.org/ziglang/zig/issues
- 不具合テンプレートは `.forgejo/ISSUE_TEMPLATE/` に定義
- 再現可能なテストケースの添付を推奨
- クロスプラットフォーム問題は対象プラットフォームを明記

## CI/CD連携

### CIプラットフォーム

Forgejo Actions（GitHub Actions互換）を使用

### CI設定ファイル

- `.forgejo/workflows/ci.yaml`: メインCIワークフロー定義
- `ci/*.sh`: 各プラットフォーム用ビルド・テストスクリプト
- `ci/*.ps1`: Windows用PowerShellスクリプト

### CIトリガー

- プルリクエスト時: 全テスト実行
- masterブランチへのpush時: 全テスト実行
- 手動ディスパッチ: 任意実行可能

### CI並列実行

- 各プラットフォームは独立して並列実行
- 同一PRでの古いワークフローはキャンセル

### タイムアウト設定

| プラットフォーム | Debug | Release |
| --- | --- | --- |
| x86_64-linux | 180分 | 360分 |
| aarch64-linux | 180分 | 120分 |
| aarch64-macos | 180分 | 120分 |
| x86_64-freebsd | 120分 | 120分 |
| x86_64-windows | 180分 | 180分 |
| riscv64-linux | 660分 | 540分 |
| powerpc64le-linux | 360分 | 240分 |
| s390x-linux | 360分 | 300分 |

### テスト実行コマンド

```bash
# 基本的なテスト実行
zig build test

# 特定のテストフィルタを使用
zig build test -Dtest-filter="behavior"

# 特定のターゲットをスキップ
zig build test -Dskip-windows -Dskip-darwin

# リリースモードでのテスト
zig build test -Doptimize=ReleaseFast

# LLVM統合あり
zig build test -Denable-llvm -Dstatic-llvm
```

## 備考

### セルフホスティング

Zigコンパイラはセルフホスティングを目指しており、stage3/stage4ビルドによる自己コンパイル検証を行う：
1. stage3: ビルドされたコンパイラ
2. stage4: stage3でビルドしたコンパイラ
3. stage4で `test/behavior.zig` を実行して正常性を確認

### メモリ使用量制限

テストには最大RSS（Resident Set Size）制限が設定されている：
- 振る舞いテスト: プラットフォームにより659MB〜3.3GB
- compiler_rtテスト: 574MB〜978MB
- 標準ライブラリテスト: 3.75GB〜8.3GB
- C ABIテスト: 386MB〜2.4GB

### 特殊なテストスキップ条件

以下の条件でテストがスキップされる場合がある：
- `skip-non-native`: ネイティブ以外のターゲットをスキップ
- `skip-libc`: libc依存テストをスキップ
- `skip-single-threaded`: シングルスレッドテストをスキップ
- `skip-compile-errors`: コンパイルエラーテストをスキップ
- `skip-spirv`: SPIRV対象テストをスキップ
- `skip-wasm`: WebAssembly対象テストをスキップ
- `skip-llvm`: LLVMバックエンド使用テストをスキップ
