# ER図

## 概要

本ドキュメントは、Zigコンパイラにおける主要なデータ構造間の関係をMermaid形式のER図で表現します。

**注意**: これは従来のRDBMSのER図ではなく、インメモリデータ構造間の参照関係を表しています。

## 全体構造図

```mermaid
erDiagram
    Zcu ||--|| InternPool : contains
    Zcu ||--o{ File : manages
    Zcu ||--o{ EmbedFile : manages
    Zcu ||--o{ Export : tracks
    Zcu ||--o{ AnalUnit : analyzes
    Zcu }|--|| Package_Module : references

    InternPool ||--o{ TrackedInst : tracks
    InternPool ||--o{ Nav : stores
    InternPool ||--o{ DepEntry : manages
    InternPool ||--o{ Shard : contains
    InternPool ||--o{ Local : contains
    InternPool ||--|| GlobalErrorSet : contains

    Nav }o--|| InternPool_Index : "type/value"
    Nav }o--o| TrackedInst_Index : "zir_index"
    Nav }o--o| NamespaceIndex : namespace

    AnalUnit }o--o| ComptimeUnit_Id : comptime
    AnalUnit }o--o| Nav_Index : nav
    AnalUnit }o--o| InternPool_Index : "type/func"

    DepEntry }o--|| AnalUnit : depender
    DepEntry }o--o| DepEntry : next_dependee
    DepEntry }o--o| DepEntry : next_depender

    TrackedInst }o--|| FileIndex : file
    TrackedInst }o--|| Zir_Inst_Index : inst

    ComptimeUnit }o--|| TrackedInst_Index : zir_index
    ComptimeUnit }o--|| NamespaceIndex : namespace

    Type ||--|| InternPool_Index : wraps
    Value ||--|| InternPool_Index : wraps

    Export }o--|| AnalUnit : owner
    Export }o--|| Nav_Index : nav
```

## コアデータ構造の関係

```mermaid
erDiagram
    InternPool {
        array locals "スレッドローカルストレージ"
        array shards "シャード化データ"
        GlobalErrorSet global_error_set "グローバルエラーセット"
        u32 tid_width "スレッドIDビット幅"
        HashMap src_hash_deps "ソースハッシュ依存"
        HashMap nav_val_deps "Nav値依存"
        HashMap nav_ty_deps "Nav型依存"
        HashMap interned_deps "インターン依存"
        ArrayList dep_entries "依存エントリリスト"
    }

    TrackedInst {
        FileIndex file "ファイルインデックス"
        Zir_Inst_Index inst "ZIR命令インデックス"
    }

    Nav {
        NullTerminatedString name "非修飾名"
        NullTerminatedString fqn "完全修飾名"
        NamespaceIndex analysis_namespace "解析名前空間"
        TrackedInst_Index analysis_zir_index "ZIRインデックス"
        union status "解析状態"
    }

    DepEntry {
        AnalUnit depender "依存元"
        Index next_dependee "次の依存先エントリ"
        Index next_depender "次の依存元エントリ"
    }

    InternPool ||--o{ TrackedInst : tracks
    InternPool ||--o{ Nav : stores
    InternPool ||--o{ DepEntry : manages
```

## 解析ユニット関係図

```mermaid
erDiagram
    AnalUnit {
        Kind kind "ユニット種別"
        u32 id "識別子"
    }

    ComptimeUnit {
        TrackedInst_Index zir_index "ZIR命令"
        NamespaceIndex namespace "名前空間"
    }

    Nav {
        NullTerminatedString name "名前"
        NullTerminatedString fqn "完全修飾名"
        union status "状態"
    }

    InternPool_Index {
        u32 index "インデックス"
    }

    AnalUnit }o--o| ComptimeUnit : "kind=comptime"
    AnalUnit }o--o| Nav : "kind=nav_val/nav_ty"
    AnalUnit }o--o| InternPool_Index : "kind=type/func"
```

## Zcuの構成要素

```mermaid
erDiagram
    Zcu {
        Allocator gpa "汎用アロケータ"
        Compilation comp "コンパイル情報"
        LlvmObject llvm_object "LLVMオブジェクト"
        Package_Module root_mod "ルートモジュール"
        Package_Module main_mod "メインモジュール"
        Package_Module std_mod "標準ライブラリ"
        Cache_Directory global_zir_cache "グローバルZIRキャッシュ"
        Cache_Directory local_zir_cache "ローカルZIRキャッシュ"
        InternPool intern_pool "インターンプール"
    }

    InternPool {
        array locals "ローカルストレージ"
        array shards "シャード"
    }

    File {
        Index index "ファイルインデックス"
    }

    EmbedFile {
        Path path "ファイルパス"
    }

    Export {
        String name "エクスポート名"
        AnalUnit owner "所有者"
    }

    Package_Module {
        String name "モジュール名"
    }

    Zcu ||--|| InternPool : contains
    Zcu ||--o{ File : import_table
    Zcu ||--o{ EmbedFile : embed_table
    Zcu ||--o{ Export : all_exports
    Zcu }|--|| Package_Module : root_mod
    Zcu }|--|| Package_Module : main_mod
    Zcu }|--|| Package_Module : std_mod
```

## 依存関係追跡

```mermaid
erDiagram
    src_hash_deps {
        TrackedInst_Index key "ZIR命令"
        DepEntry_Index value "依存エントリ"
    }

    nav_val_deps {
        Nav_Index key "Nav"
        DepEntry_Index value "依存エントリ"
    }

    nav_ty_deps {
        Nav_Index key "Nav"
        DepEntry_Index value "依存エントリ"
    }

    interned_deps {
        InternPool_Index key "インターン値"
        DepEntry_Index value "依存エントリ"
    }

    DepEntry {
        AnalUnit depender "依存元"
        Index next_dependee "次の依存先"
        Index next_depender "次の依存元"
    }

    src_hash_deps ||--o{ DepEntry : points_to
    nav_val_deps ||--o{ DepEntry : points_to
    nav_ty_deps ||--o{ DepEntry : points_to
    interned_deps ||--o{ DepEntry : points_to
    DepEntry }o--o| DepEntry : linked_list
```

## 型と値のラッパー

```mermaid
erDiagram
    Type {
        InternPool_Index ip_index "インデックス"
    }

    Value {
        InternPool_Index ip_index "インデックス"
    }

    InternPool_Index {
        u32 raw "生値"
    }

    InternPool {
        array data "データストレージ"
    }

    Type ||--|| InternPool_Index : wraps
    Value ||--|| InternPool_Index : wraps
    InternPool_Index }o--|| InternPool : indexes_into
```

## 凡例

| 記号 | 意味 |
|------|------|
| `\|\|--\|\|` | 1対1の関係 |
| `\|\|--o{` | 1対多の関係 |
| `}o--\|\|` | 多対1の関係 |
| `}o--o{` | 多対多の関係 |
| `}o--o\|` | 多対0または1の関係 |
