---
generated_at: 2026-02-01 16:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **Export構造の詳細フィールド**：完全な定義がソースコードから確認困難
  2. **File/EmbedFileの詳細構造**：参照のみで詳細定義未確認
  3. **Shard/Localの内部構造**：概要のみ確認、詳細は未調査

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/InternPool.zig`（1-200行目）
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/InternPool.zig`（200-500行目）
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/InternPool.zig`（500-800行目）
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/Zcu.zig`（1-200行目）
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/Type.zig`（1-100行目）
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/Value.zig`（1-100行目）
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/zig/README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ZigコンパイラはRDBMSを使用していない | E-01, E-04, E-07 | ○ |
| C-02 | InternPoolがメインデータ構造である | E-01 (Line 1-3) | ○ |
| C-03 | InternPoolはlocals/shards/global_error_setを持つ | E-01 (Line 20-26) | ○ |
| C-04 | InternPoolにtid_width/tid_shift_*フィールドがある | E-01 (Line 28-34) | ○ |
| C-05 | InternPoolに各種依存関係HashMapがある | E-01 (Line 42-67) | ○ |
| C-06 | InternPoolにdep_entries/free_dep_entriesがある | E-01 (Line 84-87) | ○ |
| C-07 | TrackedInstはfile/instフィールドを持つ | E-02 (Line 126-128) | ○ |
| C-08 | TrackedInst.Indexは32ビット整数である | E-02 (Line 157) | ○ |
| C-09 | TrackedInst.MaybeLostはlost状態を表現可能 | E-02 (Line 134-155) | ○ |
| C-10 | Navは26バイトのコンパクト表現を使用 | E-03 (Line 735-736) | ○ |
| C-11 | Navはname/fqn/analysis/statusを持つ | E-03 (Line 531-566) | ○ |
| C-12 | Navのstatusは3状態（unresolved/type_resolved/fully_resolved） | E-03 (Line 543-566) | ○ |
| C-13 | AnalUnitはkind/idフィールドを持つpacked struct | E-02 (Line 411-414) | ○ |
| C-14 | AnalUnit.Kindは6種類の列挙値を持つ | E-02 (Line 415-422) | ○ |
| C-15 | ComptimeUnitはzir_index/namespaceを持つ | E-02 (Line 485-487) | ○ |
| C-16 | DepEntryはdepender/next_dependee/next_dependerを持つ | E-01 (Line 76-87)の構造から推測 | ○ |
| C-17 | Zcuはintern_poolを含む | E-04 (Line 176) | ○ |
| C-18 | Zcuはimport_table/embed_tableを持つ | E-04 (Line 126-171) | ○ |
| C-19 | Zcuはall_exports/single_exports/multi_exportsを持つ | E-04 (Line 91-104) | ○ |
| C-20 | Zcuは各種failed_*マップを持つ | E-04 (Line 180-189) | ○ |
| C-21 | Typeはip_indexをラップする | E-05 (Line 22) | ○ |
| C-22 | Valueはip_indexをラップする | E-06 (Line 19) | ○ |
| C-23 | Exportの詳細フィールド定義 | **根拠なし** | △ |
| C-24 | File/EmbedFileの詳細構造 | **根拠不足** | △ |
| C-25 | Shard/Localの内部構造 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Exportの完全な構造定義が未確認
  - 候補：`src/Zcu.zig`の別の箇所 / `src/link.zig` / 別ファイル
- File/EmbedFileのフィールド詳細が未確認
  - 候補：`src/Zcu.zig`の後半部分
- Shard/Localの内部実装詳細が未確認
  - 候補：`src/InternPool.zig`の後半部分

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: InternPool、TrackedInst、Nav、AnalUnit、ComptimeUnit、DepEntry、Type、Valueの構造定義
- **1: 中リスク**: Zcuの一部フィールド（コード量が多いため全体把握が困難）
- **2: 高リスク**: Export、File、EmbedFile、Shard、Localの詳細構造（明示的な確認不足）

## 6) レビュアーチェックリスト（最小）
- [ ] InternPoolの依存関係HashMapフィールド（src_hash_deps等）の使用目的が正しく記述されているか確認
- [ ] Navのstatus unionの3状態の説明が実装と一致しているか確認
- [ ] AnalUnit.Kindの6種類の列挙値が網羅されているか確認
- [ ] Export/File/EmbedFileの詳細フィールドを`src/Zcu.zig`で確認し、必要に応じて追記
- [ ] Shard/Localの内部構造を`src/InternPool.zig`で確認し、必要に応じて追記
- [ ] ER図のリレーション（特に多対多、1対多の関係）が実装と一致しているか確認
