# バッチ設計書 1-update_glibc

## 概要

本ドキュメントは、glibcのスタートファイル（crt1.oなど）を構成する.c、.h、.s、.Sファイルを更新するバッチ処理の設計書です。

### 本バッチの処理概要

**業務上の目的・背景**：Zig言語はクロスコンパイルをサポートするため、glibcのスタートファイルを同梱しています。glibcの上流リポジトリが更新された際に、Zigがバンドルするglibcファイルを最新版に同期する必要があります。このバッチは、手動でのファイルコピーの手間を省き、一貫性のある更新プロセスを提供します。

**バッチの実行タイミング**：随時（glibcの新バージョンリリース時、またはセキュリティパッチ適用時に手動実行）

**主要な処理内容**：
1. glibcソースディレクトリから既存のZig同梱ファイルへのコピー処理
2. 除外ファイル（abilists、生成ファイル、パッチ済みファイル）のスキップ
3. 存在しなくなったファイルの削除
4. generic-glibcディレクトリとの重複ファイルの警告出力

**前後の処理との関連**：本バッチは独立して実行可能です。ただし、abilistsファイルは別プロジェクト（libc-abi-tools）で管理されるため、そちらとの連携が必要です。

**影響範囲**：lib/libc/glibc配下のファイル、クロスコンパイル時のglibc対応環境

## バッチ種別

データ同期処理（外部ソースからのファイル更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動（glibcリリース時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| glibcソースディレクトリ | glibcの最新ソースコードがローカルに展開されていること |
| Zigソースディレクトリ | Zigのソースツリーが存在すること |
| 書き込み権限 | lib/libc/glibc配下への書き込み権限があること |

### 実行可否判定

コマンドライン引数として、glibcソースパスとZigソースパスが正しく指定されていること。ディレクトリが開けない場合はエラー終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| glibc_src_path | string | Yes | なし | glibcソースディレクトリのパス |
| zig_src_path | string | Yes | なし | Zigソースディレクトリのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| glibc_src_path | ディレクトリ | glibcの上流ソースコード |
| lib/libc/glibc | ディレクトリ | Zig同梱のglibcファイル群 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| lib/libc/glibc | ファイル群 | 更新されたglibcファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 元のファイル名を維持 |
| 出力先 | {zig_src_path}/lib/libc/glibc |
| 文字コード | オリジナルを維持 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ glibc_src_path, zig_src_pathを取得
2. 出力先ディレクトリのオープン
   └─ {zig_src_path}/lib/libc/glibcを開く
3. glibcソースディレクトリのオープン
   └─ glibc_src_pathを開く
4. ファイルの同期処理
   └─ 既存ファイルを走査し、除外対象でなければソースからコピー
   └─ ソースに存在しないファイルは削除
5. 重複ファイルの警告出力
   └─ include配下とgeneric-glibc配下の内容比較
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[出力先ディレクトリオープン]
    C --> D[glibcソースディレクトリオープン]
    D --> E[既存ファイルの走査]
    E --> F{除外対象?}
    F -->|Yes| E
    F -->|No| G[ソースからコピー]
    G --> H{ソースに存在?}
    H -->|Yes| E
    H -->|No| I[ファイル削除]
    I --> E
    E --> J[include配下の重複チェック]
    J --> K[警告出力]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | 本バッチはファイル操作のみ |

### テーブル別操作詳細

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FileNotFound | ファイル未発見 | ソースファイルが存在しない | 対象ファイルを削除 |
| ディレクトリオープンエラー | 致命的エラー | 指定パスが無効 | エラーメッセージ出力後終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

バッチが途中で失敗した場合、手動でファイルを確認し、必要に応じて再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位 |
| コミットタイミング | 各ファイルコピー完了時 |
| ロールバック条件 | 該当なし（ファイル操作のため） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百ファイル |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | 10MB |

## 排他制御

同時実行不可。同じディレクトリに対する複数プロセスからの更新は未サポート。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | コピー失敗時 | ファイルパスとエラー詳細 |
| 警告ログ | 重複検出時 | 重複ファイルのパス情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- 使用例: `zig run tools/update_glibc.zig -- ~/Downloads/glibc ..`
- abilistsファイルは別プロジェクト（https://codeberg.org/ziglang/libc-abi-tools）で管理
- パッチ済みファイル（stdlib/at_quick_exit.c、stdlib/atexit.c、sysdeps/pthread/pthread_atfork.c）は更新対象外
