# バッチ設計書 10-gen_outline_atomics

## 概要

本ドキュメントは、AArch64のアウトラインアトミクス関数を自動生成するバッチ処理の設計書です。

### 本バッチの処理概要

**業務上の目的・背景**：AArch64アーキテクチャでは、LSE（Large System Extensions）命令をサポートするCPUとサポートしないCPUが混在しています。アウトラインアトミクスは、実行時にLSEサポートを検出し、適切な実装を選択するための関数群です。これらの関数は定型的なパターンに従うため、手動実装は冗長でエラーが発生しやすくなります。このバッチは、全ての組み合わせ（操作×サイズ×メモリオーダー）のアウトラインアトミクス関数を自動生成します。

**バッチの実行タイミング**：随時（アウトラインアトミクス実装の更新時に手動実行）

**主要な処理内容**：
1. アトミック操作（cas, swp, ldadd, ldclr, ldeor, ldset）の列挙
2. サイズ（1, 2, 4, 8, 16バイト）の列挙
3. メモリオーダー（relax, acq, rel, acq_rel）の列挙
4. 各組み合わせについてLSE/非LSE両方の実装を含むZig関数を生成
5. エクスポート宣言の生成

**前後の処理との関連**：本バッチは独立して実行可能です。生成されたコードはZigのlibcサポートで使用されます。

**影響範囲**：lib/std/特殊関数（アウトラインアトミクス）

## バッチ種別

コード生成処理（パターンからのコード自動生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動（実装更新時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 特になし | 引数なしで実行可能 |

### 実行可否判定

特になし。即座に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| なし | - | 全て内部定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | Zigソースコード | アウトラインアトミクス関数定義 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 標準出力（リダイレクトで保存） |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. ヘッダー出力
   └─ インポート文、グローバル変数定義
2. サイズループ（1, 2, 4, 8, 16）
   └─ 16バイトはcasのみ
3. メモリオーダーループ（relax, acq, rel, acq_rel）
4. 操作ループ（cas, swp, ldadd, ldclr, ldeor, ldset）
5. 関数名生成
   └─ __aarch64_{op}{size}_{order}
6. 関数本体生成
   └─ LSEパスと非LSEパスのインラインアセンブリ
7. エクスポート宣言追加
   └─ footer配列に追加
8. フッター出力
   └─ comptime { @export(...); }ブロック
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ヘッダー出力]
    B --> C[サイズループ]
    C --> D[メモリオーダーループ]
    D --> E[操作ループ]
    E --> F{16バイト && cas以外?}
    F -->|Yes| E
    F -->|No| G[関数名生成]
    G --> H[関数本体生成]
    H --> I[エクスポート宣言追加]
    I --> E
    E --> D
    D --> C
    C --> J[フッター出力]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | 本バッチはファイル操作のみ |

### テーブル別操作詳細

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | - | - | エラー処理なし（生成は常に成功） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

該当なし

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 処理全体 |
| コミットタイミング | flush()呼び出し時 |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約100関数（6操作 × 5サイズ × 4オーダー、一部除外） |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 10MB |

## 排他制御

該当なし（標準出力への出力のため）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | - |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- サポート操作：cas（compare-and-swap）、swp（swap）、ldadd（load-add）、ldclr（load-clear）、ldeor（load-exclusive-or）、ldset（load-set）
- サポートサイズ：1, 2, 4, 8, 16バイト（16バイトはcasのみ）
- サポートオーダー：relax（relaxed）、acq（acquire）、rel（release）、acq_rel（acquire-release）
- __aarch64_have_lse_atomics：ランタイムでLSEサポートを検出するフラグ
- always_has_lse：コンパイル時にLSEサポートが確定している場合のフラグ
- 関数は16バイトアラインメント、nakedコンベンション
- LSE命令は.inst疑似命令でエンコード
- 非LSE実装はldxr/stxrループを使用
- レジスタ：w15, w16, w17をクローバー、memory制約
