# バッチ設計書 11-generate_linux_syscalls

## 概要

本ドキュメントは、Linuxカーネルソースからシステムコール番号を抽出し、Zigコードを自動生成するバッチ処理`generate_linux_syscalls`の設計書である。

### 本バッチの処理概要

このバッチは、Linuxカーネルのソースツリーから各アーキテクチャのシステムコール番号を抽出し、Zig言語で使用可能な列挙型（enum）として定義されたコードを自動生成する。生成されたコードは`lib/std/os/linux/syscalls.zig`ファイルを置き換えるために使用される。

**業務上の目的・背景**：Zigはクロスプラットフォーム対応のプログラミング言語であり、Linuxシステムコールを直接呼び出す機能を提供している。Linuxカーネルのバージョンアップに伴い、新しいシステムコールが追加されたり、アーキテクチャごとのシステムコール番号が変更されることがある。このバッチは、カーネルの公式ソースから正確なシステムコール情報を抽出することで、Zigの標準ライブラリを最新のカーネル仕様に同期させる役割を果たす。

**バッチの実行タイミング**：Linuxカーネルの新バージョンリリース時、または Zig の新バージョンリリース準備時に随時実行される。特にカーネル6.11以降では統一テーブル形式に対応している。

**主要な処理内容**：
1. Linuxカーネルソースツリーからバージョン情報を読み取る（Makefileから VERSION, PATCHLEVEL, SUBLEVEL を抽出）
2. 各アーキテクチャのシステムコールテーブルファイルを解析
3. ABI（Application Binary Interface）フィールドに基づいてシステムコールをフィルタリング
4. アーキテクチャ固有のオフセット（x32、MIPS等）を適用
5. Zig言語の列挙型（enum）として標準出力にコードを生成

**前後の処理との関連**：本バッチは単独で実行可能。生成された出力は手動で`lib/std/os/linux/syscalls.zig`に反映する必要がある。

**影響範囲**：Zigの標準ライブラリにおけるLinuxシステムコール定義。22のアーキテクチャ（X86, X64, X32, Arm, Sparc, Sparc64, M68k, MipsO32, MipsN64, MipsN32, PowerPC, PowerPC64, S390x, Xtensa, Arm64, RiscV32, RiscV64, LoongArch64, Arc, CSky, Hexagon, OpenRisc）をサポート。

## バッチ種別

コード生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | Linuxカーネル新バージョンリリース時 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linuxカーネルソースツリー | ローカルに展開されたLinuxカーネルソースが必要 |
| カーネルバージョン | 6.11以降の統一テーブル形式に対応 |
| Zigコンパイラ | zig runで実行可能な環境 |

### 実行可否判定

- Linuxカーネルソースのパスが引数として指定されていること
- 指定されたパスにMakefileおよびシステムコールテーブルファイルが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| linux_path | string | Yes | なし | Linuxカーネルソースツリーへのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Makefile | テキスト | カーネルバージョン情報（VERSION, PATCHLEVEL, SUBLEVEL） |
| scripts/syscall.tbl | テーブル | 汎用アーキテクチャ用システムコールテーブル |
| arch/x86/entry/syscalls/syscall_32.tbl | テーブル | x86 32bitシステムコールテーブル |
| arch/x86/entry/syscalls/syscall_64.tbl | テーブル | x86 64bitシステムコールテーブル |
| arch/arm/tools/syscall.tbl | テーブル | ARMシステムコールテーブル |
| arch/sparc/kernel/syscalls/syscall.tbl | テーブル | SPARCシステムコールテーブル |
| arch/m68k/kernel/syscalls/syscall.tbl | テーブル | M68Kシステムコールテーブル |
| arch/mips/kernel/syscalls/syscall_*.tbl | テーブル | MIPSシステムコールテーブル（o32, n64, n32） |
| arch/powerpc/kernel/syscalls/syscall.tbl | テーブル | PowerPCシステムコールテーブル |
| arch/s390/kernel/syscalls/syscall.tbl | テーブル | S390xシステムコールテーブル |
| arch/xtensa/kernel/syscalls/syscall.tbl | テーブル | Xtensaシステムコールテーブル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | Zigソースコード | 各アーキテクチャのシステムコール列挙型定義 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 標準出力（リダイレクトでsyscalls.zigに保存） |
| 出力先 | lib/std/os/linux/syscalls.zig |
| 文字コード | UTF-8 |
| 区切り文字 | なし（Zigソースコード） |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ linux_pathを取得、未指定の場合はヘルプを表示

2. カーネルバージョン取得
   └─ Makefileから VERSION, PATCHLEVEL, SUBLEVEL を読み取り

3. ヘッダーコメント出力
   └─ 自動生成であることとカーネルバージョンを記載

4. アーキテクチャごとの処理（22アーキテクチャ）
   ├─ システムコールテーブルファイルの読み込み
   ├─ 各行の解析（番号、ABI、名前）
   ├─ ABIフィルタリング（アーキテクチャ固有のABIに基づく）
   ├─ 予約済みシステムコールの除外（available, reserved, unused）
   ├─ システムコール名のリネーム処理（_llseek→llseek等）
   ├─ オフセットの適用（x32, MIPS）
   └─ enum定義の出力

5. 特殊処理
   └─ ARM: 追加のシステムコール（breakpoint, cacheflush等）をフッターとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|引数なし| C[ヘルプ表示]
    C --> D[終了]
    B -->|引数あり| E[Linuxソースパス取得]
    E --> F[Makefileからバージョン読み取り]
    F --> G[ヘッダー出力]
    G --> H[アーキテクチャループ開始]
    H --> I[テーブルファイル読み込み]
    I --> J[行解析・フィルタリング]
    J --> K[enum定義出力]
    K --> L{次のアーキテクチャ?}
    L -->|Yes| H
    L -->|No| M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | linux_pathが未指定 | ヘルプメッセージを表示して終了 |
| - | ファイル読み取りエラー | テーブルファイルが存在しない | panicを発生させる |
| - | パースエラー | システムコール番号が不正 | panicを発生させる |
| - | ABIフィールドエラー | ABIフィールドが不正 | panicを発生させる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

ファイル読み取りエラーやパースエラーが発生した場合、プログラムはpanicで終了する。カーネルソースツリーの整合性を確認し、再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイル操作のみ） |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約22アーキテクチャ、各数百システムコール |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 32KB（テーブルファイルバッファ） |

## 排他制御

同時実行の制限なし。出力は標準出力へ行われるため、ファイルロックは不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | 本バッチは標準出力にZigコードを出力するのみ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- 使用例: `zig run tools/generate_linux_syscalls.zig -- /path/to/linux`
- カーネル6.11以降の統一テーブル形式（`# Comment`で始まるコメント行、`<number> <abi> <name> ...`のフォーマット）に対応
- stdlib_renames: 一部のシステムコール名はZig標準ライブラリでの命名規則に合わせてリネームされる（例: `_llseek` → `llseek`）
- ARM固有のシステムコール（breakpoint, cacheflush, usr26, usr32, set_tls, get_tls）はヘッダーファイルから移植されていないため、フッターとして直接追加される
