# バッチ設計書 12-update_clang_options

## 概要

本ドキュメントは、LLVMのClangコンパイラのoptions.tdファイルからコマンドラインオプション定義を抽出し、Zigコンパイラの`zig cc`プロキシ機能で使用するオプションデータファイルを自動生成するバッチ処理の設計を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：Zigコンパイラは`zig cc`コマンドによりClangのフロントエンドとして機能する。ユーザーがClangオプションを指定した際、ZigはそれをClangに透過的に渡すか、または特定のオプションを解釈してZig独自の動作に変換する必要がある。Clangのオプションは非常に多数存在し、また新しいバージョンで追加・変更されるため、LLVMソースから自動抽出することで保守性と正確性を確保する。特に、オプションが次の引数を「消費」するかどうか（例：`-target foo`は`foo`を消費する）を正確に把握することが重要である。

**バッチの実行タイミング**：LLVMの新バージョンがリリースされた際、またはZigコンパイラが新しいLLVMバージョンに対応する際に随時実行される。

**主要な処理内容**：
1. llvm-tblgenコマンドを--dump-jsonオプション付きで実行し、ClangのOptions.tdをJSON形式でダンプする
2. 出力されたJSONを解析し、各オプションの名前、構文タイプ（flag、joined、separate等）、プレフィックス（-、--、/）を抽出する
3. 既知のオプション（target、-o、-c、-O等）に対してはZig内部での処理方法を対応付ける
4. CPU機能オプション（-mno-xxx、-mxxx）はLLVMからZigの機能名へのマッピングを行う
5. 優先度順（完全一致→プレフィックス一致（長い順））にソートする
6. Zigソースコード形式で標準出力に出力する

**前後の処理との関連**：本バッチの出力は`src/clang_options_data.zig`の内容を置き換えるために使用される。llvm-tblgenの実行が前提となるため、LLVMビルド環境が必要。

**影響範囲**：`zig cc`コマンドの全てのオプション解析に影響する。Cコンパイラとしての互換性に直接関わる重要なファイルを生成する。

## バッチ種別

コード生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（LLVMバージョンアップ時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| llvm-tblgen実行ファイル | LLVMビルドからllvm-tblgenが利用可能であること |
| LLVMソースツリー | llvm-projectのソースコードがローカルに存在すること |
| Zig実行環境 | `zig run`コマンドが実行可能な環境であること |

### 実行可否判定

llvm-tblgenのパスとllvm-projectのパスが引数として正しく指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| llvm_tblgen_exe | string | Yes | なし | llvm-tblgen実行ファイルのパス |
| llvm_src_root | string | Yes | なし | llvm-projectソースツリーのルートパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| clang/include/clang/Driver/Options.td | TableGen | Clangオプション定義ファイル |
| llvm/include/*.td | TableGen | LLVM共通定義（インクルード） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | Zigソースコード | オプション定義配列 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | clang_options_data.zig（標準出力をリダイレクト） |
| 出力先 | src/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ llvm_tblgen_exe、llvm_src_rootの取得

2. CPU機能マッピングテーブルの構築
   └─ 27種類のCPUターゲットからLLVM→Zig機能名マッピングを作成

3. llvm-tblgenの実行
   └─ --dump-jsonオプションでOptions.tdをJSON形式で出力
   └─ 最大100MBの出力を受け取る

4. JSON解析
   └─ NumArgsとNameフィールドを持つオブジェクトを抽出
   └─ ブラックリストオプションを除外

5. オプションのソート
   └─ 優先度順（完全一致→プレフィックス一致の長い順）

6. 各オプションの処理
   ├─ プレフィックス（-, --, /）の判定
   ├─ 構文タイプ（flag, joined, separate等）の判定
   ├─ 既知オプションの場合はzig_equivalentを設定
   └─ CPU機能オプションの場合はmacro形式で出力

7. Zigコード出力
   └─ CliArg構造体の配列として出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|不足| C[使用方法を表示して終了]
    B -->|OK| D[CPU機能マッピング構築]
    D --> E[llvm-tblgen実行]
    E --> F{正常終了?}
    F -->|No| G[エラーで終了]
    F -->|Yes| H[JSON解析]
    H --> I[オブジェクトフィルタリング]
    I --> J[優先度順ソート]
    J --> K[ヘッダー出力]
    K --> L[オプションループ]
    L --> M{既知オプション?}
    M -->|Yes| N[フルフォーマット出力]
    M -->|No| O{CPU機能?}
    O -->|Yes| P[m()マクロ出力]
    O -->|No| Q{単純フラグ?}
    Q -->|Yes| R[flagpd1()等出力]
    Q -->|No| S[フルフォーマット出力]
    N --> T{次のオプション?}
    P --> T
    R --> T
    S --> T
    T -->|Yes| L
    T -->|No| U[フッター出力]
    U --> V[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | llvm_tblgen_exeまたはllvm_src_rootが未指定 | 使用方法を表示してexit(1) |
| - | 子プロセスエラー | llvm-tblgenが異常終了 | エラーコードを表示してexit(1) |
| - | クラッシュ | llvm-tblgenがクラッシュ | メッセージを表示してexit(1) |
| - | JSONパースエラー | 出力JSONが不正 | エラーを返す |
| - | 未知のプレフィックス | 認識できないオプションプレフィックス | エラーメッセージを出力してexit(1) |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

llvm-tblgenのエラーが発生した場合は、stderrに出力されたエラーメッセージを確認する。LLVMソースのパスやllvm-tblgenのビルド状態を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（外部プロセス実行とファイル操作） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千のオプション定義 |
| 目標処理時間 | 数十秒（llvm-tblgenの実行時間に依存） |
| メモリ使用量上限 | 100MB（llvm-tblgen出力バッファ） |

## 排他制御

本バッチは単一プロセスでの実行を想定しており、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | llvm-tblgen失敗時 | 終了コードとstderr |
| 警告ログ | 未認識プレフィックス検出時 | オプション名とプレフィックス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | 手動実行のため監視対象外 |

## 備考

- 使用例: `zig run tools/update_clang_options.zig -- /path/to/llvm-tblgen /path/to/llvm-project`
- 出力は`src/clang_options_data.zig`を置き換えるために使用
- 既知オプションは90種類以上定義されている（target, -o, -c, -O, -g等）
- 構文タイプ: flag（フラグ）、joined（値と結合）、separate（次引数）、joined_or_separate、joined_and_separate、comma_joined、remaining_args_joined、multi_arg
- サポートするCPUターゲット: aarch64, amdgcn, arc, arm, avr, bpf, csky, hexagon, loongarch, m68k, mips, msp430, nvptx, powerpc, riscv, s390x, sparc, spirv, ve, wasm, x86, xtensa等27種類
