# バッチ設計書 13-process_headers

## 概要

本ドキュメントは、glibc、musl、FreeBSD、NetBSD、OpenBSDの各Cライブラリのヘッダーファイルを処理し、Zigのクロスコンパイル機能で使用する統合ヘッダーを生成するバッチ処理の設計を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：Zigはクロスコンパイル機能を提供しており、任意のターゲットアーキテクチャ向けにCコードをコンパイルできる。しかし、各Cライブラリ（glibc、musl等）のビルドシステムは単一ターゲットアーキテクチャのみをサポートする。本バッチは、複数アーキテクチャのヘッダーファイルを統合し、アーキテクチャ共通のヘッダーを「generic」サブディレクトリに、アーキテクチャ固有のヘッダーを各アーキテクチャ名のサブディレクトリに配置することで、Zigの即座のクロスコンパイルを実現する。

**バッチの実行タイミング**：各Cライブラリの新バージョンがリリースされた際、またはZigが新しいターゲットアーキテクチャをサポートする際に随時実行される。

**主要な処理内容**：
1. 指定されたABI（glibc、musl、freebsd、netbsd、openbsd）に基づいてターゲットリストを選択
2. 検索パスから各ターゲットのincludeディレクトリを探索
3. 各ヘッダーファイルのBlake3ハッシュを計算し、内容の重複を検出
4. 最も多くのターゲットで共有されるヘッダーを「generic」として配置
5. アーキテクチャ固有のヘッダーは各ターゲット名のサブディレクトリに配置
6. 重複削減によるディスク容量の最適化を報告

**前後の処理との関連**：事前に各ターゲットのCライブラリをビルドし、インストールディレクトリを用意する必要がある。本バッチの出力は手動でZigソースリポジトリに反映する。

**影響範囲**：Zigがシップするlibcヘッダー全体に影響。glibc（32ターゲット）、musl（16ターゲット）、FreeBSD（6ターゲット）、NetBSD（12ターゲット）、OpenBSD（10ターゲット）をサポート。

## バッチ種別

ヘッダー処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（Cライブラリ更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Cライブラリのビルド済みインストール | 各ターゲットアーキテクチャのincludeディレクトリが存在すること |
| Zig実行環境 | `zig run`コマンドが実行可能な環境であること |

### 実行可否判定

--abiと--outオプションが指定され、少なくとも1つの--search-pathが指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --search-path | string | Yes（複数可） | なし | ヘッダーファイルの検索パス |
| --out | string | Yes | なし | 出力ディレクトリ |
| --abi | string | Yes | なし | 対象ABI（glibc/musl/freebsd/netbsd/openbsd） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| {search-path}/{target}/usr/include/**/*.h | ヘッダーファイル | glibc/FreeBSD/NetBSD/OpenBSDのヘッダー |
| {search-path}/{target}/usr/local/musl/include/**/*.h | ヘッダーファイル | muslのヘッダー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {out}/generic-{abi}/**/*.h | ヘッダーファイル | アーキテクチャ共通ヘッダー |
| {out}/{target}/**/*.h | ヘッダーファイル | アーキテクチャ固有ヘッダー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 元のヘッダーファイル名を維持 |
| 出力先 | --outで指定したディレクトリ |
| 文字コード | 元ファイルの文字コードを維持 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ --search-path、--out、--abiの取得

2. ターゲットリストの選択
   └─ ABIに基づいてglibc_targets/musl_targets/etc.を選択

3. 各ターゲットのヘッダー収集
   ├─ 検索パスからincludeディレクトリを特定
   ├─ ディレクトリを再帰的に走査
   ├─ 各ファイルの内容を読み取り、トリミング
   └─ Blake3ハッシュを計算

4. 重複検出とカウント
   ├─ ハッシュをキーとして内容をマッピング
   └─ 同一ハッシュのファイル数をカウント

5. ジェネリック判定とファイル配置
   ├─ 最も多くのターゲットで共有されるハッシュを特定
   ├─ 共有ファイルをgeneric-{abi}ディレクトリに配置
   └─ 固有ファイルを各ターゲットディレクトリに配置

6. サマリー出力
   └─ 削減可能なバイト数を報告
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{引数は有効?}
    C -->|No| D[使用方法を表示して終了]
    C -->|Yes| E[ABIに基づくターゲット選択]
    E --> F[ターゲットループ開始]
    F --> G[includeディレクトリ探索]
    G --> H[ファイル再帰走査]
    H --> I[Blake3ハッシュ計算]
    I --> J[重複マッピング更新]
    J --> K{次のターゲット?}
    K -->|Yes| F
    K -->|No| L[重複カウントでソート]
    L --> M[ファイル配置ループ]
    M --> N{共有数>1?}
    N -->|Yes| O[genericディレクトリに配置]
    N -->|No| P[ターゲットディレクトリに配置]
    O --> Q{次のファイル?}
    P --> Q
    Q -->|Yes| M
    Q -->|No| R[サマリー出力]
    R --> S[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | --out、--abiが未指定 | 使用方法を表示してexit(1) |
| - | ABI不正 | 認識できないABI名 | エラーメッセージを表示してexit(1) |
| - | ターゲット未発見 | 検索パスにターゲットディレクトリがない | 警告メッセージを出力して継続 |
| - | ファイルエラー | ファイル読み取り/書き込み失敗 | エラーを返す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ターゲットが見つからない場合は警告を出力して処理を継続する。ファイルI/Oエラーの場合はエラーを返して終了する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千のヘッダーファイル（ターゲットあたり） |
| 目標処理時間 | 数分（ファイル数に依存） |
| メモリ使用量上限 | 2GB（ファイル読み取りバッファ） |

## 排他制御

本バッチは単一プロセスでの実行を想定しており、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 重複検出時 | ターゲット名、相対パス、ファイルサイズ |
| 警告ログ | ターゲット未発見時 | ターゲット名 |
| 警告ログ | 不明なファイル種別時 | ファイルパス |
| サマリーログ | 処理終了時 | 総バイト数と削減可能バイト数 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | 手動実行のため監視対象外 |

## 備考

- 使用例: `zig run tools/process_headers.zig -- --search-path /path/to/builds --out /path/to/output --abi glibc`
- サポートするABI: glibc、musl、freebsd、netbsd、openbsd
- glibcターゲット（32種）: arc, arm(gnueabi/gnueabihf), armeb, aarch64, aarch64_be, csky, loongarch64, m68k, mips系, powerpc系, riscv系, s390x, sparc系, x86系
- muslターゲット（16種）: arm, aarch64, hexagon, loongarch64, m68k, mips系, powerpc系, riscv系, s390x, x86系
- FreeBSDターゲット（6種）: arm, aarch64, powerpc64, riscv64, x86, x86_64
- NetBSDターゲット（12種）: arm系, aarch64, m68k, mips, powerpc, sparc系, x86系
- OpenBSDターゲット（10種）: arm, aarch64, mips64系, powerpc系, riscv64, sparc64, x86系
- Blake3ハッシュでファイル内容の同一性を判定
- ファイル内容の空白トリミング後にハッシュを計算
