# バッチ設計書 14-update-linux-headers

## 概要

本ドキュメントは、Linuxカーネルヘッダーを処理し、Zigがシップするlibcヘッダーを生成するバッチ処理の設計を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：Linuxカーネルのビルドシステムは単一ターゲットアーキテクチャのみをサポートする。Zigはクロスコンパイル機能を提供するため、複数アーキテクチャのLinuxカーネルヘッダーを統合する必要がある。本バッチは、複数アーキテクチャのヘッダーを処理し、アーキテクチャ共通のヘッダーを「any-linux-any」ディレクトリに、アーキテクチャ固有のヘッダーを各アーキテクチャ名のディレクトリに配置する。

**バッチの実行タイミング**：Linuxカーネルの新バージョンがリリースされた際、またはZigが新しいターゲットアーキテクチャをサポートする際に随時実行される。

**主要な処理内容**：
1. 検索パスから各ターゲットのincludeディレクトリを探索
2. 14種類のLinuxターゲットアーキテクチャを処理
3. 各ヘッダーファイルのBlake3ハッシュを計算し、内容の重複を検出
4. 最も多くのターゲットで共有されるヘッダーを「any-linux-any」として配置
5. アーキテクチャ固有のヘッダーは「{arch}-linux-any」ディレクトリに配置
6. netfilterの特定ファイル（大文字小文字で競合するもの）を削除

**前後の処理との関連**：事前に各ターゲットのLinuxカーネルヘッダーをインストールする必要がある。本バッチの出力は手動でZigソースリポジトリに反映する。

**影響範囲**：ZigがシップするLinuxカーネルヘッダー全体に影響。14のアーキテクチャ（arc, arm, arm64, csky, hexagon, m68k, loongarch, mips, powerpc, riscv, s390, sparc, x86, xtensa）をサポート。

## バッチ種別

ヘッダー処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（Linuxカーネル更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linuxカーネルヘッダーのインストール | 各ターゲットアーキテクチャのincludeディレクトリが存在すること |
| Zig実行環境 | `zig run`コマンドが実行可能な環境であること |

### 実行可否判定

--search-pathと--outオプションが指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --search-path | string | Yes（複数可） | なし | ヘッダーファイルの検索パス |
| --out | string | Yes | なし | 出力ディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| {search-path}/{target}/include/**/*.h | ヘッダーファイル | Linuxカーネルヘッダー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {out}/any-linux-any/**/*.h | ヘッダーファイル | アーキテクチャ共通ヘッダー |
| {out}/{arch}-linux-any/**/*.h | ヘッダーファイル | アーキテクチャ固有ヘッダー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 元のヘッダーファイル名を維持 |
| 出力先 | --outで指定したディレクトリ |
| 文字コード | 元ファイルの文字コードを維持 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ --search-path、--outの取得

2. 各ターゲットのヘッダー収集
   ├─ linux_targets配列（14種）を順次処理
   ├─ 検索パスからincludeディレクトリを特定
   ├─ ディレクトリを再帰的に走査
   └─ Blake3ハッシュを計算

3. 重複検出とカウント
   ├─ ハッシュをキーとして内容をマッピング
   └─ 同一ハッシュのファイル数をカウント

4. ジェネリック判定とファイル配置
   ├─ 最も多くのターゲットで共有されるハッシュを特定
   ├─ 共有ファイルをany-linux-anyディレクトリに配置
   └─ 固有ファイルを{arch}-linux-anyディレクトリに配置

5. 特定ファイルの削除
   └─ bad_files配列で定義されたnetfilterヘッダーを削除

6. サマリー出力
   └─ 削減可能なバイト数を報告
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{引数は有効?}
    C -->|No| D[使用方法を表示して終了]
    C -->|Yes| E[linux_targets処理ループ]
    E --> F[includeディレクトリ探索]
    F --> G[ファイル再帰走査]
    G --> H[Blake3ハッシュ計算]
    H --> I[重複マッピング更新]
    I --> J{次のターゲット?}
    J -->|Yes| E
    J -->|No| K[重複カウントでソート]
    K --> L[ファイル配置ループ]
    L --> M{共有数>1?}
    M -->|Yes| N[any-linux-anyに配置]
    M -->|No| O[{arch}-linux-anyに配置]
    N --> P{次のファイル?}
    O --> P
    P -->|Yes| L
    P -->|No| Q[bad_files削除]
    Q --> R[サマリー出力]
    R --> S[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | --outが未指定 | 使用方法を表示してexit(1) |
| - | ターゲット未発見 | 検索パスにターゲットディレクトリがない | 警告メッセージを出力して継続 |
| - | ファイルエラー | ファイル読み取り/書き込み失敗 | エラーを返す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ターゲットが見つからない場合は警告を出力して処理を継続する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千のヘッダーファイル |
| 目標処理時間 | 数分（ファイル数に依存） |
| メモリ使用量上限 | 2GB（ファイル読み取りバッファ） |

## 排他制御

本バッチは単一プロセスでの実行を想定しており、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 重複検出時 | ターゲット名、相対パス、ファイルサイズ |
| 警告ログ | ターゲット未発見時 | ターゲット名 |
| 警告ログ | 不明なファイル種別時 | ファイルパス |
| サマリーログ | 処理終了時 | 総バイト数と削減可能バイト数 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | 手動実行のため監視対象外 |

## 備考

- 使用例: `zig run tools/update-linux-headers.zig -- --search-path /path/to/builds --out /path/to/output`
- ジェネリックディレクトリ名: any-linux-any
- アーキテクチャ固有ディレクトリ名: {arch}-linux-any
- サポートするターゲット（14種）:
  - arc (specific)
  - arm (multi-arch)
  - arm64/aarch64 (specific)
  - csky (specific)
  - hexagon (specific)
  - m68k (specific)
  - loongarch (multi-arch)
  - mips (multi-arch)
  - powerpc (multi-arch)
  - riscv (multi-arch)
  - s390 (specific)
  - sparc (specific)
  - x86 (multi-arch)
  - xtensa (specific)
- 削除対象ファイル（bad_files）:
  - any-linux-any/linux/netfilter/xt_CONNMARK.h
  - any-linux-any/linux/netfilter/xt_DSCP.h
  - any-linux-any/linux/netfilter/xt_MARK.h
  - any-linux-any/linux/netfilter/xt_RATEEST.h
  - any-linux-any/linux/netfilter/xt_TCPMSS.h
  - any-linux-any/linux/netfilter_ipv4/ipt_ECN.h
  - any-linux-any/linux/netfilter_ipv4/ipt_TTL.h
  - any-linux-any/linux/netfilter_ipv6/ip6t_HL.h
- これらのファイルは大文字小文字の違いで競合するため削除される
