# バッチ設計書 15-fetch_them_macos_headers

## 概要

本ドキュメントは、macOSのSDKからヘッダーファイルを取得し処理するバッチ処理の設計を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：Zigはクロスコンパイル機能を提供しており、macOSターゲット向けにもコードをコンパイルできる。macOSのヘッダーファイルを取得し、Zigのプロジェクトで使用可能な形式に整理する必要がある。本バッチは、指定されたmacOS SDKからヘッダーファイルを抽出し、aarch64とx86_64の両アーキテクチャ向けに処理する。

**バッチの実行タイミング**：macOSの新バージョンがリリースされた際、またはZigが新しいmacOSバージョンをサポートする際に随時実行される。

**主要な処理内容**：
1. macOS SDKのsysrootパスを取得（引数または自動検出）
2. SDKSettings.jsonからデプロイメントターゲットバージョンを読み取る
3. aarch64とx86_64の2つのアーキテクチャを順次処理
4. ccコンパイラを使用してmacos-headers.cをコンパイルし、依存ヘッダーリストを生成
5. 依存リスト（.d ファイル）を解析してヘッダーファイルをコピー
6. 各アーキテクチャ・バージョン別のディレクトリに配置

**前後の処理との関連**：macOS SDK（Xcode Command Line Tools）がインストールされている必要がある。macos-headers.cファイルが作業ディレクトリに存在する必要がある。本バッチの出力はheadersディレクトリに配置される。

**影響範囲**：Zigがシップするmacosヘッダー全体に影響。macOS 10.15 (Catalina)から26.x (Tahoe)までの幅広いバージョンをサポート。

## バッチ種別

ヘッダー処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（macOS新バージョンリリース時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| macOS SDK | Xcode Command Line Toolsがインストールされていること |
| ccコマンド | Cコンパイラが利用可能であること |
| macos-headers.c | 作業ディレクトリにmacos-headers.cが存在すること |
| headersディレクトリ | 出力先のheadersディレクトリが存在すること |

### 実行可否判定

SDKのパスが引数で指定されているか、または自動検出可能であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --sysroot | string | No | 自動検出 | macOS SDKのパス |
| [cc args] | string[] | No | なし | ccコマンドに渡す追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SDKSettings.json | JSON | SDKバージョン情報（MACOSX_DEPLOYMENT_TARGET） |
| macos-headers.c | Cソース | ヘッダー依存関係の取得用ダミーファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| headers/{arch}-macos.{version}-none/**/*.h | ヘッダーファイル | アーキテクチャ・バージョン別ヘッダー |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 元のヘッダーファイル名を維持 |
| 出力先 | headers/{arch}-macos.{version}-none/ |
| 文字コード | 元ファイルの文字コードを維持 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ --sysroot、追加cc引数の取得

2. SDKパスの決定
   ├─ --sysrootが指定されていればそれを使用
   └─ 未指定の場合はzig.system.darwin.getSdkで自動検出

3. バージョン情報の取得
   └─ SDKSettings.jsonからMACOSX_DEPLOYMENT_TARGETを解析

4. アーキテクチャループ（aarch64, x86_64）
   ├─ ccコマンドの構築
   │   ├─ -arch {arch}
   │   ├─ -mmacosx-version-min={version}
   │   ├─ -isysroot {sysroot}
   │   ├─ -iwithsysroot /usr/include
   │   └─ -MD -MV -MF（依存ファイル生成）
   ├─ ccコマンドの実行
   ├─ 依存ファイル（.d）の解析
   └─ ヘッダーファイルのコピー

5. 出力ディレクトリの準備
   └─ 既存ディレクトリの削除と再作成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{--sysroot指定?}
    C -->|Yes| D[指定パスを使用]
    C -->|No| E[SDK自動検出]
    E --> F{検出成功?}
    F -->|No| G[エラー終了]
    F -->|Yes| D
    D --> H[SDKSettings.json読み取り]
    H --> I[バージョン解析]
    I --> J[aarch64処理]
    J --> K[ccコマンド実行]
    K --> L[依存ファイル解析]
    L --> M[ヘッダーコピー]
    M --> N[x86_64処理]
    N --> O[ccコマンド実行]
    O --> P[依存ファイル解析]
    P --> Q[ヘッダーコピー]
    Q --> R[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | SDK未検出 | --sysroot未指定かつ自動検出失敗 | エラーメッセージを表示してfatal終了 |
| - | バージョン解析エラー | SDKSettings.jsonのパースに失敗 | エラーメッセージを表示してfatal終了 |
| - | headersディレクトリ未発見 | 出力先ディレクトリが存在しない | エラーメッセージを表示してfatal終了 |
| - | ccコマンドエラー | コンパイルに失敗 | stderrを出力して継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

SDK検出失敗の場合は--sysrootオプションで明示的にパスを指定する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千のヘッダーファイル |
| 目標処理時間 | 数分（ccコンパイル時間に依存） |
| メモリ使用量上限 | ccコンパイラに依存 |

## 排他制御

本バッチは単一プロセスでの実行を想定しており、排他制御は不要。出力ディレクトリは処理前に削除される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | SDK検出時 | SDKバージョンとコードネーム |
| エラーログ | ccコマンドエラー時 | stderr出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | 手動実行のため監視対象外 |

## 備考

- サポートするmacOSバージョン:
  - Catalina (10.x)
  - Big Sur (11.x)
  - Monterey (12.x)
  - Ventura (13.x)
  - Sonoma (14.x)
  - Sequoia (15.x)
  - Tahoe (26.x)
- サポートするアーキテクチャ: aarch64 (arm64), x86_64
- 出力ディレクトリ形式: {arch}-macos.{version}-none
- 依存ファイル生成にcc -MD -MV -MFオプションを使用
- /usr/includeからのヘッダーのみをコピー対象とする
- clangディレクトリのヘッダーは除外
