# バッチ設計書 16-gen_macos_headers_c

## 概要

本ドキュメントは、macOSヘッダーディレクトリからCファイルを生成するバッチ処理の設計を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：ZigはmacOS向けのクロスコンパイルをサポートしており、macOSのシステムヘッダーを使用する必要がある。fetch_them_macos_headersバッチで収集したヘッダーファイルの依存関係を明確にするため、すべてのヘッダーをインクルードするCソースファイルを生成する必要がある。本バッチは、指定されたディレクトリ内のすべての.hファイルを再帰的に探索し、#include文を含むCファイルを標準出力に生成する。

**バッチの実行タイミング**：macOSヘッダーの更新時、またはfetch_them_macos_headersバッチの前処理として実行される。

**主要な処理内容**：
1. コマンドライン引数からディレクトリパスを取得
2. 指定ディレクトリを再帰的に走査
3. .h拡張子を持つファイルパスを収集
4. パスをアルファベット順にソート
5. #include文を含むCファイルを標準出力に生成

**前後の処理との関連**：本バッチの出力はmacos-headers.cとして保存され、fetch_them_macos_headersバッチの入力として使用される。

**影響範囲**：macOSヘッダー処理パイプライン全体に影響。

## バッチ種別

ヘッダー処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（macOSヘッダー更新時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ヘッダーディレクトリ | macOSヘッダーが格納されたディレクトリが存在すること |
| Zig実行環境 | `zig run`コマンドが実行可能な環境であること |

### 実行可否判定

位置引数としてディレクトリパスが1つ指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| dir | string | Yes | なし | ヘッダーファイルが格納されたディレクトリ |
| -h, --help | flag | No | なし | ヘルプメッセージを表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| {dir}/**/*.h | ヘッダーファイル | 再帰的に探索されるヘッダーファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| stdout | Cソースコード | #include文を含むCファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 標準出力（リダイレクトでファイルに保存） |
| 出力先 | stdout |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   ├─ --helpオプションでヘルプ表示
   └─ 位置引数からディレクトリパスを取得

2. ディレクトリの再帰的走査
   ├─ 指定ディレクトリをオープン
   ├─ findHeaders関数で再帰的に探索
   └─ .h拡張子のファイルパスを収集

3. パスのソート
   └─ アルファベット順にソート

4. Cファイルの生成
   ├─ _XOPEN_SOURCEマクロ定義を出力
   ├─ 各パスの#include文を出力
   └─ 空のmain関数を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{--help指定?}
    C -->|Yes| D[ヘルプ表示]
    D --> E[終了]
    C -->|No| F{位置引数=1?}
    F -->|No| G[エラー終了]
    F -->|Yes| H[ディレクトリオープン]
    H --> I[findHeaders呼び出し]
    I --> J[パスリスト収集]
    J --> K[アルファベット順ソート]
    K --> L[#define出力]
    L --> M[#include文ループ]
    M --> N[main関数出力]
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数なし | 位置引数が指定されていない | fatal終了 |
| - | 引数過多 | 位置引数が2つ以上 | fatal終了 |
| - | ディレクトリエラー | ディレクトリのオープンに失敗 | fatal終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ディレクトリパスを確認し、正しいパスを指定して再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千のヘッダーファイル |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | パスリストサイズに依存 |

## 排他制御

本バッチは単一プロセスでの実行を想定しており、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | --help時 | 使用方法 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | 手動実行のため監視対象外 |

## 備考

- 使用例: `zig run tools/gen_macos_headers_c.zig -- /path/to/headers > macos-headers.c`
- 出力されるCファイルの構造:
  ```c
  #define _XOPEN_SOURCE
  #include <header1.h>
  #include <header2.h>
  ...
  int main(int argc, char **argv) {
      return 0;
  }
  ```
- ファイルパスはアルファベット順にソートされる
- シンボリックリンクも.file、.sym_linkとして処理対象
- ディレクトリは再帰的に探索される
- 出力バッファは2000バイト

