# バッチ設計書 17-docgen

## 概要

本ドキュメントは、docgenテンプレートからHTMLドキュメントを生成するバッチ処理の設計を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：Zig言語の公式ドキュメント（言語リファレンス等）は、独自のテンプレート形式で記述されている。本バッチは、このテンプレートを解析し、目次生成、シンタックスハイライト、コード例の埋め込み等を行いながら、最終的なHTMLドキュメントを生成する。

**バッチの実行タイミング**：ドキュメントのビルド時、CIパイプラインでのドキュメント生成時に実行される。

**主要な処理内容**：
1. コマンドライン引数から入力ファイル、出力ファイル、コードディレクトリを取得
2. 入力ファイルをTokenizerで解析し、タグを抽出
3. genToc関数で目次（TOC）を生成
4. genHtml関数でHTMLドキュメントを生成
5. コード例をcode-dirから読み込んで埋め込み

**前後の処理との関連**：doctestバッチでコード例が事前にコンパイル・実行され、その出力がcode-dirに保存されている必要がある。

**影響範囲**：Zigの公式HTMLドキュメント全体に影響。

## バッチ種別

ドキュメント生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ドキュメントビルド時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動/CI |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力ファイル | docgenテンプレートファイルが存在すること |
| code-dir | doctestで生成されたコード例出力が存在すること |
| Zig実行環境 | `zig run`コマンドが実行可能な環境であること |

### 実行可否判定

入力ファイル、出力ファイル、--code-dirオプションがすべて指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| input | string | Yes | なし | docgenテンプレートファイルパス |
| output | string | Yes | なし | 出力HTMLファイルパス |
| --code-dir | string | Yes | なし | コード例出力ディレクトリ |
| -h, --help | flag | No | なし | ヘルプメッセージを表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テンプレートファイル | テキスト | {#tag#}形式のマークアップを含むテンプレート |
| code-dir/*.out | テキスト | doctestで生成されたコード例出力 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| output | HTML | 生成されたHTMLドキュメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | outputで指定されたファイル名 |
| 出力先 | outputで指定されたパス |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   ├─ input、output、--code-dirの取得
   └─ --helpでヘルプ表示

2. ファイルの読み込み
   ├─ 入力ファイルを読み込み（最大10MB）
   └─ Tokenizerを初期化

3. TOC生成（genToc関数）
   ├─ header_open/header_closeタグでセクション構造を解析
   ├─ urlize関数でURL生成
   └─ 重複URL検出

4. HTML生成（genHtml関数）
   ├─ Contentノードをそのまま出力
   ├─ Navノードで目次を挿入
   ├─ HeaderOpenノードでセクションヘッダー生成
   ├─ Codeノードでcode-dirから出力を読み込み
   ├─ SyntaxBlockノードでシンタックスハイライト
   └─ その他タグの処理

5. 出力ファイルへの書き込み
   └─ 生成したHTMLを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{引数は有効?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[入力ファイル読み込み]
    E --> F[Tokenizer初期化]
    F --> G[genToc呼び出し]
    G --> H[TOC生成]
    H --> I[genHtml呼び出し]
    I --> J{タグ種別}
    J -->|Content| K[そのまま出力]
    J -->|Nav| L[TOC挿入]
    J -->|HeaderOpen| M[セクションヘッダー]
    J -->|Code| N[code-dir読み込み]
    J -->|SyntaxBlock| O[シンタックスハイライト]
    K --> P{次のノード?}
    L --> P
    M --> P
    N --> P
    O --> P
    P -->|Yes| J
    P -->|No| Q[出力ファイル書き込み]
    Q --> R[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数不足 | 必須引数が未指定 | fatal終了 |
| - | パースエラー | テンプレート形式が不正 | parseError関数でエラー位置を表示 |
| - | 重複URL | header_openで同じURLが複数定義 | 両方の位置を表示してエラー |
| - | URL未発見 | linkタグで参照先URLが存在しない | エラー終了 |
| - | ファイルエラー | code-dirから読み込み失敗 | ファイル名とエラーを表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

parseError関数によるエラー位置の表示で、問題箇所を特定して修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 単一のドキュメントファイル |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 10MB（max_doc_file_size） |

## 排他制御

本バッチは単一プロセスでの実行を想定しており、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | パースエラー時 | ファイル名、行番号、列番号、エラー内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | CI実行時のエラー検出 |

## 備考

- サポートするタグ一覧:
  - `{#nav#}` - 目次を挿入
  - `{#builtin#}` - @import("builtin")の内容を埋め込み
  - `{#header_open|タイトル#}` - セクション開始
  - `{#header_close#}` - セクション終了
  - `{#see_also|リンク1|リンク2|...#}` - 関連リンク
  - `{#code|ファイル名#}` - コード例出力を埋め込み
  - `{#link|名前#}` または `{#link|名前|URLテキスト#}` - ページ内リンク
  - `{#syntax#}...{#endsyntax#}` - インラインZigコード
  - `{#shell_samp#}...{#end_shell_samp#}` - シェルサンプル
  - `{#syntax_block|言語|名前#}...{#end_syntax_block#}` - コードブロック
- 対応言語: zig, c, peg, javascript
- 2列レイアウト: `{#header_open|タイトル|2col#}`
- 最大ファイルサイズ: 10MB

