# バッチ設計書 18-doctest

## 概要

本ドキュメントは、ドキュメント内のコード例をコンパイル・実行し、出力をHTMLにレンダリングするバッチ処理の設計を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：Zig言語のドキュメントには多数のコード例が含まれており、これらが正しくコンパイル・実行できることを保証する必要がある。本バッチは、コード例を実際にZigコンパイラでビルドし、実行結果やコンパイルエラーをキャプチャして、HTMLドキュメントに埋め込める形式で出力する。

**バッチの実行タイミング**：ドキュメントのビルド時、docgenバッチの前処理として実行される。

**主要な処理内容**：
1. コマンドライン引数から入力ファイル、出力ファイル、Zigコンパイラパス等を取得
2. 入力ファイルのマニフェストコメントを解析してビルド設定を取得
3. Zigコンパイラでコード例をビルド（build-exe, build-obj, build-lib, test）
4. 実行可能なターゲットの場合は実行して出力をキャプチャ
5. ANSIカラーコードをHTMLクラスに変換
6. HTML形式で出力ファイルに書き込み

**前後の処理との関連**：本バッチの出力はdocgenバッチのcode-dirに配置され、最終的なHTMLドキュメントに埋め込まれる。

**影響範囲**：Zigドキュメントのコード例表示全体に影響。

## バッチ種別

ドキュメント生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ドキュメントビルド時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動/CI |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Zigコンパイラ | --zigで指定されたZigコンパイラが利用可能であること |
| 入力ファイル | マニフェストコメントを含むZigソースファイル |
| キャッシュディレクトリ | --cache-rootで指定されたディレクトリが存在すること |

### 実行可否判定

-i、-o、--zig、--cache-rootオプションがすべて指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -i | string | Yes | なし | 入力Zigソースファイル |
| -o | string | Yes | なし | 出力HTMLファイル |
| --zig | string | Yes | なし | Zigコンパイラのパス |
| --zig-lib-dir | string | No | なし | Zigライブラリディレクトリ |
| --cache-root | string | Yes | なし | キャッシュルートディレクトリ |
| -h, --help | flag | No | なし | ヘルプメッセージを表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 入力ファイル | Zigソース | マニフェストコメントを含むZigコード |

#### マニフェストコメント形式

ソースファイルの末尾に以下の形式でマニフェストを記述:

```zig
// test
// optimize=ReleaseFast
// target=x86_64-linux
// link_libc
```

| キー | 説明 |
|-----|------|
| test, exe, obj, lib, syntax | ビルド種別 |
| test_error=MSG | 期待されるテストエラー |
| test_safety=MSG | 期待される安全性エラー |
| exe=succeed/fail/build_fail | 実行結果の期待値 |
| obj=MSG | 期待されるオブジェクトビルドエラー |
| optimize=MODE | 最適化モード（Debug/ReleaseSafe/ReleaseFast/ReleaseSmall） |
| link_mode=static/dynamic | リンクモード |
| link_object=FILE | リンクするオブジェクトファイル |
| target=TRIPLE | ターゲットトリプル |
| llvm=true/false | LLVMバックエンドの使用 |
| link_libc | libcをリンク |
| disable_cache | キャッシュを無効化 |
| verbose_cimport | C importの詳細出力 |
| additional_option=OPT | 追加のコンパイラオプション |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| output | HTML | シンタックスハイライト付きHTML |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | -oで指定されたファイル名 |
| 出力先 | -oで指定されたパス |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ -i, -o, --zig, --cache-root等の取得

2. 入力ファイルの読み込み
   └─ マニフェストコメントの解析（parseManifest関数）

3. 一時ディレクトリの作成
   └─ {cache-root}/tmp/{random}形式

4. Zigコンパイラの実行（printOutput関数）
   ├─ exe: zig build-exe
   ├─ obj: zig build-obj
   ├─ lib: zig build-lib
   └─ test: zig test

5. 実行結果の処理
   ├─ 成功時: 実行して出力をキャプチャ
   └─ 失敗時: コンパイルエラーをキャプチャ

6. HTML出力の生成
   ├─ ソースコードのシンタックスハイライト
   ├─ ANSIカラーコードのHTML変換（termColor関数）
   └─ シェル出力の整形（printShell関数）

7. 一時ディレクトリの削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[入力ファイル読み込み]
    C --> D[マニフェスト解析]
    D --> E[一時ディレクトリ作成]
    E --> F{ビルド種別}
    F -->|exe| G[zig build-exe]
    F -->|obj| H[zig build-obj]
    F -->|lib| I[zig build-lib]
    F -->|test| J[zig test]
    G --> K{ビルド成功?}
    H --> K
    I --> K
    J --> K
    K -->|Yes| L{実行可能?}
    K -->|No| M[エラー出力キャプチャ]
    L -->|Yes| N[実行・出力キャプチャ]
    L -->|No| O[スキップ]
    M --> P[ANSIカラー変換]
    N --> P
    O --> P
    P --> Q[シンタックスハイライト]
    Q --> R[HTML出力]
    R --> S[一時ディレクトリ削除]
    S --> T[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数不足 | 必須引数が未指定 | fatal終了 |
| - | マニフェストエラー | マニフェスト形式が不正 | fatal終了 |
| - | ビルドエラー | 予期しないコンパイルエラー | コマンドと出力を表示 |
| - | 実行エラー | 予期しない実行時エラー | コマンドと出力を表示 |
| - | シンタックスエラー | コードにシンタックスエラー | parseError表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

一時ディレクトリを保持して手動でデバッグする。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | コード例ごとに1回実行 |
| 目標処理時間 | コンパイル・実行時間に依存 |
| メモリ使用量上限 | 10MB（max_doc_file_size） |

## 排他制御

各実行はランダムな一時ディレクトリを使用するため、並列実行が可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | ビルド/実行エラー時 | stderr出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | CI実行時のエラー検出 |

## 備考

- CLICOLOR_FORCE=1環境変数でカラー出力を強制
- サポートするSGRカラーコード: 31(赤), 32(緑), 36(シアン), 0(リセット), 1(太字), 2(薄)
- HTMLクラス: sgr-31_1m, sgr-32_1m, sgr-36_1m, sgr-1m, sgr-2m
- シンタックスハイライトクラス: tok-kw, tok-str, tok-builtin, tok-comment, tok-null, tok-fn, tok-type, tok-number
- wasm32, riscv64-linux等のターゲットは実行をスキップ
- getExternalExecutorでクロスコンパイル判定を行い、実行可否を決定

