# バッチ設計書 19-migrate_langref

## 概要

本ドキュメントは、言語リファレンスドキュメントを新しい形式にマイグレーションするバッチ処理の設計を記載する。

### 本バッチの処理概要

**業務上の目的・背景**：Zigの言語リファレンスドキュメントは、従来の形式から新しいマニフェストベースの形式に移行する必要がある。本バッチは、旧形式のcode_beginタグを含むドキュメントを解析し、各コード例を独立した.zigファイルとして抽出するとともに、新しい{#code|ファイル名#}形式に変換する。

**バッチの実行タイミング**：ドキュメント形式の移行時に一度だけ実行される。

**主要な処理内容**：
1. コマンドライン引数から入力・出力ファイルパスを取得
2. 入力ファイルをTokenizerで解析
3. code_beginタグを検出し、コード内容を抽出
4. 各コード例を独立した.zigファイルとして出力ディレクトリに保存
5. マニフェストコメント形式でビルド設定を追加
6. 新形式のテンプレートを出力ファイルに書き込み

**前後の処理との関連**：本バッチの出力は、doctestバッチで処理される.zigファイルと、docgenバッチで処理されるテンプレートファイルになる。

**影響範囲**：言語リファレンスドキュメントの形式変換に影響。

## バッチ種別

ドキュメント変換

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 一度（移行時のみ） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力ファイル | 旧形式のdocgenテンプレートが存在すること |
| 出力ディレクトリ | 出力ファイルの親ディレクトリが存在すること |
| Zig実行環境 | `zig run`コマンドが実行可能な環境であること |

### 実行可否判定

入力ファイルパスと出力ファイルパスが位置引数として指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| input | string | Yes | なし | 入力テンプレートファイルパス |
| output | string | Yes | なし | 出力テンプレートファイルパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 入力ファイル | テキスト | code_begin形式のタグを含む旧形式テンプレート |

#### 旧形式タグ

| タグ | 説明 |
|-----|------|
| `{#code_begin|種別|名前#}` | コードブロック開始 |
| `{#code_end#}` | コードブロック終了 |
| `{#code_release_fast#}` | ReleaseFast最適化 |
| `{#code_release_safe#}` | ReleaseSafe最適化 |
| `{#code_disable_cache#}` | キャッシュ無効化 |
| `{#code_verbose_cimport#}` | C importの詳細出力 |
| `{#code_link_object|file#}` | リンクオブジェクト |
| `{#target_windows#}` | Windowsターゲット |
| `{#target_linux_x86_64#}` | Linux x86_64ターゲット |
| `{#target_linux_riscv64#}` | Linux RISC-V64ターゲット |
| `{#target_wasm#}` | WASM freestandingターゲット |
| `{#target_wasi#}` | WASIターゲット |
| `{#link_libc#}` | libcリンク |
| `{#link_mode_dynamic#}` | 動的リンク |
| `{#additonal_option|opt#}` | 追加オプション |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| output | テキスト | 新形式のテンプレートファイル |
| output_dir/*.zig | Zigソース | マニフェストコメント付きコード例 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {name}.zig（コード例ごと） |
| 出力先 | outputファイルの親ディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

#### 新形式タグ

入力の`{#code_begin|種別|名前#}...{#code_end#}`が以下に変換される:

```
{#code|名前.zig#}
```

#### マニフェストコメント形式

抽出された.zigファイルには以下の形式でマニフェストが追加される:

```zig
// コード本体

// test
// optimize=ReleaseFast
// target=x86_64-linux
```

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ 入力ファイル、出力ファイルの取得

2. ファイルの読み込み
   ├─ 入力ファイルを読み込み
   └─ Tokenizerを初期化

3. 走査と変換（walk関数）
   ├─ Contentトークンはそのまま出力
   ├─ code_beginタグを検出
   │   ├─ 種別（exe, test, obj, lib, syntax）を解析
   │   ├─ オプションタグを収集
   │   ├─ code_endまでの内容を抽出
   │   └─ .zigファイルとして出力
   └─ その他のタグはそのまま出力

4. マニフェストの生成
   ├─ ビルド種別（test, exe, obj, lib, syntax）
   ├─ 最適化モード
   ├─ ターゲット
   ├─ リンク設定
   └─ 追加オプション

5. 出力ファイルへの書き込み
   └─ {#code|名前.zig#}形式のタグに置換
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[入力ファイル読み込み]
    C --> D[Tokenizer初期化]
    D --> E[出力ディレクトリオープン]
    E --> F[walk関数呼び出し]
    F --> G{トークン種別}
    G -->|Content| H[そのまま出力]
    G -->|bracket_open| I[タグ名解析]
    I --> J{code_begin?}
    J -->|Yes| K[コード種別解析]
    K --> L[オプションタグ収集]
    L --> M[code_endまで読み取り]
    M --> N[.zigファイル作成]
    N --> O[マニフェスト追記]
    O --> P[{#code|名前.zig#}出力]
    J -->|No| Q[タグをそのまま出力]
    H --> R{次のトークン?}
    P --> R
    Q --> R
    R -->|Yes| G
    R -->|No| S[出力ファイル書き込み]
    S --> T[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数不足 | 入力・出力が未指定 | fatal終了 |
| - | パースエラー | タグ形式が不正 | parseError関数でエラー位置を表示 |
| - | 不明なコード種別 | 未知のcode種別 | parseError表示 |
| - | ファイル作成エラー | .zigファイルが作成できない | fatal終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

parseError関数によるエラー位置の表示で、問題箇所を特定して修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 単一のドキュメントファイル |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 入力ファイルサイズに依存 |

## 排他制御

本バッチは単一プロセスでの実行を想定しており、排他制御は不要。出力ディレクトリに同名ファイルが存在する場合はexclusive: trueでエラーになる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | パースエラー時 | ファイル名、行番号、列番号、エラー内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | 手動実行のため監視対象外 |

## 備考

- 使用例: `zig run tools/migrate_langref.zig -- doc/langref.html.in doc/new_langref.html.in`
- サポートするコード種別:
  - exe: 実行可能ファイルをビルド
  - exe_err: 実行時エラーが期待される
  - exe_build_err: ビルドエラーが期待される
  - test: zig test
  - test_err: テストエラーが期待される
  - test_safety: 安全性エラーが期待される
  - obj: オブジェクトファイルをビルド
  - obj_err: オブジェクトビルドエラーが期待される
  - lib: ライブラリをビルド
  - syntax: シンタックスチェックのみ
- ファイル作成はexclusive: trueで既存ファイルとの衝突を防止

