# バッチ設計書 2-update_mingw

## 概要

本ドキュメントは、MinGWのCRTファイルとwinpthreadsライブラリを更新するバッチ処理の設計書です。

### 本バッチの処理概要

**業務上の目的・背景**：Zig言語はWindows環境でのクロスコンパイルをサポートするため、MinGWのCランタイムファイルとwinpthreadsライブラリを同梱しています。MinGWプロジェクトが更新された際に、Zigがバンドルするファイルを最新版に同期する必要があります。このバッチは、MinGW-w64のCRTファイル、定義ファイル（.def/.def.in）、およびwinpthreadsソースを効率的に更新します。

**バッチの実行タイミング**：随時（MinGW-w64の新バージョンリリース時に手動実行）

**主要な処理内容**：
1. mingw-w64-crt配下の既存ファイルをソースからコピー
2. 存在しなくなったファイルの削除（保持対象ファイルを除く）
3. winpthreadsライブラリのソースファイル更新
4. 新規の.defおよび.def.inファイルの追加（ブラックリスト対象を除く）

**前後の処理との関連**：本バッチは独立して実行可能です。更新後はZigのビルドシステムで動作確認が必要です。

**影響範囲**：lib/libc/mingw配下のファイル、Windows向けクロスコンパイル環境

## バッチ種別

データ同期処理（外部ソースからのファイル更新）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動（MinGW-w64リリース時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| MinGWソースディレクトリ | MinGW-w64のソースコードがローカルに展開されていること |
| Zigライブラリディレクトリ | Zigのlibディレクトリが存在すること |
| 書き込み権限 | lib/libc/mingw配下への書き込み権限があること |

### 実行可否判定

コマンドライン引数として、Zigライブラリパスとminimgwソースパスが正しく指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| zig_src_lib_path | string | Yes | なし | Zigのlibディレクトリパス |
| mingw_src_path | string | Yes | なし | MinGW-w64ソースディレクトリのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| mingw-w64-crt | ディレクトリ | MinGWのCRTソースファイル |
| mingw-w64-libraries/winpthreads/src | ディレクトリ | winpthreadsライブラリソース |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| lib/libc/mingw | ファイル群 | 更新されたCRTファイル |
| lib/libc/mingw/winpthreads | ファイル群 | 更新されたwinpthreadsファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 元のファイル名を維持 |
| 出力先 | {zig_src_lib_path}/libc/mingw |
| 文字コード | オリジナルを維持 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ zig_src_lib_path, mingw_src_pathを取得
2. CRTファイルの更新
   └─ mingw-w64-crtから既存ファイルをコピー
   └─ 存在しないファイルは削除（保持対象除く）
3. winpthreadsファイルの更新
   └─ mingw-w64-libraries/winpthreads/srcからコピー
   └─ 存在しないファイルは削除
4. 新規defファイルの追加
   └─ lib32, lib64, libarm32, libarm64, lib-common, def-include配下を走査
   └─ ブラックリスト対象を除外して新規ファイルを追加
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[CRTディレクトリオープン]
    C --> D[既存CRTファイルの走査・コピー]
    D --> E[winpthreadsディレクトリオープン]
    E --> F[既存winpthreadsファイルの走査・コピー]
    F --> G[ソースディレクトリの走査]
    G --> H{対象ディレクトリ?}
    H -->|Yes| I{.def/.def.in?}
    H -->|No| G
    I -->|Yes| J{ブラックリスト?}
    I -->|No| G
    J -->|Yes| G
    J -->|No| K[ファイルコピー]
    K --> G
    G --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | 本バッチはファイル操作のみ |

### テーブル別操作詳細

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FileNotFound | ファイル未発見 | ソースファイルが存在しない | 対象ファイルを削除（保持対象除く） |
| ディレクトリオープンエラー | 致命的エラー | 指定パスが無効 | エラーメッセージ出力後exit(1) |
| コピーエラー | 処理継続 | ファイルコピー失敗 | 警告出力、failフラグを立てる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

failフラグが立った場合、exit(1)で終了。手動でエラー内容を確認し、必要に応じて再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位 |
| コミットタイミング | 各ファイルコピー完了時 |
| ロールバック条件 | 該当なし（ファイル操作のため） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千ファイル |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | 10MB |

## 排他制御

同時実行不可。同じディレクトリに対する複数プロセスからの更新は未サポート。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | ファイル削除時 | 削除対象ファイルパス |
| エラーログ | コピー失敗時 | ファイルパスとエラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- 保持対象ファイル：COPYING、include/config.h、winpthreads/配下
- ブラックリスト対象のdefファイル：crtdll、古いmsvcpバージョン、古いmsvcrバージョン
- _windowsapp.def、_onecore.defで終わるファイルは除外
- 対象ディレクトリ：lib32、lib64、libarm32、libarm64、lib-common、def-include
