# バッチ設計書 23-dump-cov

## 概要

本ドキュメントは、Zigカバレッジファイルを読み取り、人間が読める形式で情報を出力するバッチ処理「dump-cov」の設計書です。

### 本バッチの処理概要

このバッチは、Zigのコードカバレッジ計測で生成されたカバレッジファイルと、対応する実行ファイルを読み込み、各プログラムカウンタ（PC）のソース位置情報（ファイル名、行番号、列番号）を人間が読める形式で標準出力に出力します。カバレッジファイルには実行されたかどうかのビット情報も含まれており、各PCが実行されたかどうかを視覚的に確認できます。

**業務上の目的・背景**：Zigコンパイラのテストカバレッジを分析・可視化するために使用します。ファジングテストやユニットテストの実行後、どのコードパスが実行されたかを確認することで、テストの網羅性を評価できます。カバレッジデータはバイナリ形式で保存されるため、このツールによって人間が読める形式に変換する必要があります。これにより、未テストのコードパスを特定し、テストケースの追加を計画できます。

**バッチの実行タイミング**：手動実行。ファジングテストやカバレッジ計測を行った後に実行します。CI/CDパイプラインでのカバレッジレポート生成にも使用可能です。

**主要な処理内容**：
1. コマンドライン引数から実行ファイルパス、カバレッジファイルパス、（オプションで）ターゲットを取得
2. ターゲット情報を解析（デフォルトはnative）
3. 実行ファイルからデバッグ情報を読み込み
4. カバレッジファイルを読み込み、ヘッダー情報を解析
5. プログラムカウンタ（PC）アドレスのリストを取得
6. PCアドレスをソートし、デバッグ情報からソース位置を解決
7. 各PCについて実行状況（+/-）とソース位置を出力

**前後の処理との関連**：前提として、Zigのファジングテストやカバレッジ計測（`--fuzz`オプション等）を実行し、カバレッジファイルが生成されている必要があります。このバッチの出力は、開発者がテストカバレッジを分析するために使用します。

**影響範囲**：このバッチ自体はファイルシステムを変更しません。カバレッジファイルと実行ファイルを読み取り、標準出力に情報を出力するのみです。

## バッチ種別

デバッグ・分析

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Zigランタイム環境 | Zigコンパイラがインストールされ、`zig run`コマンドが実行可能であること |
| 実行ファイル | カバレッジ計測対象の実行ファイルが存在すること（デバッグ情報付き） |
| カバレッジファイル | ファジングテスト等で生成されたカバレッジファイルが存在すること |

### 実行可否判定

コマンドライン引数として実行ファイルパスとカバレッジファイルパスが指定されている場合に実行します。引数が不足している場合は使用方法を表示してエラー終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| path/to/exe | string | Yes | なし | カバレッジ計測対象の実行ファイルパス |
| path/to/coverage | string | Yes | なし | カバレッジデータファイルパス |
| target | string | No | native | ターゲットトリプル（例: x86_64-linux） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 実行ファイル | ELF/Mach-O等 | デバッグ情報（DWARF）を含む実行ファイル |
| カバレッジファイル | バイナリ | SeenPcsHeader形式のカバレッジデータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | PCごとのソース位置情報と実行状況 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 標準出力 |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | 改行 |

### 出力例

```
SeenPcsHeader{ .format_version = 1, .num_pcs = 1234, ... }
+0x12345678: /path/to/source/file.zig:42:10
-0x12345680: /path/to/source/file.zig:43:5
+0x12345690: /path/to/source/file.zig:45:1
 0x123456a0: invalid
```

- `+`: 実行されたPC
- `-`: 実行されなかったPC
- `invalid`: ソース位置を解決できなかったPC

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ 実行ファイルパス、カバレッジファイルパス、ターゲット（オプション）を取得
2. ターゲット解析
   └─ Target.Query.parseでターゲット情報を解析（デフォルト: native）
3. デバッグ情報の読み込み
   └─ std.debug.Info.loadで実行ファイルからDWARF情報を取得
4. カバレッジファイルの読み込み
   └─ SeenPcsHeader形式でカバレッジデータを解析
5. ヘッダー情報の出力
   └─ カバレッジファイルのヘッダー情報を表示
6. PCアドレスのインデックス化
   └─ AutoArrayHashMapでPCアドレスをインデックス化
7. PCアドレスのソート
   └─ アドレス順にソートして出力順序を決定
8. ソース位置の解決
   └─ debug_info.resolveAddressesでPCからソース位置を取得
9. 各PCの情報出力
   └─ 実行状況（+/-）、PCアドレス、ファイル:行:列を出力
10. 出力のフラッシュ
    └─ バッファリングされた出力を確定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|不足| C[使用方法表示]
    C --> D[エラー終了]
    B -->|OK| E[ターゲット解析]
    E --> F[デバッグ情報読み込み]
    F --> G{読み込み成功?}
    G -->|No| H[エラー出力]
    H --> D
    G -->|Yes| I[カバレッジファイル読み込み]
    I --> J{読み込み成功?}
    J -->|No| K[エラー出力]
    K --> D
    J -->|Yes| L[ヘッダー出力]
    L --> M[PCアドレスをソート]
    M --> N[ソース位置を解決]
    N --> O[各PCの情報出力]
    O --> P[出力フラッシュ]
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| fatal | 引数エラー | コマンドライン引数が不足 | 正しい引数を指定して再実行 |
| fatal | デバッグ情報読み込みエラー | 実行ファイルが存在しない/デバッグ情報なし | デバッグ情報付きでビルドし直す |
| fatal | カバレッジファイル読み込みエラー | カバレッジファイルが存在しない/形式不正 | カバレッジ計測を再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

デバッグ情報読み込みエラーの場合は、実行ファイルがデバッグシンボル付きでビルドされているか確認してください。カバレッジファイル読み込みエラーの場合は、ファジングテストやカバレッジ計測を再実行してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千〜数万PC |
| 目標処理時間 | 10秒以内（標準的なケース） |
| メモリ使用量上限 | 1GB（カバレッジファイル最大サイズ） + 4KB（出力バッファ） |

## 排他制御

同時実行可能。読み取り専用の処理のため、排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 引数不足時 | 使用方法の表示 |
| エラーログ | ファイル読み込み失敗時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- 使用例: `zig run tools/dump-cov.zig -- zig-out/test .zig-cache/v/xxxxxxxx`
- クロスプラットフォーム分析の場合: `zig run tools/dump-cov.zig -- path/to/exe path/to/coverage x86_64-linux`
- SeenPcsHeader形式はZigのファジングABIで定義されています（std.Build.abi.fuzz.SeenPcsHeader）
- 出力の+/-マークで、どのコードパスが実行されたかを一目で確認できます
- デバッグ情報（DWARF）が必要なため、リリースビルドでは正確なソース位置が取得できない場合があります
