# バッチ設計書 6-update_cpu_features

## 概要

本ドキュメントは、LLVMからCPU機能定義を抽出し、Zigのターゲットアーキテクチャ用コードを自動生成するバッチ処理の設計書です。

### 本バッチの処理概要

**業務上の目的・背景**：Zigコンパイラは多数のCPUアーキテクチャをサポートしており、各アーキテクチャのCPU機能（features）やCPUモデル定義が必要です。これらの情報はLLVMのTableGen定義ファイルに含まれており、手動で同期することは非現実的です。このバッチは、LLVMのTableGenファイルからCPU機能定義を自動抽出し、Zigの標準ライブラリ用のZigコードを生成します。

**バッチの実行タイミング**：随時（LLVMの新バージョンに追従する際に手動実行）

**主要な処理内容**：
1. llvm-tblgenを実行してJSON形式でCPU情報を取得
2. JSONをパースしてSubtargetFeatureとProcessor情報を抽出
3. 各アーキテクチャ固有のオーバーライド設定を適用
4. 追加のCPUと機能を設定から追加
5. lib/std/Target/{arch}.zigファイルを生成

**前後の処理との関連**：本バッチは独立して実行可能です。生成されたファイルはZigのビルドシステムで使用されます。

**影響範囲**：lib/std/Target/配下のアーキテクチャ別ファイル、クロスコンパイル時のCPU機能検出

## バッチ種別

コード生成処理（外部ソースからのコード自動生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動（LLVMバージョン更新時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| llvm-tblgen | LLVMのTableGen実行ファイルが利用可能であること |
| LLVMソースツリー | LLVMのソースコードがローカルに展開されていること |
| Zigソースツリー | Zigのソースツリーが存在すること |
| 書き込み権限 | lib/std/Target/配下への書き込み権限があること |

### 実行可否判定

コマンドライン引数として、llvm-tblgenパス、LLVMソースパス、Zigソースパスが正しく指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| llvm_tblgen_exe | string | Yes | なし | llvm-tblgen実行ファイルのパス |
| llvm_src_root | string | Yes | なし | LLVMソースディレクトリのパス |
| zig_src_root | string | Yes | なし | Zigソースディレクトリのパス |
| filter | string | No | なし | 特定アーキテクチャのみ処理する場合のフィルタ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| {LLVM}/lib/Target/{Arch}/{Arch}.td | TableGen | LLVMのターゲット定義ファイル |
| targets配列（内部定義） | 構造体 | アーキテクチャ別のオーバーライド設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| lib/std/Target/{arch}.zig | Zigソースファイル | 各アーキテクチャのCPU機能定義 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {arch}.zig（aarch64.zig, x86.zig等） |
| 出力先 | {zig_src_root}/lib/std/Target/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ llvm_tblgen_exe, llvm_src_root, zig_src_root, [filter]を取得
2. アーキテクチャ別の並列処理
   └─ 各ターゲットについて以下を実行
3. llvm-tblgen実行
   └─ --dump-jsonオプションでJSON出力を取得
4. JSON解析
   └─ SubtargetFeatureとProcessorを抽出
5. オーバーライド適用
   └─ omit、flatten、zig_name変換等を適用
6. 追加定義のマージ
   └─ extra_features、extra_cpusを追加
7. ソート
   └─ 機能名、CPU名でソート
8. Zigコード生成
   └─ lib/std/Target/{arch}.zigを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[各アーキテクチャを並列処理]
    C --> D{LLVMターゲット?}
    D -->|Yes| E[llvm-tblgen実行]
    D -->|No| F[手動定義を使用]
    E --> G[JSON解析]
    G --> H[オーバーライド適用]
    F --> H
    H --> I[追加定義マージ]
    I --> J[ソート処理]
    J --> K[Zigコード生成]
    K --> L[ファイル出力]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | 本バッチはファイル操作のみ |

### テーブル別操作詳細

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| llvm-tblgen終了コード | 致命的エラー | llvm-tblgenがエラー終了 | stderrを出力してexit(1) |
| JSONパースエラー | 致命的エラー | JSON形式が不正 | 診断情報を出力してexit(1) |
| 機能未発見 | パニック | 参照機能がテーブルに存在しない | putDep関数でアサート失敗 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

エラーメッセージを確認し、LLVMソースパスやllvm-tblgenパスを見直す。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位 |
| コミットタイミング | 各アーキテクチャファイル出力完了時 |
| ロールバック条件 | 該当なし（ファイル操作のため） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約30アーキテクチャ |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | 500MB（llvm-tblgenのJSON出力が大きいため） |

## 排他制御

同時実行不可。同じ出力ディレクトリに対する複数プロセスからの更新は未サポート。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗表示 | 各アーキテクチャ処理時 | Progress.Node表示 |
| エラーログ | llvm-tblgen失敗時 | stderrの内容 |
| 情報ログ | 無視された命令セット | 対象外Extension名 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- 対応アーキテクチャ：aarch64, alpha, amdgcn, arc, arm, avr, bpf, csky, hexagon, hppa, kvx, lanai, loongarch, m68k, msp430, mips, nvptx, powerpc, propeller, spirv, riscv, sparc, s390x, ve, wasm, x86, xcore, xtensa
- 一部のアーキテクチャ（alpha, hppa, kvx, propeller）はLLVMターゲットがなく、手動定義を使用
- branch_quotaが設定されているアーキテクチャ：aarch64(2000), amdgcn(2000), arm(10000), spirv(2000), riscv(2000)
- feature_overridesでomit、flatten、zig_name変換等の調整が可能
- シングルスレッドでのビルド時は-fsingle-threadedオプションを使用
