# バッチ設計書 7-update_crc_catalog

## 概要

本ドキュメントは、CRCカタログからlib/std/hash/crc.zigを自動生成するバッチ処理の設計書です。

### 本バッチの処理概要

**業務上の目的・背景**：Zigの標準ライブラリには、様々なCRCアルゴリズムの実装が含まれています。CRCアルゴリズムは多数のバリエーションがあり、それぞれ異なるパラメータ（多項式、初期値、反転設定等）を持ちます。これらのパラメータを手動で管理することは困難であり、誤りが生じやすいため、標準的なCRCカタログからZigコードを自動生成することで、正確性と保守性を向上させます。

**バッチの実行タイミング**：随時（CRCカタログの更新時、または新しいCRCアルゴリズムの追加時に手動実行）

**主要な処理内容**：
1. 埋め込みcatalog.txtファイルの読み込み・解析
2. 各CRCアルゴリズムのパラメータ（width, poly, init, refin, refout, xorout, check, residue, name）を抽出
3. スネークケースからキャメルケースへの名前変換
4. crc.zigファイルへのCRC型定義の出力
5. test.zigファイルへのテストコード出力

**前後の処理との関連**：本バッチは独立して実行可能です。生成されたファイルはZigの標準ライブラリの一部として使用されます。

**影響範囲**：lib/std/hash/crc.zig、lib/std/hash/crc/test.zig

## バッチ種別

コード生成処理（カタログデータからのコード自動生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動（CRCカタログ更新時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Zigソースツリー | Zigのソースツリーが存在すること |
| 書き込み権限 | lib/std/hash/配下への書き込み権限があること |
| catalog.txt | tools/crc/catalog.txtが存在すること（埋め込み） |

### 実行可否判定

コマンドライン引数として、Zigソースルートパスが正しく指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| zig_src_root | string | Yes | なし | Zigソースディレクトリのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tools/crc/catalog.txt | テキスト | CRCアルゴリズムのカタログ（@embedFile） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| lib/std/hash/crc.zig | Zigソースファイル | CRC型定義 |
| lib/std/hash/crc/test.zig | Zigソースファイル | テストコード |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | crc.zig, test.zig |
| 出力先 | {zig_src_root}/lib/std/hash/, {zig_src_root}/lib/std/hash/crc/ |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ zig_src_rootを取得
2. ディレクトリ作成
   └─ lib/std/hash, lib/std/hash/crcを作成（存在しない場合）
3. 出力ファイル作成
   └─ crc.zig, test.zigを作成
4. ヘッダー出力
   └─ 自動生成コメント、インポート文を出力
5. catalog.txt解析
   └─ 各行からwidth, poly, init, refin, refout, xorout, check, residue, nameを抽出
6. 名前変換
   └─ スネークケース→キャメルケース
7. CRC型定義出力
   └─ pub const {Name} = Crc(u{width}, .{...});
8. テストコード出力
   └─ test "{name}" {{ ... }}
9. ファイルフラッシュ
   └─ バッファをフラッシュして出力完了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[ディレクトリ作成]
    C --> D[出力ファイル作成]
    D --> E[ヘッダー出力]
    E --> F[catalog.txt読み込み]
    F --> G{次の行?}
    G -->|Yes| H{空行orコメント?}
    H -->|Yes| G
    H -->|No| I[パラメータ抽出]
    I --> J[名前変換]
    J --> K[CRC型定義出力]
    K --> L[テストコード出力]
    L --> G
    G -->|No| M[ファイルフラッシュ]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | 本バッチはファイル操作のみ |

### テーブル別操作詳細

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 引数不足 | 致命的エラー | zig_src_rootが指定されていない | 使用方法を表示してexit(1) |
| ディレクトリオープンエラー | 致命的エラー | 指定パスが無効 | エラーメッセージ出力後exit(2) |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

エラーメッセージを確認し、Zigソースパスを見直す。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位 |
| コミットタイミング | flush()呼び出し時 |
| ロールバック条件 | 該当なし（ファイル操作のため） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約100種類のCRCアルゴリズム |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 10MB |

## 排他制御

同時実行不可。同じ出力ファイルに対する複数プロセスからの更新は未サポート。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | - |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- catalog.txtは@embedFileで埋め込まれている
- catalog.txtの形式: `key=value  key=value  ...`（2スペース区切り）
- 対応キー: width, poly, init, refin, refout, xorout, check, residue, name
- nameは引用符で囲まれている（"CRC-32/ISO-HDLC"のような形式）
- デフォルトCRC32はCrc32IsoHdlc
- テストはチェック値"123456789"に対するハッシュ値を検証
