# バッチ設計書 8-gen_spirv_spec

## 概要

本ドキュメントは、SPIR-V仕様からZigコードを自動生成するバッチ処理の設計書です。

### 本バッチの処理概要

**業務上の目的・背景**：SPIR-V（Standard Portable Intermediate Representation for Vulkan）は、GPUコンピューティングやグラフィックスシェーダーの中間表現です。Zigコンパイラは、SPIR-Vバックエンドをサポートしており、SPIR-V仕様に準拠したオペコード、オペランド種別、命令定義等が必要です。SPIR-V仕様はKhronosグループによって定期的に更新されるため、手動でのコード同期は現実的ではありません。このバッチは、SPIR-Vレジストリの公式grammar.jsonからZigバインディングを自動生成します。

**バッチの実行タイミング**：随時（SPIR-V仕様の新バージョンリリース時に手動実行）

**主要な処理内容**：
1. SPIR-V仕様のgrammar.jsonファイル群の読み込み・解析
2. コア仕様と拡張仕様（OpenCL.std、GLSL.std.450等）の処理
3. オペコード、オペランド種別、列挙型の生成
4. 命令セット定義の生成
5. 生成コードのフォーマットと検証

**前後の処理との関連**：本バッチは独立して実行可能です。生成されたファイルはZigのSPIR-Vコードジェネレータで使用されます。

**影響範囲**：src/codegen/spirv/配下のファイル

## バッチ種別

コード生成処理（仕様JSONからのコード自動生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動（SPIR-V仕様更新時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPIRV-Headersリポジトリ | KhronosのSPIRV-Headersがローカルにクローンされていること |
| Zig拡張仕様ファイル | extinst.zig.grammar.jsonが存在すること |

### 実行可否判定

コマンドライン引数として、SPIRV-Headersパスと拡張仕様ファイルパスが正しく指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| spirv_headers_path | string | Yes | なし | SPIRV-Headersリポジトリのパス |
| extinst_path | string | Yes | なし | extinst.zig.grammar.jsonのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| include/spirv/unified1/spirv.core.grammar.json | JSON | SPIR-Vコア仕様 |
| include/spirv/unified1/extinst.*.grammar.json | JSON | 拡張命令セット仕様 |
| extinst.zig.grammar.json | JSON | Zig固有の拡張仕様 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | Zigソースコード | SPIR-V仕様のZigバインディング |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 標準出力（リダイレクトで保存） |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ spirv_headers_path, extinst_pathを取得
2. コア仕様読み込み
   └─ spirv.core.grammar.jsonを解析
3. 命令ソート
   └─ オペコード順にソート
4. 拡張仕様読み込み
   └─ extinst.*.grammar.jsonファイル群を走査・解析
5. オペランド種別マージ
   └─ コアと拡張のオペランド種別を統合
6. コード生成
   └─ Version, Word, Id, OperandKind, Opcode等を出力
7. フォーマット・検証
   └─ std.zig.Ast.parseで構文解析、エラーチェック
8. 出力
   └─ フォーマット済みコードを標準出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[コア仕様読み込み]
    C --> D[命令ソート]
    D --> E[拡張仕様読み込み]
    E --> F[オペランド種別マージ]
    F --> G[コード生成]
    G --> H[構文解析・検証]
    H --> I{エラー?}
    I -->|Yes| J[エラー出力]
    I -->|No| K[フォーマット出力]
    J --> L[終了]
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | 本バッチはファイル操作のみ |

### テーブル別操作詳細

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 引数不足 | 致命的エラー | 必須引数が指定されていない | 使用方法を表示してexit(1) |
| JSONパースエラー | 致命的エラー | JSON形式が不正 | 行・列情報を出力 |
| 構文エラー | 致命的エラー | 生成コードが不正 | Astエラーを出力 |
| コンパイルエラー | 致命的エラー | 生成コードがZIRエラー | ErrorBundleを出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

エラーメッセージを確認し、入力JSONファイルを見直す。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 処理全体 |
| コミットタイミング | 標準出力への出力時 |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百のオペコード、数十のオペランド種別 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 100MB |

## 排他制御

該当なし（標準出力への出力のため）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 無視された命令セット | 対象外の命令セット名 |
| エラーログ | パースエラー時 | ファイル名、行・列情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- 対応命令セット：OpenCL.std、GLSL.std.450、zig
- set_namesで命令セット名とオペコード型名のマッピングを定義
- 重複オペコード・列挙値はタグ優先度（KHR > EXT > その他）で解決
- 生成コードはstd.zig.Ast.parseとAstGenで検証される
- 出力先はsrc/codegen/spirv/配下（手動でリダイレクト）
- 使用例: `zig run tools/gen_spirv_spec.zig -- /path/to/SPIRV-Headers /path/to/extinst.zig.grammar.json > output.zig`
