# バッチ設計書 9-gen_stubs

## 概要

本ドキュメントは、muslのビルドからlibc.Sスタブファイルを生成するバッチ処理の設計書です。

### 本バッチの処理概要

**業務上の目的・背景**：Zigはmuslベースのlibcをサポートしており、複数のCPUアーキテクチャに対応したスタブファイルが必要です。muslの各アーキテクチャ向けビルドから動的シンボルを抽出し、条件付きアセンブリファイル（libc.S）を生成することで、単一のソースファイルで全アーキテクチャをサポートできます。

**バッチの実行タイミング**：随時（muslの新バージョンに追従する際に手動実行）

**主要な処理内容**：
1. 各アーキテクチャのlibc.soからELFヘッダーを解析
2. 動的シンボルテーブル（.dynsym）からシンボル情報を抽出
3. シンボルのバインディング、型、可視性を解析
4. アーキテクチャ間でシンボル情報を統合
5. プリプロセッサ条件付きのアセンブリファイルを生成

**前後の処理との関連**：本バッチは独立して実行可能です。入力として複数アーキテクチャのmuslビルドが必要です。

**影響範囲**：libc.Sスタブファイル、musl向けクロスコンパイル環境

## バッチ種別

コード生成処理（ELFバイナリからのアセンブリ自動生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | 手動（muslバージョン更新時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| muslビルドディレクトリ | 各アーキテクチャのmuslビルドが存在すること |
| libc.soファイル | 各アーキテクチャの{arch}/lib/libc.soが存在すること |

### 実行可否判定

コマンドライン引数として、ビルドディレクトリパスが正しく指定されていること。各アーキテクチャのサブディレクトリにlibc.soが存在すること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| build_all_path | string | Yes | なし | muslビルドディレクトリのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| {arch}/lib/libc.so | ELFバイナリ | 各アーキテクチャのmusl共有ライブラリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | アセンブリファイル | プリプロセッサ条件付きlibc.S |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 標準出力（リダイレクトで保存） |
| 出力先 | 標準出力 |
| 文字コード | ASCII |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ build_all_pathを取得
2. 各アーキテクチャの処理
   └─ aarch64, arm, i386, hexagon, loongarch64, mips, mips64, mipsn32, powerpc, powerpc64, riscv32, riscv64, s390x, x86_64
3. ELFヘッダー読み込み
   └─ ヘッダーを解析してエンディアン、ビット幅を判定
4. セクションヘッダー走査
   └─ .dynsymセクションを特定
5. シンボル抽出
   └─ バインディング、型、可視性、サイズを取得
6. シンボル統合
   └─ 全アーキテクチャのシンボル情報をマージ
7. ソート
   └─ セクション名、シンボル名でソート
8. アセンブリ生成
   └─ プリプロセッサマクロ付きのシンボル定義を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[アーキテクチャループ]
    C --> D[ELFヘッダー読み込み]
    D --> E[セクションヘッダー走査]
    E --> F[.dynsymセクション特定]
    F --> G[シンボル抽出]
    G --> H[シンボルテーブル更新]
    H --> C
    C --> I[シンボルソート]
    I --> J[プリプロッサマクロ出力]
    J --> K[シンボル定義出力]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | 本バッチはファイル操作のみ |

### テーブル別操作詳細

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ファイル読み込みエラー | 致命的エラー | libc.soが存在しない | パニック、パス情報出力 |
| .dynsym未発見 | パニック | セクションが見つからない | パニック |
| セクション不一致 | 致命的エラー | アーキテクチャ間でセクションが異なる | fatal関数でエラー出力 |
| 型不一致 | 致命的エラー | アーキテクチャ間で型が異なる | fatal関数でエラー出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

エラーメッセージを確認し、muslビルドディレクトリを見直す。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 処理全体 |
| コミットタイミング | 標準出力への出力時 |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 14アーキテクチャ、数千シンボル |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 100MB |

## 排他制御

該当なし（標準出力への出力のため）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | サイズ0のシンボル | シンボル名とアーキテクチャ |
| 情報ログ | バインディング/サイズ不一致 | シンボル名と各アーキテクチャの値 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- 対応アーキテクチャ：aarch64, arm, i386, hexagon, loongarch64, mips, mips64, mipsn32, powerpc, powerpc64, riscv32, riscv64, s390x, x86_64（x32は現在サポート外）
- ビルド時に必要なdefine：-DTIME32（32ビット時間ABI）、-DPTR64（64ビットポインタ）、-DARCH_{arch}、-DFAMILY_{family}
- WEAK64：64ビットアーキテクチャでweak、32ビットでglobal
- WEAKTIME64：time32アーキテクチャでglobal、それ以外でweak
- PTR_SIZE_BYTES：ポインタサイズ（4または8）
- PTR2_SIZE_BYTES：ポインタサイズの2倍（8または16）
- シンボルタイプ：STT_FUNC（関数）、STT_OBJECT（オブジェクト）、STT_NOTYPE
- 可視性：DEFAULT、PROTECTED（INTERNAL、HIDDENはスキップ）
