---
generated_at: 2026-02-01 16:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-gen_outline_atomics.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/gen_outline_atomics.zig` 行5-12（AtomicOp enum定義）
- E-02: `tools/gen_outline_atomics.zig` 行14-62（main関数）
- E-03: `tools/gen_outline_atomics.zig` 行24-38（ヘッダー出力）
- E-04: `tools/gen_outline_atomics.zig` 行43-57（ループ処理）
- E-05: `tools/gen_outline_atomics.zig` 行64-107（writeFunction関数）
- E-06: `tools/gen_outline_atomics.zig` 行109-158（N enum - サイズ定義）
- E-07: `tools/gen_outline_atomics.zig` 行160-206（Ordering enum - オーダー定義）
- E-08: `tools/gen_outline_atomics.zig` 行208（LdName enum）
- E-09: `tools/gen_outline_atomics.zig` 行210-269（generateCas関数）
- E-10: `tools/gen_outline_atomics.zig` 行271-296（generateSwp関数）
- E-11: `tools/gen_outline_atomics.zig` 行298-339（generateLd関数）
- E-12: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行11（バッチ情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AArch64のアウトラインアトミクス関数を生成 | E-02, E-12 | ○ |
| C-02 | LSEサポートを検出 | E-03 | ○ |
| C-03 | 引数なしで実行可能 | E-02 | ○ |
| C-04 | cas, swp, ldadd, ldclr, ldeor, ldsetをサポート | E-01 | ○ |
| C-05 | 1, 2, 4, 8, 16バイトをサポート | E-04, E-06 | ○ |
| C-06 | 16バイトはcasのみ | E-04 | ○ |
| C-07 | relax, acq, rel, acq_relをサポート | E-04, E-07 | ○ |
| C-08 | __aarch64_{op}{size}_{order}形式の関数名 | E-04 | ○ |
| C-09 | __aarch64_have_lse_atomicsフラグ | E-03 | ○ |
| C-10 | always_has_lseフラグ | E-03 | ○ |
| C-11 | 16バイトアラインメント | E-05 | ○ |
| C-12 | nakedコンベンション | E-05 | ○ |
| C-13 | .inst疑似命令でLSE命令エンコード | E-09, E-10, E-11 | ○ |
| C-14 | 非LSE実装はldxr/stxrループ | E-09, E-10, E-11 | ○ |
| C-15 | w15, w16, w17をクローバー | E-05 | ○ |
| C-16 | memory制約 | E-05 | ○ |
| C-17 | comptime { @export(...); }でエクスポート | E-02 | ○ |
| C-18 | サイズ別レジスタ（w/x） | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 生成されるインラインアセンブリが正しいか確認
- [ ] エクスポート宣言のフォーマットが正しいか確認
