---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：11-generate_linux_syscalls

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：明示的な根拠なし（推定値）
  2. **なし**
  3. **なし**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/generate_linux_syscalls.zig` 行1-12（ファイルヘッダーコメント）
- E-02: `tools/generate_linux_syscalls.zig` 行18-31（stdlib_renames定義）
- E-03: `tools/generate_linux_syscalls.zig` 行33-38（isReserved関数）
- E-04: `tools/generate_linux_syscalls.zig` 行40-76（Abi列挙型）
- E-05: `tools/generate_linux_syscalls.zig` 行78-81（オフセット定数）
- E-06: `tools/generate_linux_syscalls.zig` 行83-123（Arch構造体）
- E-07: `tools/generate_linux_syscalls.zig` 行125-171（architectures配列）
- E-08: `tools/generate_linux_syscalls.zig` 行173-260（main関数）
- E-09: `tools/generate_linux_syscalls.zig` 行251-260（usage関数）
- E-10: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行12

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Linuxカーネルソースからシステムコール番号を抽出 | E-01, E-08 | ○ |
| C-02 | カーネル6.11以降の統一テーブル形式に対応 | E-01 | ○ |
| C-03 | 22のアーキテクチャをサポート | E-07 | ○ |
| C-04 | stdlib_renamesによる名前変換 | E-02 | ○ |
| C-05 | reserved/available/unusedシステムコールの除外 | E-03 | ○ |
| C-06 | ABIフィルタリング機能 | E-04, E-06 | ○ |
| C-07 | x32システムコールビットのオフセット適用 | E-05, E-07 | ○ |
| C-08 | MIPSオフセット（O32, N64, N32）の適用 | E-05, E-07 | ○ |
| C-09 | ARM固有システムコールのフッター追加 | E-07 | ○ |
| C-10 | Makefileからバージョン情報を読み取る | E-08 | ○ |
| C-11 | 標準出力へZigコードを出力 | E-08, E-09 | ○ |
| C-12 | 入力パラメータとしてlinux_pathを受け取る | E-08, E-09 | ○ |
| C-13 | 汎用テーブル(scripts/syscall.tbl)の使用 | E-07, E-08 | ○ |
| C-14 | アーキテクチャ固有テーブルの使用 | E-07 | ○ |
| C-15 | enum(usize)形式での出力 | E-08 | ○ |
| C-16 | --helpオプションのサポート | E-08 | ○ |
| C-17 | 32KBのバッファサイズ | E-08 | ○ |
| C-18 | SemanticVersionでのバージョン管理 | E-08 | ○ |
| C-19 | X86, X64, X32の個別テーブル使用 | E-07 | ○ |
| C-20 | Sparc 32bit/64bitの分離 | E-07 | ○ |
| C-21 | PowerPC 32bit/64bitの分離 | E-07 | ○ |
| C-22 | RISC-V 32bit/64bitの分離 | E-07 | ○ |
| C-23 | コメント行(#で始まる)のスキップ | E-08 | ○ |
| C-24 | std.zig.fmtIdによる識別子フォーマット | E-08 | ○ |
| C-25 | 目標処理時間：数秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25 目標処理時間について
  - 明示的なパフォーマンス要件はソースコードに記載されていない
  - 推定値として「数秒以内」と記載したが、実測値に基づく検証が必要
  - 候補：実際の実行時間計測 / ベンチマークテスト / 開発者へのヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接読み取れる情報が大半
- 0: 低リスク - アーキテクチャリストは明確に定義されている
- 1: 中リスク - 将来のカーネルバージョンでテーブル形式が変更される可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 22アーキテクチャのリストが最新のソースコードと一致しているか確認
- [ ] stdlib_renamesのエントリが最新か確認
- [ ] ARM固有システムコールのリストが正確か確認
- [ ] 目標処理時間の妥当性を実測で検証
