---
generated_at: 2026-02-01 17:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：13-process_headers.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **処理時間**：数分は推定値
  2. **メモリ使用量**：2GBはコードから算出した最大値
  3. **ターゲット数**：各ABI のターゲット数は正確にカウント要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/process_headers.zig` ソースコード全体
- E-02: `tools/process_headers.zig:1-12` ドキュメントコメント
- E-03: `tools/process_headers.zig:29-62` glibc_targets配列
- E-04: `tools/process_headers.zig:64-81` musl_targets配列
- E-05: `tools/process_headers.zig:83-90` freebsd_targets配列
- E-06: `tools/process_headers.zig:92-105` netbsd_targets配列
- E-07: `tools/process_headers.zig:107-118` openbsd_targets配列
- E-08: `tools/process_headers.zig:120-130` Contents構造体
- E-09: `tools/process_headers.zig:136-142` LibCVendor列挙型
- E-10: `tools/process_headers.zig:144-348` main関数
- E-11: `tools/process_headers.zig:401-408` usageAndExit関数
- E-12: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` バッチ説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | glibc/musl/FreeBSD/NetBSD/OpenBSDのヘッダーを処理 | E-02, E-09 | ○ |
| C-02 | クロスコンパイル用の統合ヘッダーを生成 | E-02 | ○ |
| C-03 | genericサブディレクトリに共通ヘッダーを配置 | E-10 (373-376行) | ○ |
| C-04 | Blake3ハッシュで重複を検出 | E-10 (201, 298-301行) | ○ |
| C-05 | glibcターゲット32種 | E-03 | ○ |
| C-06 | muslターゲット16種 | E-04 | ○ |
| C-07 | FreeBSDターゲット6種 | E-05 | ○ |
| C-08 | NetBSDターゲット12種 | E-06 | ○ |
| C-09 | OpenBSDターゲット10種 | E-07 | ○ |
| C-10 | --search-path複数指定可能 | E-10 (164-165行) | ○ |
| C-11 | --outオプション必須 | E-10 (166-168, 180行) | ○ |
| C-12 | --abiオプション必須 | E-10 (169-171, 181行) | ○ |
| C-13 | 有効なABI: glibc/musl/freebsd/netbsd/openbsd | E-09, E-10 (182-184行) | ○ |
| C-14 | ターゲット未発見時に警告出力 | E-10 (346行) | ○ |
| C-15 | サマリーで削減可能バイト数を報告 | E-10 (349-352行) | ○ |
| C-16 | hit_countでソート | E-10 (369行), E-08 (126-129行) | ○ |
| C-17 | 2GBのファイル読み取りバッファ | E-10 (293行) | ○ |
| C-18 | 空白トリミング後にハッシュ計算 | E-10 (295行) | ○ |
| C-19 | muslはusr/local/musl/includeパス | E-10 (271行) | ○ |
| C-20 | 他ABIはusr/includeパス | E-10 (266-270行) | ○ |
| C-21 | generic-{abi}形式のディレクトリ名 | E-10 (187行) | ○ |
| C-22 | シンボリックリンクも処理対象 | E-10 (291行) | ○ |
| C-23 | 重複ファイルの情報をデバッグ出力 | E-10 (306-308行) | ○ |
| C-24 | 処理時間数分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 処理時間の数分という記述は実測値ではなく推定
  - 候補：実際のベンチマーク測定 / CI実行ログ / 開発者コメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ターゲットリストはソースコードで明確に定義
- 0: 低リスク - 出力ディレクトリ構造はコードで明確
- 1: 中リスク - dest設定のあるターゲットでのヘッダー上書き動作

## 6) レビュアーチェックリスト（最小）
- [ ] 各ABIのターゲット数がソースコードと一致することを確認
- [ ] glibcターゲットのdest設定が正確か確認
- [ ] musl/FreeBSD/NetBSD/OpenBSDのディレクトリパスが正確か確認
- [ ] Blake3ハッシュの計算ロジックが正しいか確認
