---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：14-update-linux-headers

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：明示的な根拠なし（推定値）
  2. **なし**
  3. **なし**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/update-linux-headers.zig` 行1-16（ファイルヘッダーコメント）
- E-02: `tools/update-linux-headers.zig` 行25-28（LibCTarget構造体）
- E-03: `tools/update-linux-headers.zig` 行30-48（MultiArch union）
- E-04: `tools/update-linux-headers.zig` 行50-107（linux_targets配列）
- E-05: `tools/update-linux-headers.zig` 行128-142（Contents構造体）
- E-06: `tools/update-linux-headers.zig` 行144-335（main関数）
- E-07: `tools/update-linux-headers.zig` 行313-326（bad_files配列）
- E-08: `tools/update-linux-headers.zig` 行329-335（usageAndExit関数）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行15

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Linuxカーネルヘッダーを処理 | E-01, E-09 | ○ |
| C-02 | Zigがシップするlibcヘッダーを生成 | E-01 | ○ |
| C-03 | 複数アーキテクチャをサポート | E-04 | ○ |
| C-04 | 14のアーキテクチャターゲット | E-04 | ○ |
| C-05 | MultiArchによるアーキテクチャ分類 | E-03 | ○ |
| C-06 | Blake3ハッシュでファイル重複検出 | E-06 | ○ |
| C-07 | any-linux-any汎用ディレクトリ | E-06 | ○ |
| C-08 | アーキテクチャ固有サブディレクトリ | E-06 | ○ |
| C-09 | hit_countによるgeneric判定 | E-05, E-06 | ○ |
| C-10 | --search-pathオプション | E-06, E-08 | ○ |
| C-11 | --outオプション | E-06, E-08 | ○ |
| C-12 | bad_filesの削除処理 | E-07 | ○ |
| C-13 | netfilterヘッダーの除外 | E-07 | ○ |
| C-14 | 2GB最大ファイルサイズ | E-06 | ○ |
| C-15 | ファイル内容のトリム処理 | E-06 | ○ |
| C-16 | DestTarget HashContext | E-06 | ○ |
| C-17 | PathTable, HashToContentsデータ構造 | E-06 | ○ |
| C-18 | ディレクトリスタック走査 | E-06 | ○ |
| C-19 | 重複検出時のログ出力 | E-06 | ○ |
| C-20 | 目標処理時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20 目標処理時間について
  - 明示的なパフォーマンス要件はソースコードに記載されていない
  - 処理対象のファイル数に依存するため、環境によって大きく異なる
  - 候補：実際の実行時間計測 / ベンチマークテスト / 開発者へのヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接読み取れる情報が大半
- 1: 中リスク - Linuxカーネルバージョンアップ時のヘッダー形式変更への追従
- 1: 中リスク - bad_filesリストが最新か確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] linux_targetsのアーキテクチャリストが最新か確認
- [ ] bad_filesリストが最新のLinuxカーネルと整合しているか確認
- [ ] MultiArchのアーキテクチャマッピングが正確か確認
- [ ] 目標処理時間の妥当性を実測で検証
